/*
 * Decompiled with CFR 0.152.
 */
package hu.NVL.NVLWarpdriveExtensions.DataClasses;

import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLCoordinates;

public class NVLDockProperties {
    private NVLCoordinates Coords = new NVLCoordinates();
    private String Owner = "";
    private String DockName = "";
    private String ShipName = "";

    public NVLDockProperties() {
    }

    public NVLDockProperties(NVLCoordinates newCoords, String newOwner, String newShipName, String newDockName) {
        this.setData(newCoords, newOwner, newShipName, newDockName);
    }

    public NVLDockProperties(String line) {
        this.fillDataFromString(line);
    }

    public void fillDataFromString(String line) {
        String[] params = line.split(",");
        if (params.length == 7) {
            this.Coords.dim = Integer.parseInt(params[0]);
            this.Coords.x = Integer.parseInt(params[1]);
            this.Coords.y = Integer.parseInt(params[2]);
            this.Coords.z = Integer.parseInt(params[3]);
            this.Owner = params[4];
            this.ShipName = params[5];
            this.DockName = params[6];
        }
        if (params.length == 8) {
            this.Coords.dim = Integer.parseInt(params[0]);
            this.Coords.x = Integer.parseInt(params[1]);
            this.Coords.y = Integer.parseInt(params[2]);
            this.Coords.z = Integer.parseInt(params[3]);
            this.Coords.ori = Integer.parseInt(params[4]);
            this.Owner = params[5];
            this.ShipName = params[6];
            this.DockName = params[7];
        }
    }

    public NVLCoordinates getCoords() {
        return this.Coords;
    }

    public String getOwnerName() {
        return this.Owner;
    }

    public String getDockName() {
        return this.DockName;
    }

    public String getShipName() {
        return this.ShipName;
    }

    public void setData(NVLCoordinates newCoords, String newOwner, String newShipName, String newDockName) {
        this.Coords.copyCoordinates(newCoords);
        this.Owner = newOwner;
        this.DockName = newDockName;
        this.ShipName = newShipName.replace(',', '_');
    }

    public void updateDockName(String newDockName) {
        this.DockName = newDockName;
    }

    public void updateShipName(String newShipName) {
        this.ShipName = newShipName;
    }

    public void updateOrientation(int newOri) {
        this.Coords.ori = newOri;
    }

    public boolean isValid() {
        return this.Coords.isValid() != false && !this.Owner.isEmpty() && !this.DockName.isEmpty() && !this.ShipName.isEmpty();
    }

    public String toString() {
        return this.Coords.toString() + "," + this.Owner + "," + this.ShipName + "," + this.DockName;
    }
}

