/*
 * Decompiled with CFR 0.152.
 */
package hu.NVL.NVLWarpdriveExtensions.DataClasses;

import net.minecraft.tileentity.TileEntity;

public class NVLCoordinates {
    public int dim;
    public int x;
    public int y;
    public int z;
    public int ori;

    public NVLCoordinates() {
        this.reset();
    }

    public NVLCoordinates(String line) {
        this.reset();
        this.fillDataFromString(line);
    }

    public NVLCoordinates(NVLCoordinates CopyFrom) {
        this.dim = CopyFrom.dim;
        this.x = CopyFrom.x;
        this.y = CopyFrom.y;
        this.z = CopyFrom.z;
        this.ori = CopyFrom.ori;
    }

    public NVLCoordinates(int Dimension, int ix, int iy, int iz, int io) {
        this.setCoords(Dimension, ix, iy, iz, io);
    }

    public void setCoords(int Dimension, int ix, int iy, int iz, int io) {
        this.dim = Dimension;
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.ori = io;
    }

    public NVLCoordinates(TileEntity te) {
        this.getCoordsFromTileEntity(te);
    }

    public void fillDataFromString(String line) {
        String[] params = line.split(",");
        if (params.length == 4) {
            this.dim = Integer.parseInt(params[0]);
            this.x = Integer.parseInt(params[1]);
            this.y = Integer.parseInt(params[2]);
            this.z = Integer.parseInt(params[3]);
            this.ori = -1;
        }
        if (params.length == 5) {
            this.dim = Integer.parseInt(params[0]);
            this.x = Integer.parseInt(params[1]);
            this.y = Integer.parseInt(params[2]);
            this.z = Integer.parseInt(params[3]);
            this.ori = Integer.parseInt(params[4]);
        }
    }

    public void copyCoordinates(NVLCoordinates Coords) {
        this.dim = Coords.dim;
        this.x = Coords.x;
        this.y = Coords.y;
        this.z = Coords.z;
        this.ori = Coords.ori;
    }

    public Boolean isValid() {
        return this.y >= 0 && this.y <= 255;
    }

    public void reset() {
        this.dim = -99999;
        this.x = 0;
        this.y = -1;
        this.z = 0;
        this.ori = -1;
    }

    public String toString() {
        return this.isValid() != false ? this.dim + "," + this.x + "," + this.y + "," + this.z + "," + this.ori : "invalid";
    }

    public void getCoordsFromTileEntity(TileEntity e) {
        this.dim = e.func_145831_w().field_73011_w.field_76574_g;
        this.x = e.field_145851_c;
        this.y = e.field_145848_d;
        this.z = e.field_145849_e;
        this.ori = -1;
    }

    public boolean isCoordinatesNear(NVLCoordinates check) {
        return check.dim == this.dim && check.x > this.x - 8 && check.x < this.x + 8 && check.y > this.y - 2 && check.y < this.y + 2 && check.z > this.z - 8 && check.z < this.z + 8;
    }

    public boolean isMatch(NVLCoordinates check) {
        return check.dim == this.dim && check.x == this.x && check.y == this.y && check.z == this.z;
    }
}

