/*
 * Decompiled with CFR 0.152.
 */
package hu.NVL.NVLWarpdriveExtensions.Common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLBlockRef;
import hu.NVL.NVLWarpdriveExtensions.DataClasses.NVLCoordinates;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class NVLCommonFunctions {
    public static final int BOTTOM = 0;
    public static final int TOP = 1;
    public static final int NORTH = 2;
    public static final int SOUTH = 3;
    public static final int WEST = 4;
    public static final int EAST = 5;
    private File gfh;
    private File cfh;
    private File sfh = null;
    private String MODName = "";
    private Boolean EnableLogging = true;

    public NVLCommonFunctions(String Owner) {
        this.MODName = Owner;
        if (this.EnableLogging.booleanValue()) {
            this.gfh = this.prepareLogFile("Logs");
            this.cfh = this.prepareLogFile("ClientLogs");
            this.sfh = this.prepareLogFile("ServerLogs");
        }
    }

    public String getModID() {
        return this.MODName;
    }

    public void logLine(String module, String message) {
        if (this.EnableLogging.booleanValue()) {
            String part = "C";
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                part = "S";
            }
            if (this.gfh != null) {
                this.feedIntoLog(this.gfh, "[" + this.MODName + "] " + part + " [" + module + "] " + message);
            } else {
                System.out.println(part + "[" + module + "] " + message);
            }
            if (this.sfh != null && part == "S") {
                this.feedIntoLog(this.sfh, "[" + this.MODName + "][" + module + "] " + message);
            }
            if (this.cfh != null && part == "C") {
                this.feedIntoLog(this.cfh, "[" + this.MODName + "][" + module + "] " + message);
            }
        }
    }

    private void feedIntoLog(File lfh, String Message) {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(lfh, true));
            out.println(Message);
            out.close();
        }
        catch (IOException e) {
            System.out.println("NVLCommon:IOException:" + e);
        }
    }

    private File prepareLogFile(String Name) {
        File fld;
        File fh = null;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            fld = MinecraftServer.func_71276_C().func_71209_f("logs/NVL");
            if (!fld.exists()) {
                System.out.println("S NVLCommon: MKDir result: " + fld.mkdir());
            }
            if (!(fh = MinecraftServer.func_71276_C().func_71209_f("logs/NVL/" + Name + ".txt")).exists()) {
                try {
                    System.out.println("S NVLCommon:CreateFile result: " + fh.createNewFile());
                }
                catch (IOException e) {
                    System.out.println("S NVLCommon:CreateFile exception: " + e.toString());
                }
            }
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            fld = new File("logs/NVL");
            if (!fld.exists()) {
                System.out.println("C NVLCommon: MKDir result: " + fld.mkdir());
            }
            if (!(fh = new File("logs/NVL/" + Name + ".txt")).exists()) {
                try {
                    System.out.println("C NVLCommon:CreateFile result: " + fh.createNewFile());
                }
                catch (IOException e) {
                    System.out.println("C NVLCommon:CreateFile exception: " + e.toString());
                }
            }
        }
        return fh;
    }

    public static void setBlock(World w, int x, int y, int z) {
        w.func_147468_f(x, y, z);
    }

    public static void setBlock(World w, int x, int y, int z, NVLBlockRef b) {
        w.func_147449_b(x, y, z, b.block);
    }

    public static NVLBlockRef GetBlock(World w, int x, int y, int z) {
        NVLBlockRef r = new NVLBlockRef(w.func_147439_a(x, y, z));
        return r;
    }

    public static NVLBlockRef NVLGetBlockByDirection(World world, int ax, int ay, int az, int rx, int ry, int rz, int Direction) {
        NVLBlockRef r = new NVLBlockRef();
        switch (Direction) {
            case 0: {
                r.block = world.func_147439_a(ax - rx, ay + ry, az + rz);
                r.meta = world.func_72805_g(ax - rx, ay + ry, az + rz);
                break;
            }
            case 1: {
                r.block = world.func_147439_a(ax - rz, ay + ry, az - rx);
                r.meta = world.func_72805_g(ax - rz, ay + ry, az - rx);
                break;
            }
            case 2: {
                r.block = world.func_147439_a(ax + rx, ay + ry, az - rz);
                r.meta = world.func_72805_g(ax + rx, ay + ry, az - rz);
                break;
            }
            case 3: {
                r.block = world.func_147439_a(ax + rz, ay + ry, az + rx);
                r.meta = world.func_72805_g(ax + rz, ay + ry, az + rx);
            }
        }
        return r;
    }

    public static void NVLSetBlocksByDirection(World world, int ax, int ay, int az, int rx, int ry, int rz, int Num, int Direction) {
        NVLCommonFunctions.NVLSetBlocksByDirection(world, ax, ay, az, rx, ry, rz, Num, Direction, 0, NVLBlockRef.getRef(Blocks.field_150350_a));
    }

    public static void NVLSetBlocksByDirection(World world, int ax, int ay, int az, int rx, int ry, int rz, int Num, int Direction, NVLBlockRef b) {
        NVLCommonFunctions.NVLSetBlocksByDirection(world, ax, ay, az, rx, ry, rz, Num, Direction, 0, b);
    }

    public static void NVLSetBlocksByDirection(World world, int ax, int ay, int az, int rx, int ry, int rz, int Num, int Direction, int Data, NVLBlockRef b) {
        NVLCommonFunctions.NVLSetBlocksByDirection(world, ax, ay, az, rx, ry, rz, 1, 1, Num, Direction, Data, b);
    }

    public static void NVLSetBlocksByDirection(World world, int ax, int ay, int az, int rx, int ry, int rz, int XNum, int YNum, int ZNum, int Direction, int Data, NVLBlockRef b) {
        for (int i = 0; i < XNum; ++i) {
            for (int j = 0; j < YNum; ++j) {
                block8: for (int k = 0; k < ZNum; ++k) {
                    switch (Direction) {
                        case 0: {
                            world.func_147465_d(ax - rx - i, ay + ry + j, az + rz + k, b.block, Data, 2);
                            continue block8;
                        }
                        case 1: {
                            world.func_147465_d(ax - rz - k, ay + ry + j, az - rx - i, b.block, Data, 2);
                            continue block8;
                        }
                        case 2: {
                            world.func_147465_d(ax + rx + i, ay + ry + j, az - rz - k, b.block, Data, 2);
                            continue block8;
                        }
                        case 3: {
                            world.func_147465_d(ax + rz + k, ay + ry + j, az + rx + i, b.block, Data, 2);
                        }
                    }
                }
            }
        }
    }

    public static void addChatMessage(ICommandSender sender, String message) {
        String[] lines;
        for (String line : lines = message.replace("\\n", "\n").split("\n")) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(line));
        }
    }

    public static boolean isServerDedicated() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S();
    }

    private static int getNormalizedYaw(int originalYaw) {
        return originalYaw < 0 ? originalYaw % 360 + 360 : originalYaw % 360;
    }

    public static int NVLGetPlayerDirection(EntityPlayer entity) {
        return (NVLCommonFunctions.getNormalizedYaw((int)entity.field_70177_z) + 45) % 360 / 90;
    }

    public static int NVLGetPlayerDirectionDiagonal(EntityPlayer entity) {
        return (NVLCommonFunctions.getNormalizedYaw((int)entity.field_70177_z) + 45) % 360 / 45;
    }

    public static int NVLGetPlayerRelativeTurn(EntityPlayer entity) {
        int yaw = (int)entity.field_70177_z;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += 45;
        return (yaw %= 90) < 45 ? 1 : -1;
    }

    public static String getDyeColorName(int index) {
        String r = "";
        if (index >= 0 && index < 16) {
            r = ItemDye.field_150921_b[index];
        }
        return r;
    }

    public boolean isIC2Present() {
        return Loader.isModLoaded((String)"IC2");
    }

    public String createNVLFolder() {
        File fld;
        String r = "";
        if (NVLCommonFunctions.isServerDedicated()) {
            r = MinecraftServer.func_71276_C().func_71270_I() + "/NVL";
            fld = MinecraftServer.func_71276_C().func_71209_f(r);
        } else {
            r = "saves/" + Minecraft.func_71410_x().func_71401_C().func_71221_J() + "/NVL";
            fld = new File(r);
        }
        if (!fld.exists()) {
            fld.mkdir();
        }
        return r;
    }

    public static void getIncrementMatrixFromDirection(NVLCoordinates TransformMatrix, int Direction) {
        TransformMatrix.reset();
        TransformMatrix.y = 0;
        if (Direction >= 0 && Direction < 6) {
            switch (Direction) {
                case 0: {
                    --TransformMatrix.y;
                    break;
                }
                case 1: {
                    ++TransformMatrix.y;
                    break;
                }
                case 2: {
                    --TransformMatrix.z;
                    break;
                }
                case 3: {
                    ++TransformMatrix.z;
                    break;
                }
                case 4: {
                    --TransformMatrix.x;
                    break;
                }
                case 5: {
                    ++TransformMatrix.x;
                }
            }
        }
    }

    public static void applyTransform(NVLCoordinates Coords, int Dir, int Dist, int Ys) {
        NVLCoordinates Temp = new NVLCoordinates();
        NVLCommonFunctions.getIncrementMatrixFromDirection(Temp, Dir);
        Coords.x += Temp.x * Dist;
        Coords.y += Temp.y * Dist + Ys;
        Coords.z += Temp.z * Dist;
    }

    public static int getOppositeDirection(int Direction) {
        int r = -1;
        if (Direction >= 0 && Direction < 6) {
            r = Direction % 2 == 0 ? Direction + 1 : Direction - 1;
        }
        return r;
    }
}

