/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.teleport;

import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TeleportEntityNetherPortal {
    public ForgeDirection portalAxis = ForgeDirection.UNKNOWN;
    public ForgeDirection teleportSide = ForgeDirection.UNKNOWN;
    public int portalPosX = 0;
    public int portalPosY = 0;
    public int portalPosZ = 0;
    public double entityPosX = 0.0;
    public double entityPosY = 0.0;
    public double entityPosZ = 0.0;

    public Entity travelToDimension(Entity entity, int dimension, double idealX, double idealY, double idealZ, int portalSearchRadius, boolean placeInsidePortal) {
        WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(dimension);
        if (!this.searchForExistingPortal((World)worldServer, idealX, idealY, idealZ, portalSearchRadius)) {
            double origX = entity.field_70165_t;
            double origY = entity.field_70163_u;
            double origZ = entity.field_70161_v;
            entity.field_70165_t = idealX;
            entity.field_70163_u = idealY;
            entity.field_70161_v = idealZ;
            worldServer.func_85176_s().func_85188_a(entity);
            entity.field_70165_t = origX;
            entity.field_70163_u = origY;
            entity.field_70161_v = origZ;
            if (!this.searchForExistingPortal((World)worldServer, idealX, idealY, idealZ, 20)) {
                return null;
            }
        }
        this.getTeleportPosition((World)worldServer, placeInsidePortal);
        return TeleportEntity.teleportEntity(entity, this.entityPosX, this.entityPosY, this.entityPosZ, dimension, true, true);
    }

    public boolean searchForExistingPortal(World world, double idealX, double idealY, double idealZ, int searchRadius) {
        double distance = -1.0;
        int x = (int)idealX - searchRadius;
        while ((double)x <= idealX + (double)searchRadius) {
            double dx = (double)x + 0.5 - idealX;
            int z = (int)idealZ - searchRadius;
            while ((double)z <= idealZ + (double)searchRadius) {
                double dz = (double)z + 0.5 - idealZ;
                for (int y = world.func_72940_L() - 1; y >= 0; --y) {
                    if (world.func_147439_a(x, y, z) != Blocks.field_150427_aO) continue;
                    while (world.func_147439_a(x, y - 1, z) == Blocks.field_150427_aO) {
                        --y;
                    }
                    double dy = (double)y + 0.5 - idealY;
                    double tdist = dx * dx + dy * dy + dz * dz;
                    if (!(distance < 0.0) && !(tdist < distance)) continue;
                    distance = tdist;
                    this.portalPosX = x;
                    this.portalPosY = y;
                    this.portalPosZ = z;
                }
                ++z;
            }
            ++x;
        }
        if (distance >= 0.0) {
            this.getPortalOrientation(world);
        }
        return distance >= 0.0;
    }

    public void getPortalOrientation(World world) {
        if (world.func_147439_a(this.portalPosX - 1, this.portalPosY, this.portalPosZ) == Blocks.field_150427_aO || world.func_147439_a(this.portalPosX + 1, this.portalPosY, this.portalPosZ) == Blocks.field_150427_aO) {
            this.portalAxis = ForgeDirection.EAST;
        } else if (world.func_147439_a(this.portalPosX, this.portalPosY, this.portalPosZ - 1) == Blocks.field_150427_aO || world.func_147439_a(this.portalPosX, this.portalPosY, this.portalPosZ + 1) == Blocks.field_150427_aO) {
            this.portalAxis = ForgeDirection.SOUTH;
        }
    }

    public void getTeleportPosition(World world, boolean placeInsidePortal) {
        if (placeInsidePortal) {
            this.entityPosX = (double)this.portalPosX + 0.5;
            this.entityPosY = (double)this.portalPosY + 0.5;
            this.entityPosZ = (double)this.portalPosZ + 0.5;
        } else {
            ForgeDirection dirSide = this.portalAxis.getRotation(ForgeDirection.UP);
            ForgeDirection dirPortal = this.portalAxis;
            if (world.func_147439_a(this.portalPosX + dirPortal.offsetX, this.portalPosY, this.portalPosZ + dirPortal.offsetZ) != Blocks.field_150427_aO) {
                dirPortal = dirPortal.getOpposite();
            }
            ArrayList<BlockPosEU> list = new ArrayList<BlockPosEU>(8);
            list.add(new BlockPosEU(this.portalPosX + dirSide.offsetX, this.portalPosY - 1, this.portalPosZ + dirSide.offsetZ));
            list.add(new BlockPosEU(this.portalPosX + dirSide.offsetX, this.portalPosY - 2, this.portalPosZ + dirSide.offsetZ));
            list.add(new BlockPosEU(this.portalPosX + dirSide.offsetX + dirPortal.offsetX, this.portalPosY - 1, this.portalPosZ + dirSide.offsetZ + dirPortal.offsetZ));
            list.add(new BlockPosEU(this.portalPosX + dirSide.offsetX + dirPortal.offsetX, this.portalPosY - 2, this.portalPosZ + dirSide.offsetZ + dirPortal.offsetZ));
            list.add(new BlockPosEU(this.portalPosX - dirSide.offsetX, this.portalPosY - 1, this.portalPosZ - dirSide.offsetZ));
            list.add(new BlockPosEU(this.portalPosX - dirSide.offsetX, this.portalPosY - 2, this.portalPosZ - dirSide.offsetZ));
            list.add(new BlockPosEU(this.portalPosX - dirSide.offsetX + dirPortal.offsetX, this.portalPosY - 1, this.portalPosZ - dirSide.offsetZ + dirPortal.offsetZ));
            list.add(new BlockPosEU(this.portalPosX - dirSide.offsetX + dirPortal.offsetX, this.portalPosY - 2, this.portalPosZ - dirSide.offsetZ + dirPortal.offsetZ));
            for (BlockPosEU pos : list) {
                if (!World.func_147466_a((IBlockAccess)world, (int)pos.posX, (int)pos.posY, (int)pos.posZ) || !world.func_147437_c(pos.posX, pos.posY + 1, pos.posZ) || !world.func_147437_c(pos.posX, pos.posY + 2, pos.posZ)) continue;
                this.entityPosX = (double)pos.posX + 0.5;
                this.entityPosY = (double)pos.posY + 1.5;
                this.entityPosZ = (double)pos.posZ + 0.5;
                return;
            }
            for (BlockPosEU pos : list) {
                if (!world.func_147437_c(pos.posX, pos.posY, pos.posZ) || !world.func_147437_c(pos.posX, pos.posY + 1, pos.posZ) || !world.func_147437_c(pos.posX, pos.posY + 2, pos.posZ)) continue;
                world.func_147465_d(pos.posX, pos.posY, pos.posZ, Blocks.field_150347_e, 0, 3);
                this.entityPosX = (double)pos.posX + 0.5;
                this.entityPosY = (double)pos.posY + 1.5;
                this.entityPosZ = (double)pos.posZ + 0.5;
                return;
            }
            this.entityPosX = (double)(this.portalPosX + dirSide.offsetX) + 0.5;
            this.entityPosY = (double)this.portalPosY + 0.5;
            this.entityPosZ = (double)(this.portalPosZ + dirSide.offsetZ) + 0.5;
        }
    }
}

