/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.DimensionManager;

public class EnergyBridgeTracker {
    private static boolean dirty = false;
    private static List<BlockPosEU> bridgeLocations = new ArrayList<BlockPosEU>();
    private static TIntObjectHashMap<Integer> bridgeCounts = new TIntObjectHashMap();

    public static void addBridgeLocation(BlockPosEU pos) {
        EnergyBridgeTracker.addBridgeLocation(pos, true);
    }

    private static void addBridgeLocation(BlockPosEU pos, boolean markDirty) {
        Integer count = (Integer)bridgeCounts.get(pos.dimension);
        if (count == null) {
            count = 0;
        }
        bridgeCounts.put(pos.dimension, (Object)(count + 1));
        if (!bridgeLocations.contains(pos)) {
            bridgeLocations.add(pos);
        }
        if (markDirty) {
            dirty = true;
        }
    }

    public static void removeBridgeLocation(BlockPosEU pos) {
        Integer count = (Integer)bridgeCounts.get(pos.dimension);
        if (count == null) {
            count = 1;
        }
        if (bridgeLocations.remove(pos)) {
            bridgeCounts.put(pos.dimension, (Object)(count - 1));
        }
        dirty = true;
    }

    public static boolean dimensionHasEnergyBridge(int dimension) {
        Integer count = (Integer)bridgeCounts.get(dimension);
        return count != null && count > 0;
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("EnergyBridges", 9)) {
            return;
        }
        NBTTagList tagList = nbt.func_150295_c("EnergyBridges", 10);
        int count = tagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (!tag.func_150297_b("Dim", 3) || !tag.func_150297_b("posX", 3) || !tag.func_150297_b("posY", 3) || !tag.func_150297_b("posZ", 3)) continue;
            EnergyBridgeTracker.addBridgeLocation(new BlockPosEU(tag.func_74762_e("posX"), tag.func_74762_e("posY"), tag.func_74762_e("posZ"), tag.func_74762_e("Dim"), 1), false);
        }
    }

    public static NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        int count = bridgeLocations.size();
        if (count > 0) {
            NBTTagList tagList = new NBTTagList();
            for (int i = 0; i < count; ++i) {
                BlockPosEU pos = bridgeLocations.get(i);
                if (pos == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("Dim", pos.dimension);
                tag.func_74768_a("posX", pos.posX);
                tag.func_74768_a("posY", pos.posY);
                tag.func_74768_a("posZ", pos.posZ);
                tagList.func_74742_a((NBTBase)tag);
            }
            if (tagList.func_74745_c() > 0) {
                nbt.func_74782_a("EnergyBridges", (NBTBase)tagList);
            }
        }
        return nbt;
    }

    public static void readFromDisk() {
        bridgeLocations.clear();
        bridgeCounts.clear();
        try {
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null) {
                return;
            }
            File file = new File(new File(saveDir, "enderutilities"), "energybridges.dat");
            if (file.exists() && file.isFile()) {
                EnergyBridgeTracker.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
            }
        }
        catch (Exception e) {
            EnderUtilities.logger.warn("Failed to read Energy Bridge data from file!");
        }
    }

    public static void writeToDisk() {
        if (!dirty) {
            return;
        }
        try {
            File saveDir = DimensionManager.getCurrentSaveRootDirectory();
            if (saveDir == null) {
                return;
            }
            if (!(saveDir = new File(saveDir, "enderutilities")).exists() && !saveDir.mkdirs()) {
                EnderUtilities.logger.warn("Failed to create the save directory '" + saveDir + "'");
                return;
            }
            File fileTmp = new File(saveDir, "energybridges.dat.tmp");
            File fileReal = new File(saveDir, "energybridges.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)EnergyBridgeTracker.writeToNBT(new NBTTagCompound()), (OutputStream)new FileOutputStream(fileTmp));
            if (fileReal.exists()) {
                fileReal.delete();
            }
            fileTmp.renameTo(fileReal);
            dirty = false;
        }
        catch (Exception e) {
            EnderUtilities.logger.warn("Failed to write Energy Bridge data to file!");
        }
    }
}

