/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiTemplatedChest;
import fi.dy.masa.enderutilities.inventory.ContainerTemplatedChest;
import fi.dy.masa.enderutilities.tileentity.ITieredStorage;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;

public class TileEntityTemplatedChest
extends TileEntityEnderUtilitiesInventory
implements ITieredStorage {
    public static final int[] INV_SIZES = new int[]{9, 27, 54};
    protected ItemStack[] templateStacks = new ItemStack[54];
    protected List<Integer> enabledTemplateSlots = new ArrayList<Integer>();
    protected int chestTier;
    protected long templateMask;

    public TileEntityTemplatedChest() {
        super("templatedchest", 9);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.chestTier = MathHelper.func_76125_a((int)nbt.func_74771_c("ChestTier"), (int)0, (int)2);
        this.invSize = INV_SIZES[this.chestTier];
        this.setTemplateMask(nbt.func_74763_f("TemplateMask"));
        super.readFromNBTCustom(nbt);
        this.templateStacks = this.readItemsFromNBT(nbt, this.invSize, "TemplateItems");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        nbt.func_74774_a("ChestTier", (byte)this.chestTier);
        nbt.func_74772_a("TemplateMask", this.templateMask);
        this.writeItemsToNBT(nbt, this.templateStacks, "TemplateItems");
        super.func_145841_b(nbt);
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        nbt = super.getDescriptionPacketTag(nbt);
        nbt.func_74774_a("tier", (byte)this.chestTier);
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        this.chestTier = nbt.func_74771_c("tier");
        this.invSize = INV_SIZES[this.chestTier];
        this.itemStacks = new ItemStack[this.invSize];
        this.templateStacks = new ItemStack[this.invSize];
        super.onDataPacket(net, packet);
    }

    @Override
    public int func_70302_i_() {
        return this.invSize;
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack stack) {
        if (this.templateMask == 0L || stack == null || this.itemStacks[slotNum] != null) {
            return true;
        }
        int max = Math.min(this.func_70297_j_(), stack.func_77976_d());
        for (int i : this.enabledTemplateSlots) {
            if (slotNum == i) {
                return InventoryUtils.areItemStacksEqual(stack, this.templateStacks[slotNum]);
            }
            if (this.itemStacks[i] != null && this.itemStacks[i].field_77994_a >= max || !InventoryUtils.areItemStacksEqual(stack, this.templateStacks[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getStorageTier() {
        return this.chestTier;
    }

    @Override
    public void setStorageTier(int tier) {
        this.chestTier = tier = MathHelper.func_76125_a((int)tier, (int)0, (int)2);
        this.invSize = INV_SIZES[this.chestTier];
        this.itemStacks = new ItemStack[this.invSize];
        this.templateStacks = new ItemStack[this.invSize];
    }

    public long getTemplateMask() {
        return this.templateMask;
    }

    public void toggleTemplateMask(int slotNum) {
        this.setTemplateMask(this.templateMask ^ 1L << slotNum);
    }

    public void setTemplateMask(long mask) {
        this.templateMask = mask;
        this.enabledTemplateSlots.clear();
        long bit = 1L;
        int i = 0;
        while (i < this.invSize) {
            if ((this.templateMask & bit) != 0L) {
                this.enabledTemplateSlots.add(i);
            }
            ++i;
            bit <<= 1;
        }
    }

    public ItemStack getTemplateStack(int slotNum) {
        if (this.templateStacks != null && slotNum < this.templateStacks.length) {
            return this.templateStacks[slotNum];
        }
        return null;
    }

    public void setTemplateStack(int slotNum, ItemStack stack) {
        if (this.templateStacks != null && slotNum < this.templateStacks.length) {
            this.templateStacks[slotNum] = stack;
        }
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public ContainerTemplatedChest getContainer(EntityPlayer player) {
        return new ContainerTemplatedChest(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiTemplatedChest(this.getContainer(player), this);
    }
}

