/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.inventory.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityEnderUtilitiesInventory
extends TileEntityEnderUtilities
implements IInventory {
    protected String customInventoryName;
    protected ItemStack[] itemStacks;
    protected int invSize;
    protected int invStackLimit;

    public TileEntityEnderUtilitiesInventory(String name, int invSize) {
        super(name);
        this.invSize = invSize;
        this.invStackLimit = 64;
        this.itemStacks = new ItemStack[this.invSize];
    }

    public void setInventoryName(String name) {
        this.customInventoryName = name;
    }

    public boolean func_145818_k_() {
        return this.customInventoryName != null && this.customInventoryName.length() > 0;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customInventoryName : "enderutilities.container." + this.tileEntityName;
    }

    public ItemStack[] readItemsFromNBT(NBTTagCompound nbt, int invSize, String tagName) {
        ItemStack[] stacks = new ItemStack[invSize];
        NBTTagList nbtTagList = nbt.func_150295_c(tagName, 10);
        int numSlots = nbtTagList.func_74745_c();
        for (int i = 0; i < numSlots; ++i) {
            NBTTagCompound tagItem = nbtTagList.func_150305_b(i);
            byte slotNum = tagItem.func_74771_c("Slot");
            if (slotNum >= 0 && slotNum < stacks.length) {
                stacks[slotNum] = ItemStack.func_77949_a((NBTTagCompound)tagItem);
                if (stacks[slotNum] == null || !tagItem.func_150297_b("ActualCount", 3)) continue;
                stacks[slotNum].field_77994_a = tagItem.func_74762_e("ActualCount");
                continue;
            }
            String str = String.format("Invalid slot number while reading inventory from NBT; got: %d, max: %d (TE location: x: %d y: %d, z: %d)", slotNum, this.itemStacks.length - 1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            EnderUtilities.logger.warn(((Object)((Object)this)).getClass().getSimpleName() + ": " + str);
        }
        return stacks;
    }

    public void writeItemsToNBT(NBTTagCompound nbt, ItemStack[] stacks, String tagName) {
        if (stacks == null) {
            return;
        }
        NBTTagList nbtTagList = new NBTTagList();
        int numSlots = stacks != null ? stacks.length : 0;
        for (int i = 0; i < numSlots; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound tagItem = new NBTTagCompound();
            stacks[i].func_77955_b(tagItem);
            tagItem.func_74774_a("Slot", (byte)i);
            tagItem.func_74768_a("ActualCount", stacks[i].field_77994_a);
            nbtTagList.func_74742_a((NBTBase)tagItem);
        }
        nbt.func_74782_a(tagName, (NBTBase)nbtTagList);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customInventoryName = nbt.func_74779_i("CustomName");
        }
        this.itemStacks = this.readItemsFromNBT(nbt, this.invSize, "Items");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customInventoryName);
        }
        this.writeItemsToNBT(nbt, this.itemStacks, "Items");
    }

    public int func_70302_i_() {
        if (this.itemStacks != null) {
            return this.itemStacks.length;
        }
        return 0;
    }

    public ItemStack func_70301_a(int slotNum) {
        if (slotNum >= this.itemStacks.length) {
            return null;
        }
        return this.itemStacks[slotNum];
    }

    public ItemStack func_70298_a(int slotNum, int maxAmount) {
        if (slotNum >= this.itemStacks.length) {
            return null;
        }
        if (this.itemStacks[slotNum] != null) {
            ItemStack stack;
            if (this.itemStacks[slotNum].field_77994_a >= maxAmount) {
                stack = this.itemStacks[slotNum].func_77979_a(maxAmount);
                if (this.itemStacks[slotNum].field_77994_a <= 0) {
                    this.itemStacks[slotNum] = null;
                }
            } else {
                stack = this.itemStacks[slotNum];
                this.itemStacks[slotNum] = null;
            }
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotNum) {
        if (slotNum >= this.itemStacks.length) {
            return null;
        }
        ItemStack stack = this.itemStacks[slotNum];
        this.itemStacks[slotNum] = null;
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int slotNum, ItemStack stack) {
        if (slotNum >= this.itemStacks.length) {
            return;
        }
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.itemStacks[slotNum] = stack;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.invStackLimit;
    }

    public boolean func_94041_b(int slotNum, ItemStack itemStack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) >= 64.0);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ContainerEnderUtilities getContainer(EntityPlayer player) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return null;
    }

    public void performGuiAction(EntityPlayer player, int action, int element) {
    }
}

