/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.inventory.ICustomSlotSync;
import fi.dy.masa.enderutilities.network.message.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class MessageSyncCustomSlot
implements IMessage,
IMessageHandler<MessageSyncCustomSlot, IMessage> {
    private int windowId;
    private int typeId;
    private int slotNum;
    private ItemStack stack;

    public MessageSyncCustomSlot() {
    }

    public MessageSyncCustomSlot(int windowId, int typeId, int slotNum, ItemStack stack) {
        this.windowId = windowId;
        this.typeId = typeId;
        this.slotNum = slotNum;
        this.stack = stack;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readByte();
        this.typeId = buf.readByte();
        this.slotNum = buf.readShort();
        this.stack = ByteBufUtils.readItemStackFromBuffer(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.windowId);
        buf.writeByte(this.typeId);
        buf.writeShort(this.slotNum);
        ByteBufUtils.writeItemStackToBuffer(buf, this.stack);
    }

    public IMessage onMessage(MessageSyncCustomSlot message, MessageContext ctx) {
        EntityPlayer player = EnderUtilities.proxy.getPlayerFromMessageContext(ctx);
        if (player.field_71070_bA instanceof ICustomSlotSync && message.windowId == player.field_71070_bA.field_75152_c) {
            ICustomSlotSync target = (ICustomSlotSync)player.field_71070_bA;
            target.putCustomStack(message.typeId, message.slotNum, message.stack);
        }
        return null;
    }
}

