/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.item.ItemHandyBag;
import fi.dy.masa.enderutilities.item.ItemInventorySwapper;
import fi.dy.masa.enderutilities.item.ItemPickupManager;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class MessageGuiAction
implements IMessage,
IMessageHandler<MessageGuiAction, IMessage> {
    private int guiId;
    private int action;
    private int elementId;
    private int dimension;
    private int posX;
    private int posY;
    private int posZ;

    public MessageGuiAction() {
    }

    public MessageGuiAction(int dim, int x, int y, int z, int guiId, int action, int elementId) {
        this.dimension = dim;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.guiId = guiId;
        this.action = action;
        this.elementId = elementId;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.guiId = buf.readInt();
        this.action = buf.readShort();
        this.elementId = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeInt(this.guiId);
        buf.writeShort(this.action);
        buf.writeShort(this.elementId);
    }

    public IMessage onMessage(MessageGuiAction message, MessageContext ctx) {
        EntityPlayer player = EnderUtilities.proxy.getPlayerFromMessageContext(ctx);
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(message.dimension);
        if (player != null && world != null) {
            switch (message.guiId) {
                case 0: {
                    TileEntity te = world.func_147438_o(message.posX, message.posY, message.posZ);
                    if (te == null || !(te instanceof TileEntityEnderUtilitiesInventory)) break;
                    ((TileEntityEnderUtilitiesInventory)te).performGuiAction(player, message.action, message.elementId);
                    break;
                }
                case 1001: {
                    ItemHandyBag.performGuiAction(player, message.action, message.elementId);
                    break;
                }
                case 1002: {
                    ItemInventorySwapper.performGuiAction(player, message.action, message.elementId);
                    break;
                }
                case 1003: {
                    ItemPickupManager.performGuiAction(player, message.action, message.elementId);
                    break;
                }
            }
        }
        return null;
    }
}

