/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class ByteBufUtils {
    public static void writeItemStackToBuffer(ByteBuf buf, ItemStack stack) {
        if (stack == null) {
            buf.writeShort(-1);
            return;
        }
        buf.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
        buf.writeShort(stack.func_77960_j());
        buf.writeInt(stack.field_77994_a);
        NBTTagCompound tag = null;
        if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
            tag = stack.func_77978_p();
        }
        ByteBufUtils.writeNBTTagCompoundToBuffer(buf, tag);
    }

    public static ItemStack readItemStackFromBuffer(ByteBuf buf) {
        ItemStack stack = null;
        short id = buf.readShort();
        if (id >= 0) {
            short meta = buf.readShort();
            int stackSize = buf.readInt();
            stack = new ItemStack(Item.func_150899_d((int)id), stackSize, (int)meta);
            stack.func_77982_d(ByteBufUtils.readNBTTagCompoundFromBuffer(buf));
        }
        return stack;
    }

    public static void writeNBTTagCompoundToBuffer(ByteBuf buf, NBTTagCompound tag) {
        if (tag == null) {
            buf.writeShort(-1);
            return;
        }
        try {
            byte[] byteArr = CompressedStreamTools.func_74798_a((NBTTagCompound)tag);
            buf.writeShort((int)((short)byteArr.length));
            buf.writeBytes(byteArr);
        }
        catch (IOException e) {
            EnderUtilities.logger.error("IOException while trying to write a NBTTagCompound to ByteBuf");
        }
    }

    public static NBTTagCompound readNBTTagCompoundFromBuffer(ByteBuf buf) {
        short length = buf.readShort();
        if (length < 0) {
            return null;
        }
        byte[] byteArr = new byte[length];
        buf.readBytes(byteArr);
        NBTTagCompound tag = null;
        try {
            tag = CompressedStreamTools.func_152457_a((byte[])byteArr, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException e) {
            EnderUtilities.logger.error("IOException while trying to read a NBTTagCompound from ByteBuf");
        }
        return tag;
    }
}

