/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemRuler
extends ItemModular {
    public static final boolean DISTANCE_MODE_DIMENSIONS = false;
    public static final boolean DISTANCE_MODE_DIFFERENCE = true;
    public static final boolean POS_START = true;
    public static final boolean POS_END = false;
    public static final String TAG_WRAPPER = "Ruler";
    public static final String TAG_DISTANCE_MODE = "DistanceMode";
    public static final String TAG_RENDER_WHEN_UNSELECTED = "RenderUnselected";
    public static final String TAG_RENDER_ALL = "RenderAll";
    public static final String TAG_RENDER_WITH_ALL = "RenderWithAll";
    public static final String TAG_LOCATIONS = "Locations";
    public static final String TAG_SELECTED_LOCATION = "SelLocation";
    protected Map<UUID, Long> lastLeftClick;

    public ItemRuler() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("ruler");
        this.lastLeftClick = new HashMap<UUID, Long>();
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 6L) {
            this.setOrRemovePosition(stack, new BlockPosEU(x, y, z, player.field_71093_bK, side), true, !player.func_70093_af());
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
        return true;
    }

    public void onLeftClickBlock(EntityPlayer player, World world, ItemStack stack, int x, int y, int z, int dimension, int side) {
        if (world.field_72995_K) {
            return;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 4L) {
            this.setOrRemovePosition(stack, new BlockPosEU(x, y, z, player.field_71093_bK, side), false, !player.func_70093_af());
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
    }

    public String func_77653_i(ItemStack rulerStack) {
        int count;
        StringBuilder displayName = new StringBuilder(64);
        displayName.append(super.func_77653_i(rulerStack));
        if (rulerStack.func_77978_p() == null) {
            return displayName.toString();
        }
        String preGreen = EnumChatFormatting.GREEN.toString();
        String preRed = EnumChatFormatting.RED.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
        if (displayName.toString().length() >= 14) {
            displayName = new StringBuilder(64).append(EUStringUtils.getInitialsWithDots(displayName.toString()));
        }
        if ((count = this.getLocationCount(rulerStack)) > 0) {
            int sel = this.getLocationSelection(rulerStack);
            displayName.append(" - P: ").append(preGreen + (sel + 1)).append("/").append(count).append(rst);
            displayName.append(" - R: ");
            if (this.getAlwaysRenderLocation(rulerStack, sel)) {
                displayName.append(preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst);
            } else {
                displayName.append(preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst);
            }
        }
        return displayName.toString();
    }

    @Override
    public void addInformationSelective(ItemStack rulerStack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        BlockPosEU posEnd;
        String str;
        if (rulerStack.func_77978_p() == null) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.usetoolworkstation"));
            return;
        }
        String preDGreen = EnumChatFormatting.DARK_GREEN.toString();
        String preGreen = EnumChatFormatting.GREEN.toString();
        String preRed = EnumChatFormatting.RED.toString();
        String preBlue = EnumChatFormatting.BLUE.toString();
        String preWhite = EnumChatFormatting.WHITE.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        int selected = this.getLocationSelection(rulerStack);
        BlockPosEU posStart = this.getPosition(rulerStack, selected, true);
        if (posStart != null) {
            str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.start");
            list.add(str + String.format(": x: %s%d%s, y: %s%d%s, z: %s%d%s", preBlue, posStart.posX, rst, preBlue, posStart.posY, rst, preBlue, posStart.posZ, rst));
        }
        if ((posEnd = this.getPosition(rulerStack, selected, false)) != null) {
            str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.end");
            list.add(str + String.format(": x: %s%d%s, y: %s%d%s, z: %s%d%s", preBlue, posEnd.posX, rst, preBlue, posEnd.posY, rst, preBlue, posEnd.posZ, rst));
        }
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": ";
        str = !this.getDistanceMode(rulerStack) ? str + preDGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.dimensions") + rst : str + preDGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.difference") + rst;
        list.add(str);
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.rendercurrentwithall");
        if (this.getAlwaysRenderLocation(rulerStack, selected)) {
            list.add(str + ": " + preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst);
        } else {
            list.add(str + ": " + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst);
        }
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.renderall") + ": ";
        str = this.getRenderAllLocations(rulerStack) ? str + preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : str + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
        list.add(str);
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.renderwhenunselected") + ": ";
        str = this.getRenderWhenUnselected(rulerStack) ? str + preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : str + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
        list.add(str);
        int count = this.getLocationCount(rulerStack);
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selected") + ": ";
        list.add(str + preBlue + (selected + 1) + rst + " / " + preBlue + count + rst);
        int installed = this.getInstalledModuleCount(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (installed > 0) {
            int slotNum = UtilItemModular.getClampedModuleSelection(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            int max = this.getMaxModules(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            String preWhiteIta = preWhite + EnumChatFormatting.ITALIC.toString();
            String strShort = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedmemorycard.short");
            ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            if (moduleStack != null && moduleStack.func_77973_b() == EnderUtilitiesItems.enderPart) {
                String dName = moduleStack.func_82837_s() ? preWhiteIta + moduleStack.func_82833_r() + rst + " " : "";
                list.add(String.format("%s %s(%s%d%s / %s%d%s)", strShort, dName, preBlue, slotNum + 1, rst, preBlue, max, rst));
            } else {
                String strNo = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedmemorycard.notinstalled");
                list.add(String.format("%s %s (%s%d%s / %s%d%s)", strShort, strNo, preBlue, slotNum + 1, rst, preBlue, max, rst));
            }
        }
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD)) {
            return this.getMaxModules(containerStack);
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        IModule module;
        if (moduleStack != null && moduleStack.func_77973_b() instanceof IModule && ItemModule.ModuleType.TYPE_MEMORY_CARD.equals((module = (IModule)moduleStack.func_77973_b()).getModuleType(moduleStack)) && module.getModuleTier(moduleStack) == 0) {
            return this.getMaxModules(containerStack);
        }
        return 0;
    }

    public boolean getDistanceMode(ItemStack rulerStack) {
        return NBTUtils.getBoolean(rulerStack, TAG_WRAPPER, TAG_DISTANCE_MODE);
    }

    public boolean getRenderWhenUnselected(ItemStack rulerStack) {
        return NBTUtils.getBoolean(rulerStack, TAG_WRAPPER, TAG_RENDER_WHEN_UNSELECTED);
    }

    public boolean getRenderAllLocations(ItemStack rulerStack) {
        return NBTUtils.getBoolean(rulerStack, TAG_WRAPPER, TAG_RENDER_ALL);
    }

    public void toggleDistanceMode(ItemStack rulerStack) {
        NBTUtils.toggleBoolean(rulerStack, TAG_WRAPPER, TAG_DISTANCE_MODE);
    }

    public void toggleRenderWhenUnselected(ItemStack rulerStack) {
        NBTUtils.toggleBoolean(rulerStack, TAG_WRAPPER, TAG_RENDER_WHEN_UNSELECTED);
    }

    public void toggleRenderAllLocations(ItemStack rulerStack) {
        NBTUtils.toggleBoolean(rulerStack, TAG_WRAPPER, TAG_RENDER_ALL);
    }

    public int getLocationSelection(ItemStack rulerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null) {
            return NBTUtils.getByte(moduleStack, TAG_WRAPPER, TAG_SELECTED_LOCATION);
        }
        return 0;
    }

    public int getLocationCount(ItemStack rulerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null) {
            NBTTagList tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, false);
            return tagList != null ? tagList.func_74745_c() : 0;
        }
        return 0;
    }

    public void cycleLocationSelection(ItemStack rulerStack, boolean reverse) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null) {
            int max = Math.min(this.getLocationCount(rulerStack), 7);
            NBTUtils.cycleByteValue(moduleStack, TAG_WRAPPER, TAG_SELECTED_LOCATION, max, reverse);
        }
    }

    public boolean getAlwaysRenderLocation(ItemStack rulerStack, int index) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null) {
            NBTTagList tagList;
            if (index < 0) {
                index = this.getLocationSelection(rulerStack);
            }
            if ((tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, false)) != null) {
                NBTTagCompound tag = tagList.func_150305_b(index);
                return tag.func_74767_n(TAG_RENDER_WITH_ALL);
            }
        }
        return false;
    }

    public BlockPosEU getPosition(ItemStack rulerStack, int index, boolean isPos1) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null) {
            NBTTagList tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, false);
            if (tagList == null) {
                return null;
            }
            if (index < 0) {
                index = this.getLocationSelection(rulerStack);
            }
            String tagName = isPos1 ? "Pos1" : "Pos2";
            NBTTagCompound tag = tagList.func_150305_b(index);
            return BlockPosEU.readFromTag(tag.func_74775_l(tagName));
        }
        return null;
    }

    public void setOrRemovePosition(ItemStack rulerStack, BlockPosEU pos, boolean isPos1, boolean adjustPosition) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null) {
            NBTTagList tagList;
            int selected;
            if (adjustPosition) {
                pos = pos.offset(ForgeDirection.getOrientation((int)pos.face), 1);
            }
            if ((selected = this.getLocationSelection(rulerStack)) >= (tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, true)).func_74745_c()) {
                tagList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            NBTTagCompound tag = tagList.func_150305_b(selected);
            String tagName = isPos1 ? "Pos1" : "Pos2";
            BlockPosEU oldPos = BlockPosEU.readFromTag(tag.func_74775_l(tagName));
            if (pos == null || pos.equals(oldPos)) {
                tag.func_82580_o(tagName);
            } else {
                tag.func_74782_a(tagName, (NBTBase)pos.writeToTag(new NBTTagCompound()));
            }
            if (selected >= tagList.func_74745_c()) {
                tagList = NBTUtils.insertToTagList(tagList, (NBTBase)tag, selected);
            } else {
                tagList.func_150304_a(selected, (NBTBase)tag);
            }
            NBTUtils.setTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, tagList);
            this.setSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD, moduleStack);
        }
    }

    public void toggleAlwaysRenderSelectedLocation(ItemStack rulerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null) {
            int selected = this.getLocationSelection(rulerStack);
            NBTTagList tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, true);
            NBTTagCompound tag = tagList.func_150305_b(selected);
            NBTUtils.toggleBoolean(tag, TAG_RENDER_WITH_ALL);
            if (selected >= tagList.func_74745_c()) {
                tagList = NBTUtils.insertToTagList(tagList, (NBTBase)tag, selected);
            } else {
                tagList.func_150304_a(selected, (NBTBase)tag);
            }
            NBTUtils.setTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, tagList);
            this.setSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD, moduleStack);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack rulerStack, int key) {
        if (rulerStack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.cycleLocationSelection(rulerStack, ReferenceKeys.keypressActionIsReversed(key));
        } else if (!ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            this.toggleRenderWhenUnselected(rulerStack);
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            this.toggleDistanceMode(rulerStack);
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            this.toggleRenderAllLocations(rulerStack);
        } else if (!(ReferenceKeys.keypressContainsControl(key) || ReferenceKeys.keypressContainsShift(key) || ReferenceKeys.keypressContainsAlt(key))) {
            this.toggleAlwaysRenderSelectedLocation(rulerStack);
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        }
    }
}

