/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.inventory.ContainerPickupManager;
import fi.dy.masa.enderutilities.inventory.InventoryItem;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class ItemPickupManager
extends ItemLocationBoundModular
implements IKeyBound {
    public static final String TAG_NAME_CONTAINER = "PickupManager";
    public static final String TAG_NAME_TX_INVENTORY = "TransportItems";
    public static final String TAG_NAME_FILTER_INVENTORY_PRE = "FilterItems_";
    public static final String TAG_NAME_PRESET_SELECTION = "SelPreset";
    public static final String TAG_NAME_PRESET = "Preset_";
    public static final String TAG_NAME_LOCKED = "Locked";
    public static final String TAG_NAME_INVFILTER_ENABLED = "InvFiltEnabled";
    public static final String TAG_NAME_INVFILTER_MODE = "InvFiltMode";
    public static final String TAG_NAME_INVFILTER_META = "InvFiltMeta";
    public static final String TAG_NAME_INVFILTER_NBT = "InvFiltNBT";
    public static final String TAG_NAME_TXFILTER_ENABLED = "TxFiltEnabled";
    public static final String TAG_NAME_TXFILTER_MODE = "TxFiltMode";
    public static final String TAG_NAME_TXFILTER_META = "TxFiltMeta";
    public static final String TAG_NAME_TXFILTER_NBT = "TxFiltNBT";
    public static final int ENDER_CHARGE_COST_PER_SENT_ITEM = 2;
    public static final int NUM_PRESETS = 4;
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_CHANGE_PRESET = 1;
    public static final int GUI_ACTION_TOGGLE_INVENTORY_SETTINGS = 2;
    public static final int GUI_ACTION_TOGGLE_TRANSPORT_SETTINGS = 3;
    public static final SlotRange TRANSPORT_FILTER_SLOTS = new SlotRange(0, 18);
    public static final SlotRange INVENTORY_FILTER_SLOTS = new SlotRange(18, 18);
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemPickupManager() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("pickupmanager");
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.openGui((Object)EnderUtilities.instance, 1003, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        return stack;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        byte preset = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        String pre = EnumChatFormatting.GREEN.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
        return super.func_77653_i(stack) + " - P: " + pre + (preset + 1) + rst;
    }

    @Override
    public void addInformationSelective(ItemStack containerStack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = EnumChatFormatting.GREEN.toString();
        String preRed = EnumChatFormatting.RED.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String str = ItemPickupManager.isEnabled(containerStack) ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.enabled") + ": " + preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.enabled") + ": " + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
        list.add(str);
        int preset = NBTUtils.getByte(containerStack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION) + 1;
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.preset") + ": " + EnumChatFormatting.BLUE.toString() + preset + rst);
        super.addInformationSelective(containerStack, player, list, advancedTooltips, verbose);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemPickupManager.addTooltips(super.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public static NBTTagCompound getSelectedPresetTag(ItemStack stack, boolean create) {
        if (stack == null) {
            return null;
        }
        NBTTagCompound containerTag = NBTUtils.getCompoundTag(stack, TAG_NAME_CONTAINER, create);
        if (containerTag != null) {
            byte selection = containerTag.func_74771_c(TAG_NAME_PRESET_SELECTION);
            if (containerTag.func_150297_b(TAG_NAME_PRESET + selection, 10)) {
                return containerTag.func_74775_l(TAG_NAME_PRESET + selection);
            }
            if (create) {
                NBTTagCompound tag = new NBTTagCompound();
                containerTag.func_74782_a(TAG_NAME_PRESET + selection, (NBTBase)tag);
                return tag;
            }
        }
        return null;
    }

    public static byte getSettingValue(ItemStack stack, String tagName) {
        NBTTagCompound tag = ItemPickupManager.getSelectedPresetTag(stack, false);
        return tag != null ? tag.func_74771_c(tagName) : (byte)0;
    }

    public static void setSettingValue(ItemStack stack, String tagName, byte value) {
        NBTTagCompound tag = ItemPickupManager.getSelectedPresetTag(stack, true);
        tag.func_74774_a(tagName, value);
    }

    public static boolean isEnabled(ItemStack stack) {
        return !NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
    }

    public static List<ItemStack> getEnabledItems(EntityPlayer player) {
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems((IInventory)player.field_71071_by, EnderUtilitiesItems.pickupManager);
        ArrayList<ItemStack> enabledItems = new ArrayList<ItemStack>();
        for (int slot : slots) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (!ItemPickupManager.isEnabled(stack)) continue;
            enabledItems.add(stack);
        }
        return enabledItems;
    }

    public static ItemStack getFirstEnabledItem(EntityPlayer player) {
        List<ItemStack> items = ItemPickupManager.getEnabledItems(player);
        return items.size() > 0 ? items.get(0) : null;
    }

    public boolean tryTransportItemsFromTransportSlot(InventoryItem inv, EntityPlayer player, ItemStack manager) {
        int size;
        ItemStack stack = inv.func_70301_a(0);
        if (stack == null) {
            return false;
        }
        int sizeOrig = stack.field_77994_a;
        int max = stack.func_77976_d();
        while (stack.field_77994_a > 0 && (size = Math.min(max, stack.field_77994_a)) > 0) {
            ItemStack stackTmp = stack.func_77946_l();
            stackTmp.field_77994_a = size;
            if ((stackTmp = this.tryTransportItems(player, manager, stackTmp)) != null) {
                stack.field_77994_a -= size - stackTmp.field_77994_a;
                break;
            }
            stack.field_77994_a -= size;
        }
        inv.func_70299_a(0, (ItemStack)(stack.field_77994_a > 0 ? stack : null));
        return stack.field_77994_a != sizeOrig;
    }

    public ItemStack tryTransportItems(EntityPlayer player, ItemStack manager, ItemStack itemsIn) {
        WorldServer world;
        ItemStack moduleStack = this.getSelectedModuleStack(manager, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack == null || itemsIn == null) {
            return itemsIn;
        }
        NBTHelperPlayer owner = NBTHelperPlayer.getPlayerDataFromItem(moduleStack);
        if (owner != null && !owner.canAccess(player)) {
            return itemsIn;
        }
        NBTHelperTarget target = NBTHelperTarget.getTargetFromItem(moduleStack);
        if (target != null && (world = MinecraftServer.func_71276_C().func_71218_a(target.dimension)) != null) {
            if (!ChunkLoading.getInstance().loadChunkForcedWithModTicket(target.dimension, target.posX >> 4, target.posZ >> 4, 30)) {
                return itemsIn;
            }
            TileEntity te = world.func_147438_o(target.posX, target.posY, target.posZ);
            if (te instanceof IInventory) {
                ItemStack stackToSend = itemsIn.func_77946_l();
                int cost = 2;
                if (!UtilItemModular.useEnderCharge(manager, cost * itemsIn.field_77994_a, false)) {
                    int available = UtilItemModular.getAvailableEnderCharge(manager);
                    if (available < cost) {
                        return itemsIn;
                    }
                    stackToSend.field_77994_a = Math.min(itemsIn.field_77994_a, available / cost);
                }
                int numTransported = stackToSend.field_77994_a;
                ItemStack itemsRemaining = InventoryUtils.tryInsertItemStackToInventory((IInventory)te, stackToSend, target.blockFace);
                if (itemsRemaining != null) {
                    numTransported -= itemsRemaining.field_77994_a;
                }
                itemsIn.field_77994_a -= numTransported;
                UtilItemModular.useEnderCharge(manager, numTransported * cost, true);
                if (itemsIn.field_77994_a <= 0) {
                    return null;
                }
            }
        }
        return itemsIn;
    }

    public Result handleItems(EntityPlayer player, ItemStack manager, ItemStack itemsIn) {
        byte mode;
        boolean match;
        boolean ignoreNbt;
        boolean ignoreMeta;
        byte preset = NBTUtils.getByte(manager, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        InventoryItem inv = new InventoryItem(manager, 36, player.field_70170_p.field_72995_K, player, TAG_NAME_FILTER_INVENTORY_PRE + preset);
        inv.readFromContainerItemStack();
        if (ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_ENABLED) != 0) {
            ignoreMeta = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_META) != 0;
            ignoreNbt = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_NBT) == 0;
            match = InventoryUtils.matchingStackFoundInSlotRange(inv, TRANSPORT_FILTER_SLOTS, itemsIn, ignoreMeta, ignoreNbt);
            mode = ItemPickupManager.getSettingValue(manager, TAG_NAME_TXFILTER_MODE);
            if (mode != 0 && match || mode == 0 && !match) {
                ItemStack stackTmp = this.tryTransportItems(player, manager, itemsIn);
                if (stackTmp == null) {
                    return Result.TRANSPORTED;
                }
                itemsIn.field_77994_a = stackTmp.field_77994_a;
            }
        }
        if (ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_ENABLED) != 0) {
            ignoreMeta = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_META) != 0;
            ignoreNbt = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_NBT) == 0;
            match = InventoryUtils.matchingStackFoundInSlotRange(inv, INVENTORY_FILTER_SLOTS, itemsIn, ignoreMeta, ignoreNbt);
            mode = ItemPickupManager.getSettingValue(manager, TAG_NAME_INVFILTER_MODE);
            if (mode != 0) {
                return match ? Result.WHITELISTED : Result.NOT_WHITELISTED;
            }
            if (mode == 0) {
                return match ? Result.BLACKLISTED : Result.NOT_BLACKLISTED;
            }
        }
        return Result.NOT_HANDLED;
    }

    public static boolean onItemPickupEvent(PlayerItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        EntityPlayer player = event.entityPlayer;
        List<ItemStack> managers = ItemPickupManager.getEnabledItems(player);
        boolean deny = managers.size() > 0;
        boolean blackListed = false;
        boolean transported = false;
        Iterator<ItemStack> iter = event.drops.iterator();
        block0: while (iter.hasNext()) {
            ItemStack stackIn = iter.next();
            for (ItemStack manager : managers) {
                Result result = ((ItemPickupManager)manager.func_77973_b()).handleItems(player, manager, stackIn);
                if (result == Result.BLACKLISTED) {
                    blackListed = true;
                    deny = true;
                    continue block0;
                }
                if (result == Result.TRANSPORTED) {
                    iter.remove();
                    transported = true;
                    continue block0;
                }
                if (result == Result.WHITELISTED && !blackListed) {
                    deny = false;
                    continue block0;
                }
                if (blackListed || result != Result.NOT_HANDLED && result != Result.NOT_BLACKLISTED) continue;
                deny = false;
            }
        }
        if (transported) {
            player.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (deny) {
            event.setCanceled(true);
            return false;
        }
        return true;
    }

    public static boolean onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K || event.item.field_70128_L || event.item.func_92059_d() == null || event.item.func_92059_d().func_77973_b() == null) {
            return true;
        }
        ItemStack stackIn = event.item.func_92059_d();
        int origStackSize = stackIn.field_77994_a;
        EntityPlayer player = event.entityPlayer;
        List<ItemStack> managers = ItemPickupManager.getEnabledItems(player);
        boolean deny = managers.size() > 0;
        boolean ret = true;
        for (ItemStack manager : managers) {
            Result result = ((ItemPickupManager)manager.func_77973_b()).handleItems(player, manager, stackIn);
            if (result == Result.BLACKLISTED || result == Result.TRANSPORTED) {
                if (result == Result.TRANSPORTED) {
                    event.item.func_70106_y();
                    player.func_71001_a((Entity)event.item, origStackSize);
                }
                deny = true;
                ret = false;
                break;
            }
            if (result == Result.WHITELISTED) {
                deny = false;
                break;
            }
            if (result != Result.NOT_HANDLED && result != Result.NOT_BLACKLISTED) continue;
            deny = false;
        }
        if (event.item.func_92059_d().field_77994_a != origStackSize || event.item.field_70128_L) {
            FMLCommonHandler.instance().firePlayerItemPickupEvent(player, event.item);
            player.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            if (event.item.func_92059_d().field_77994_a <= 0 || event.item.field_70128_L) {
                player.func_71001_a((Entity)event.item, origStackSize);
            }
        }
        if (deny) {
            event.setCanceled(true);
            return false;
        }
        return ret;
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            UtilItemModular.changePrivacyModeOnSelectedModuleAbs(stack, player, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        } else if (!(ReferenceKeys.keypressContainsControl(key) || ReferenceKeys.keypressContainsShift(key) || ReferenceKeys.keypressContainsAlt(key))) {
            NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.cycleByteValue(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, 3, ReferenceKeys.keypressActionIsReversed(key));
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        }
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        if (!(player.field_71070_bA instanceof ContainerPickupManager)) {
            return;
        }
        ContainerPickupManager container = (ContainerPickupManager)player.field_71070_bA;
        ItemStack stack = container.getModularItem();
        if (stack == null) {
            return;
        }
        if (action == 0 && element >= 0 && element < 3) {
            UtilItemModular.setModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, element);
        } else if (action == 1 && element >= 0 && element < 4) {
            NBTUtils.setByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, (byte)element);
            container.inventoryItemFilters.setItemStorageTagName(TAG_NAME_FILTER_INVENTORY_PRE + element);
            container.inventoryItemFilters.readFromContainerItemStack();
        } else if (action == 2 && element >= 0 && element < 4) {
            String tagName = element == 0 ? TAG_NAME_INVFILTER_ENABLED : (element == 1 ? TAG_NAME_INVFILTER_MODE : (element == 2 ? TAG_NAME_INVFILTER_META : TAG_NAME_INVFILTER_NBT));
            ItemPickupManager.setSettingValue(stack, tagName, (byte)(ItemPickupManager.getSettingValue(stack, tagName) ^ 1));
        } else if (action == 3 && element >= 0 && element < 4) {
            String tagName = element == 0 ? TAG_NAME_TXFILTER_ENABLED : (element == 1 ? TAG_NAME_TXFILTER_MODE : (element == 2 ? TAG_NAME_TXFILTER_META : TAG_NAME_TXFILTER_NBT));
            ItemPickupManager.setSettingValue(stack, tagName, (byte)(ItemPickupManager.getSettingValue(stack, tagName) ^ 1));
        }
    }

    @Override
    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return false;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (ItemModule.ModuleType.TYPE_LINKCRYSTAL.equals(moduleType)) {
            return 3;
        }
        if (ItemModule.ModuleType.TYPE_ENDERCAPACITOR.equals(moduleType)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_77973_b() instanceof IModule) {
            IModule imodule = (IModule)moduleStack.func_77973_b();
            ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
            if (ItemModule.ModuleType.TYPE_LINKCRYSTAL.equals(moduleType)) {
                if (imodule.getModuleTier(moduleStack) == 1) {
                    return this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                }
            } else {
                return this.getMaxModules(containerStack, moduleType);
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        this.iconArray = new IIcon[3];
        this.iconArray[0] = iconRegister.func_94245_a(this.func_111208_A());
        this.iconArray[1] = iconRegister.func_94245_a(this.func_111208_A() + ".locked");
        this.iconArray[2] = iconRegister.func_94245_a(ReferenceTextures.getItemTextureName("empty"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        switch (renderPass) {
            case 0: {
                return this.iconArray[0];
            }
            case 1: {
                boolean isLocked = NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
                return isLocked ? this.iconArray[1] : this.iconArray[2];
            }
        }
        return this.field_77791_bV;
    }

    public static enum Result {
        TRANSPORTED,
        WHITELISTED,
        NOT_WHITELISTED,
        BLACKLISTED,
        NOT_BLACKLISTED,
        NOT_HANDLED;

    }
}

