/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemEnderBow
extends ItemLocationBoundModular
implements IKeyBound {
    public static final int ENDER_CHARGE_COST_MOB_TP = 1000;
    public static final byte BOW_MODE_TP_TARGET = 0;
    public static final byte BOW_MODE_TP_SELF = 1;
    public static final String[] bowPullIconNameArray = new String[]{"standby", "pulling.0", "pulling.1", "pulling.2", "broken", "mode2.standby", "mode2.pulling.0", "mode2.pulling.1", "mode2.pulling.2", "mode2.broken"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemEnderBow() {
        this.func_77625_d(1);
        this.func_77656_e(384);
        this.setNoRepair();
        this.func_77655_b("enderbow");
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int itemInUseCount) {
        if (this.isBroken(stack)) {
            return;
        }
        byte mode = this.getBowMode(stack);
        if (world.field_72995_K || mode == 0 && !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return;
        }
        if (mode == 1 && !Configs.enderBowAllowSelfTP.getBoolean(true)) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_146028_b((Item)EnderUtilitiesItems.enderArrow)) {
            return;
        }
        float f = (float)(this.func_77626_a(stack) - itemInUseCount) / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) < 0.1f) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        EntityEnderArrow entityenderarrow = new EntityEnderArrow(world, (EntityLivingBase)player, f * 2.0f);
        entityenderarrow.setTpMode(mode);
        if (mode == 0) {
            NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (target == null) {
                return;
            }
            entityenderarrow.setTpTarget(target);
            if (UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                entityenderarrow.setPersistence(true);
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (mode == 0 && !UtilItemModular.useEnderCharge(stack, 1000, true)) {
                return;
            }
            player.field_71071_by.func_146026_a((Item)EnderUtilitiesItems.enderArrow);
            stack.func_77972_a(1, (EntityLivingBase)player);
            if (this.isBroken(stack)) {
                player.func_70669_a(stack);
            }
        }
        if (f == 1.0f) {
            entityenderarrow.func_70243_d(true);
        }
        world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        world.func_72838_d((Entity)entityenderarrow);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition;
        if (this.isBroken(stack)) {
            return stack;
        }
        if (!player.field_71075_bZ.field_75098_d && this.getBowMode(stack) == 0 && !UtilItemModular.useEnderCharge(stack, 1000, false)) {
            return stack;
        }
        if (this.getBowMode(stack) == 0 && !NBTHelperPlayer.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player)) {
            return stack;
        }
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return stack;
        }
        if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b((Item)EnderUtilitiesItems.enderArrow)) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                return stack;
            }
            if (nbt.func_74771_c("Mode") == 0 && !NBTHelperTarget.selectedModuleHasTargetTag(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
                return stack;
            }
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public boolean isBroken(ItemStack stack) {
        return stack.func_77960_j() >= this.getMaxDamage(stack);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        if (this.getBowMode(stack) == 1) {
            return StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim();
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        NBTTagCompound nbt = stack.func_77978_p();
        String rst = "" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY;
        if (nbt != null && nbt.func_150297_b("Mode", 1) && nbt.func_74771_c("Mode") == 1) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.tpself") + rst);
        } else {
            super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.tptarget") + rst);
        }
    }

    public byte getBowMode(ItemStack stack) {
        if (stack != null && stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74771_c("Mode");
        }
        return 0;
    }

    public void toggleBowMode(EntityPlayer player, ItemStack stack) {
        if (!Configs.enderBowAllowSelfTP.getBoolean(true)) {
            NBTUtils.setByte(stack, null, "Mode", (byte)0);
        } else {
            NBTUtils.cycleByteValue(stack, null, "Mode", 1);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 1) {
            this.toggleBowMode(player, stack);
        } else {
            super.doKeyBindingAction(player, stack, key);
        }
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE)) {
            return 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".standby");
        this.iconArray = new IIcon[bowPullIconNameArray.length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + "." + bowPullIconNameArray[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int index) {
        if (index < this.iconArray.length) {
            return this.iconArray[index];
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIcon(stack, renderPass, null, null, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int index = 0;
        byte mode = 0;
        if (stack.func_77978_p() != null) {
            mode = stack.func_77978_p().func_74771_c("Mode");
            if (mode > 1 || mode < 0) {
                mode = 0;
            }
            index = mode * 5;
        }
        if (this.isBroken(stack)) {
            index += 4;
        } else if (player != null && player.func_71011_bu() != null) {
            int inUse = 0;
            inUse = stack.func_77988_m() - useRemaining;
            if (inUse >= 18) {
                index += 3;
            } else if (inUse >= 13) {
                index += 2;
            } else if (inUse > 0) {
                ++index;
            }
        }
        return this.getItemIconForUseDuration(index);
    }
}

