/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fi.dy.masa.enderutilities.inventory.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.inventory.ICustomSlotSync;
import fi.dy.masa.enderutilities.inventory.SlotGeneric;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageSyncCustomSlot;
import fi.dy.masa.enderutilities.tileentity.TileEntityTemplatedChest;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTemplatedChest
extends ContainerEnderUtilities
implements ICustomSlotSync {
    protected TileEntityTemplatedChest tetc;
    protected List<ItemStack> templateStacksLast;
    protected long templateMask;

    public ContainerTemplatedChest(EntityPlayer player, TileEntityTemplatedChest te) {
        super(player, te);
        this.tetc = te;
        this.templateStacksLast = new ArrayList<ItemStack>();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 58);
    }

    @Override
    protected void addCustomInventorySlots() {
        int customInvStart = this.field_75151_b.size();
        int posX = 8;
        int posY = 26;
        int tier = this.tetc.getStorageTier();
        int rows = TileEntityTemplatedChest.INV_SIZES[tier] / 9;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotGeneric(this.inventory, i * 9 + j, posX + j * 18, posY + i * 18));
            }
        }
        this.customInventorySlots = new SlotRange(customInvStart, this.field_75151_b.size() - customInvStart);
    }

    @Override
    protected void addPlayerInventorySlots(int posX, int posY) {
        posY = ((Slot)this.field_75151_b.get((int)(this.field_75151_b.size() - 1))).field_75221_f + 32;
        super.addPlayerInventorySlots(posX, posY);
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return super.func_75145_c(player) && !this.tetc.func_145837_r();
    }

    @Override
    public boolean transferStackFromSlot(EntityPlayer player, int slotNum) {
        Slot slot;
        Slot slot2 = slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        if (slot == null || !slot.func_75216_d()) {
            return false;
        }
        if (slot.field_75224_c != this.player.field_71071_by) {
            return super.transferStackFromSlot(player, slotNum);
        }
        ItemStack stackSlot = slot.func_75211_c();
        int origSize = stackSlot.field_77994_a;
        for (int i = 0; i < this.tetc.func_70302_i_(); ++i) {
            ItemStack stackTmp = this.tetc.getTemplateStack(i);
            if (stackTmp == null || !InventoryUtils.areItemStacksEqual(stackTmp, stackSlot)) continue;
            this.func_75135_a(stackSlot, i, i + 1, false);
            if (stackSlot.field_77994_a > 0) continue;
            slot.func_75215_d(null);
            slot.func_82870_a(player, stackSlot);
            return true;
        }
        if (stackSlot.field_77994_a != origSize) {
            slot.func_82870_a(player, stackSlot);
        }
        return super.transferStackFromSlot(player, slotNum);
    }

    public ItemStack func_75144_a(int slotNum, int button, int type, EntityPlayer player) {
        if (button == 2 && type == 3 && slotNum >= 0 && slotNum < this.tetc.func_70302_i_()) {
            int invSlotNum;
            int n = invSlotNum = this.func_75139_a(slotNum) != null ? this.func_75139_a(slotNum).getSlotIndex() : -1;
            if (invSlotNum == -1) {
                return null;
            }
            this.tetc.setTemplateStack(invSlotNum, this.tetc.func_70301_a(invSlotNum));
            this.tetc.toggleTemplateMask(invSlotNum);
            return null;
        }
        ItemStack stack = super.func_75144_a(slotNum, button, type, player);
        this.func_75142_b();
        return stack;
    }

    public TileEntityTemplatedChest getTileEntity() {
        return this.tetc;
    }

    protected Slot func_75146_a(Slot slot) {
        this.templateStacksLast.add(null);
        return super.func_75146_a(slot);
    }

    @Override
    public void putCustomStack(int typeId, int slotNum, ItemStack stack) {
        this.tetc.setTemplateStack(slotNum, stack);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.tetc.func_145831_w().field_72995_K) {
            return;
        }
        for (int i = 0; i < this.templateStacksLast.size(); ++i) {
            ItemStack currentStack = this.tetc.getTemplateStack(i);
            ItemStack prevStack = this.templateStacksLast.get(i);
            if (ItemStack.func_77989_b((ItemStack)prevStack, (ItemStack)currentStack)) continue;
            prevStack = currentStack != null ? currentStack.func_77946_l() : null;
            this.templateStacksLast.set(i, prevStack);
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                ICrafting icrafting = (ICrafting)this.field_75149_d.get(j);
                if (!(icrafting instanceof EntityPlayerMP)) continue;
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncCustomSlot(this.field_75152_c, 0, i, prevStack), (EntityPlayerMP)icrafting);
            }
        }
        long mask = this.tetc.getTemplateMask();
        for (int j = 0; j < this.field_75149_d.size(); ++j) {
            if (this.templateMask == mask) continue;
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(j);
            icrafting.func_71112_a((Container)this, 0, (int)(mask & 0xFFFFL));
            icrafting.func_71112_a((Container)this, 1, (int)(mask >> 16 & 0xFFFFL));
            icrafting.func_71112_a((Container)this, 2, (int)(mask >> 32 & 0xFFFFL));
            icrafting.func_71112_a((Container)this, 3, (int)(mask >> 48 & 0xFFFFL));
        }
        this.templateMask = mask;
    }

    public void func_75137_b(int var, int val) {
        if (var >= 0 && var <= 3) {
            this.templateMask &= 65535L << var * 16 ^ 0xFFFFFFFFFFFFFFFFL;
            this.templateMask |= (long)val << var * 16;
            this.tetc.setTemplateMask(this.templateMask);
        }
    }
}

