/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.entity;

import cpw.mods.fml.common.eventhandler.Event;
import fi.dy.masa.enderutilities.item.tool.ItemEnderSword;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class EntityEndermanFighter
extends EntityMob {
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", (double)6.2f, 0).func_111168_a(false);
    private int teleportDelay;
    private Entity lastEntityToAttack;
    private Entity attackTargetCommanded;
    private UUID attackTargetUUID;
    private Entity revengeTarget;
    private UUID revengeTargetUUID;
    private boolean isAggressive;
    private boolean isBeingControlled;
    private int timer;
    private int idleTimer;

    public EntityEndermanFighter(World world) {
        super(world);
        this.func_70105_a(0.6f, 2.9f);
        this.field_70138_W = 1.0f;
        this.attackTargetCommanded = null;
        this.attackTargetUUID = null;
        this.revengeTarget = null;
        this.revengeTargetUUID = null;
        this.isBeingControlled = false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(18, (Object)new Byte(0));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.revengeTargetUUID != null) {
            nbt.func_74772_a("RTUUIDM", this.revengeTargetUUID.getMostSignificantBits());
            nbt.func_74772_a("RTUUIDL", this.revengeTargetUUID.getLeastSignificantBits());
        }
        if (this.attackTargetUUID != null) {
            nbt.func_74772_a("ATUUIDM", this.attackTargetUUID.getMostSignificantBits());
            nbt.func_74772_a("ATUUIDL", this.attackTargetUUID.getLeastSignificantBits());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("RTUUIDM", 4) && nbt.func_150297_b("RTUUIDL", 4)) {
            this.revengeTargetUUID = new UUID(nbt.func_74763_f("RTUUIDM"), nbt.func_74763_f("RTUUIDL"));
        }
        if (nbt.func_150297_b("ATUUIDM", 4) && nbt.func_150297_b("ATUUIDL", 4)) {
            this.attackTargetUUID = new UUID(nbt.func_74763_f("ATUUIDM"), nbt.func_74763_f("ATUUIDL"));
        }
    }

    public boolean isPlayerHoldingSummonItem(EntityPlayer player) {
        ItemStack stack;
        return player.func_71045_bC() != null && (stack = player.func_71045_bC()).func_77973_b() == EnderUtilitiesItems.enderSword && ((ItemEnderSword)stack.func_77973_b()).getSwordMode(stack) == 3;
    }

    public void setTargetCommanded(Entity entity) {
        this.attackTargetCommanded = entity;
        if (entity != null) {
            this.attackTargetUUID = entity.func_110124_au();
        }
    }

    public void func_70784_b(Entity entity) {
        super.func_70784_b(entity);
        if (entity == null) {
            this.setScreaming(false);
        } else if (entity instanceof EntityPlayer) {
            this.setScreaming(true);
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.endermen.stare", 0.5f, 1.2f);
        }
    }

    protected Entity func_70782_k() {
        EntityPlayer player;
        if (this.timer == 0 && (player = this.getClosestVulnerablePlayer(this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0)) != null && this.shouldAttackPlayer(player)) {
            this.isAggressive = true;
            this.func_70784_b((Entity)player);
            return player;
        }
        return null;
    }

    public EntityPlayer getClosestVulnerablePlayer(double x, double y, double z, double distance) {
        double d4 = -1.0;
        EntityPlayer player = null;
        for (int i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayer playerTmp = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
            if (playerTmp.field_71075_bZ.field_75102_a || !playerTmp.func_70089_S() || this.isPlayerHoldingSummonItem(playerTmp)) continue;
            double d5 = playerTmp.func_70092_e(x, y, z);
            double d6 = distance;
            if (playerTmp.func_70093_af()) {
                d6 = distance * 0.8;
            }
            if (playerTmp.func_82150_aj()) {
                float f = playerTmp.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d6 *= (double)(0.7f * f);
            }
            if (!(distance < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            player = playerTmp;
        }
        return player;
    }

    public boolean shouldAttackPlayer(EntityPlayer player) {
        if (this.func_94056_bM() || !player.func_70089_S() || this.isPlayerHoldingSummonItem(player) || player.field_71075_bZ.field_75102_a) {
            return false;
        }
        return !this.isBeingControlled;
    }

    private void updateIsBeingControlled() {
        for (int i = 0; i < this.field_70170_p.field_73010_i.size(); ++i) {
            EntityPlayer playerTmp = (EntityPlayer)this.field_70170_p.field_73010_i.get(i);
            if (!playerTmp.func_70089_S() || !(playerTmp.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) < 1024.0) || !this.isPlayerHoldingSummonItem(playerTmp)) continue;
            this.isBeingControlled = true;
            return;
        }
        this.isBeingControlled = false;
    }

    private Entity getLivingEntityNearbyByUUID(UUID uuid, double bbRadius) {
        double r = bbRadius;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.field_70165_t - r), (double)(this.field_70163_u - r), (double)(this.field_70161_v - r), (double)(this.field_70165_t + r), (double)(this.field_70163_u + r), (double)(this.field_70161_v + r));
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, bb);
        return EntityUtils.findEntityByUUID(list, uuid);
    }

    private void checkTargetsNotDead() {
        if (this.revengeTarget != null && !this.revengeTarget.func_70089_S()) {
            if (this.field_70789_a == this.revengeTarget) {
                this.func_70784_b(null);
            }
            this.revengeTarget = null;
            this.revengeTargetUUID = null;
        }
        if (this.attackTargetCommanded != null && !this.attackTargetCommanded.func_70089_S()) {
            if (this.field_70789_a == this.attackTargetCommanded) {
                this.func_70784_b(null);
            }
            this.attackTargetCommanded = null;
            this.attackTargetUUID = null;
        }
    }

    private void switchTargets() {
        if (this.isBeingControlled) {
            if (this.attackTargetCommanded == null && this.attackTargetUUID != null) {
                this.attackTargetCommanded = this.getLivingEntityNearbyByUUID(this.attackTargetUUID, 64.0);
            }
            if (this.attackTargetCommanded != null && this.field_70789_a != this.attackTargetCommanded) {
                this.func_70784_b(this.attackTargetCommanded);
            }
        } else {
            if (this.revengeTarget == null && this.revengeTargetUUID != null) {
                this.revengeTarget = this.getLivingEntityNearbyByUUID(this.revengeTargetUUID, 64.0);
            }
            if (this.revengeTarget != null && this.field_70789_a != this.revengeTarget) {
                this.func_70784_b(this.revengeTarget);
            } else if (this.revengeTarget == null && this.field_70789_a == this.attackTargetCommanded) {
                this.func_70782_k();
            }
        }
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double y = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25;
                double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double vx = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                double vz = (this.field_70146_Z.nextDouble() - 0.5) * 2.0;
                this.field_70170_p.func_72869_a("portal", x, y, z, vx, -this.field_70146_Z.nextDouble(), vz);
            }
            super.func_70636_d();
            return;
        }
        if (++this.timer >= 20) {
            this.timer = 0;
        }
        if (this.lastEntityToAttack != this.field_70789_a) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(attackingSpeedBoostModifier);
            if (this.field_70789_a != null) {
                iattributeinstance.func_111121_a(attackingSpeedBoostModifier);
            }
            this.lastEntityToAttack = this.field_70789_a;
        }
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.func_70026_G() || this.func_70027_ad()) {
            this.teleportRandomly();
        }
        if (this.isScreaming() && !this.isAggressive && this.field_70146_Z.nextInt(100) == 0) {
            this.setScreaming(false);
        }
        this.field_70703_bu = false;
        if (this.func_70089_S()) {
            this.checkTargetsNotDead();
            this.updateIsBeingControlled();
            this.switchTargets();
            if (this.field_70789_a != null) {
                this.func_70625_a(this.field_70789_a, 100.0f, 100.0f);
                if (this.field_70789_a instanceof EntityPlayer) {
                    if (this.shouldAttackPlayer((EntityPlayer)this.field_70789_a)) {
                        if (this.field_70789_a.func_70068_e((Entity)this) < 16.0 && this.field_70170_p.field_73012_v.nextFloat() < 0.03f) {
                            this.teleportRandomly();
                        }
                        this.setRaging(true);
                    } else {
                        this.func_70784_b(null);
                        this.setRaging(false);
                    }
                } else {
                    this.setRaging(false);
                }
                if (this.field_70789_a != null && this.field_70789_a.func_70068_e((Entity)this) > 256.0 && this.teleportDelay++ >= 30 && this.teleportToEntity(this.field_70789_a)) {
                    this.teleportDelay = 0;
                }
            } else {
                this.setScreaming(false);
                this.teleportDelay = 0;
            }
        }
        if (this.field_70789_a == null && !this.func_104002_bU()) {
            if (++this.idleTimer >= 200 && this.field_70170_p.field_73012_v.nextFloat() < 0.03f) {
                for (int i = 0; i < 16; ++i) {
                    float vx = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    float vy = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    float vz = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                    double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                    double y = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                    double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                    this.field_70170_p.func_72869_a("portal", x, y, z, (double)vx, (double)vy, (double)vz);
                }
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.endermen.portal", 0.7f, 1.0f);
                this.func_70106_y();
            }
        } else {
            this.idleTimer = 0;
        }
        super.func_70636_d();
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(8) - 4);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 32.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity target) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - target.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)this.field_70131_O / 2.0 - target.field_70163_u + (double)target.func_70047_e()), (double)(this.field_70161_v - target.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d = 16.0;
        double x = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (d / 2.0) - vec3.field_72450_a * d;
        double y = this.field_70163_u + (double)(this.field_70146_Z.nextInt((int)d) - (int)(d / 2.0)) - vec3.field_72448_b * d;
        double z = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (d / 2.0) - vec3.field_72449_c * d;
        return this.teleportTo(x, y, z);
    }

    protected boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double oldX = this.field_70165_t;
        double oldY = this.field_70163_u;
        double oldZ = this.field_70161_v;
        this.field_70165_t = event.targetX;
        this.field_70163_u = event.targetY;
        this.field_70161_v = event.targetZ;
        int blockX = MathHelper.func_76128_c((double)this.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)this.field_70163_u);
        int blockZ = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean foundValidLocation = false;
        if (this.field_70170_p.func_72899_e(blockX, blockY, blockZ)) {
            boolean foundSolidFloor = false;
            while (!foundSolidFloor && blockY > 0) {
                Block block = this.field_70170_p.func_147439_a(blockX, blockY - 1, blockZ);
                if (block.func_149688_o().func_76230_c()) {
                    foundSolidFloor = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --blockY;
            }
            if (foundSolidFloor) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    foundValidLocation = true;
                }
            }
        }
        if (!foundValidLocation) {
            this.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        int short1 = 128;
        for (int i = 0; i < short1; ++i) {
            double d6 = (double)i / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = oldX + (this.field_70165_t - oldX) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = oldY + (this.field_70163_u - oldY) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = oldZ + (this.field_70161_v - oldZ) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.field_70170_p.func_72908_a(oldX, oldY, oldZ, "mob.endermen.portal", 0.7f, 1.0f);
        return true;
    }

    protected String func_70639_aQ() {
        return this.isScreaming() ? "mob.endermen.scream" : "mob.endermen.idle";
    }

    protected String func_70621_aR() {
        return "mob.endermen.hit";
    }

    protected String func_70673_aS() {
        return "mob.endermen.death";
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)0);
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        this.setScreaming(true);
        if (source instanceof EntityDamageSource && source.func_76346_g() instanceof EntityLivingBase) {
            this.revengeTarget = (EntityLivingBase)source.func_76346_g();
            this.revengeTargetUUID = this.revengeTarget.func_110124_au();
            this.isAggressive = true;
        }
        if (source instanceof EntityDamageSourceIndirect) {
            this.isAggressive = false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
        }
        return super.func_70097_a(source, damage);
    }

    public boolean isRaging() {
        return this.field_70180_af.func_75683_a(16) > 0;
    }

    public void setRaging(boolean value) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)(value ? 1 : 0)));
    }

    public boolean isScreaming() {
        return this.field_70180_af.func_75683_a(18) > 0;
    }

    public void setScreaming(boolean value) {
        this.field_70180_af.func_75692_b(18, (Object)((byte)(value ? 1 : 0)));
    }
}

