/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.item;

import fi.dy.masa.enderutilities.client.renderer.item.ItemRenderer;
import fi.dy.masa.enderutilities.item.ItemEnderBucket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ItemRendererEnderBucket
implements IItemRenderer {
    public Minecraft mc = Minecraft.func_71410_x();

    public boolean handleRenderType(ItemStack stack, IItemRenderer.ItemRenderType type) {
        return stack != null && stack.func_77973_b() instanceof ItemEnderBucket;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemEnderBucket)) {
            return;
        }
        ItemEnderBucket itemBucket = (ItemEnderBucket)stack.func_77973_b();
        IIcon iicon = null;
        int amount = 0;
        FluidStack fluidStack = itemBucket.getFluidCached(stack);
        Fluid fluid = null;
        if (fluidStack != null) {
            amount = fluidStack.amount;
            fluid = fluidStack.getFluid();
            iicon = fluid.getStillIcon();
        }
        GL11.glPushMatrix();
        if (fluid != null && fluid.isGaseous()) {
            switch (type) {
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                    GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                case EQUIPPED: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.95f, (float)0.0f);
                    break;
                }
                case ENTITY: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
                    break;
                }
                case INVENTORY: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-16.0f, (float)0.0f);
                    break;
                }
            }
        }
        Tessellator t = Tessellator.field_78398_a;
        GL11.glPushAttrib((int)8192);
        switch (type) {
            case INVENTORY: {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                break;
            }
            default: {
                GL11.glEnable((int)32826);
                GL11.glDisable((int)3042);
            }
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (iicon != null) {
            this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.renderQuad(type, t, iicon, 0.375f, 0.1875f, 0.25f, 0.625f, -2.5E-5, -2.5E-5, 1.0E-4);
            this.renderQuad(type, t, iicon, 0.25f, 0.25f, 0.125f, 0.125f, -2.5E-5, -2.5E-5, 1.0E-4);
            this.renderQuad(type, t, iicon, 0.625f, 0.25f, 0.125f, 0.125f, -2.5E-5, -2.5E-5, 1.0E-4);
        }
        this.mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
        int offset = 0;
        byte mainPartIndex = itemBucket.getBucketMode(stack);
        if (itemBucket.getBucketLinkMode(stack) == 1) {
            offset += 6;
        }
        if (mainPartIndex < 0 || mainPartIndex > 3) {
            mainPartIndex = 0;
        }
        iicon = itemBucket.getIconPart(offset + mainPartIndex);
        this.renderQuad(type, t, iicon, 0.0f, 0.0f, 1.0f, 1.0f, 0.0, 0.0, 0.0);
        iicon = itemBucket.getIconPart(offset + 5);
        int capacity = itemBucket.getCapacityCached(stack, null);
        if (capacity == 0) {
            capacity = 1;
        }
        amount = MathHelper.func_76125_a((int)amount, (int)0, (int)capacity);
        float scale = 1.0f - (float)amount / (float)capacity;
        this.renderQuad(type, t, iicon, 0.375f, 0.5625f, 0.25f, scale * 0.25f, 0.0, 0.0, 0.0);
        iicon = itemBucket.getIconPart(offset + 4);
        this.renderQuad(type, t, iicon, 0.25f, 0.1875f, 0.5f, scale * 0.25f, 0.0, 0.0, 0.0);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        switch (type) {
            case INVENTORY: {
                break;
            }
            default: {
                GL11.glDisable((int)32826);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderQuad(IItemRenderer.ItemRenderType type, Tessellator t, IIcon iicon, float minX, float minY, float relWidth, float relHeight, double layerShrinkX, double layerShrinkY, double layerShrinkZ) {
        int width = (int)(relWidth * (float)iicon.func_94211_a());
        int height = (int)(relHeight * (float)iicon.func_94216_b());
        float minU = iicon.func_94209_e();
        float maxU = iicon.func_94212_f();
        float minV = iicon.func_94206_g();
        float maxV = iicon.func_94210_h();
        float lenU = maxU - minU;
        float lenV = maxV - minV;
        float startU = minX * lenU + minU;
        float endU = relWidth * lenU + startU;
        float startV = minY * lenV + minV;
        float endV = relHeight * lenV + startV;
        GL11.glPushMatrix();
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                GL11.glRotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
                GL11.glTranslatef((float)0.0f, (float)0.02f, (float)0.0f);
            }
            case EQUIPPED: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case ENTITY: {
                GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)0.0f);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                break;
            }
            case INVENTORY: {
                layerShrinkZ = -layerShrinkZ;
                GL11.glScalef((float)16.0f, (float)16.0f, (float)1.0f);
                break;
            }
        }
        ItemRenderer.renderItemLayerIn2D(t, width, height, 0.0625f, minX, minY, minX + relWidth, minY + relHeight, startU, startV, endU, endV, layerShrinkX, layerShrinkY, layerShrinkZ);
        GL11.glPopMatrix();
    }
}

