/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.block.machine.Machine;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnergyBridge;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineEnergyBridge
extends Machine {
    public MachineEnergyBridge(int index, int meta, String name, Class<? extends TileEntityEnderUtilities> TEClass, String tool, int harvestLevel, float hardness) {
        super(index, meta, name, TEClass, tool, harvestLevel, hardness);
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase livingBase, ItemStack stack) {
        TileEntity te;
        super.onBlockPlacedBy(world, x, y, z, livingBase, stack);
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).tryAssembleMultiBlock(world, x, y, z);
        }
    }

    @Override
    public void onBlockPreDestroy(World world, int x, int y, int z, int oldMeta) {
        TileEntity te;
        super.onBlockPreDestroy(world, x, y, z, oldMeta);
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).disassembleMultiblock(world, x, y, z, oldMeta);
        }
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float offsetX, float offsetY, float offsetZ) {
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z, Block block, int meta) {
        return 15;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.icons[0];
        }
        if (side == 3) {
            return this.icons[2];
        }
        return this.icons[6];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(TileEntityEnderUtilities te, int side, int meta) {
        int offsetActive = 0;
        if (te == null) {
            return this.icons[0];
        }
        if (te instanceof TileEntityEnergyBridge && ((TileEntityEnergyBridge)te).isActive) {
            ++offsetActive;
        }
        if (side == 0 || side == 1) {
            return this.icons[0 + offsetActive];
        }
        int rot = te.getRotation();
        if (side == rot) {
            return this.icons[2 + offsetActive];
        }
        if (side == ForgeDirection.getOrientation((int)rot).getOpposite().ordinal()) {
            return this.icons[4 + offsetActive];
        }
        return this.icons[6 + offsetActive];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[8];
        if ("energybridge.transmitter".equals(this.blockName)) {
            this.icons[0] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".top.off");
            this.icons[1] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".top.active");
            this.icons[2] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".side.off");
            this.icons[3] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".side.active");
            this.icons[4] = this.icons[2];
            this.icons[5] = this.icons[3];
            this.icons[6] = this.icons[2];
            this.icons[7] = this.icons[3];
        } else if ("energybridge.receiver".equals(this.blockName)) {
            this.icons[0] = iconRegister.func_94245_a(ReferenceTextures.getTileName("energybridge.transmitter.top.off"));
            this.icons[1] = iconRegister.func_94245_a(ReferenceTextures.getTileName("energybridge.transmitter.top.active"));
            this.icons[2] = this.icons[0];
            this.icons[3] = this.icons[1];
            this.icons[4] = this.icons[0];
            this.icons[5] = this.icons[1];
            this.icons[6] = this.icons[0];
            this.icons[7] = this.icons[1];
        } else if ("energybridge.resonator".equals(this.blockName)) {
            this.icons[0] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".top.off");
            this.icons[1] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".top.active");
            this.icons[2] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".front.off");
            this.icons[3] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".front.active");
            this.icons[4] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".back");
            this.icons[5] = this.icons[4];
            this.icons[6] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".side.off");
            this.icons[7] = iconRegister.func_94245_a(ReferenceTextures.getTileName(this.blockName) + ".side.active");
        }
    }
}

