/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.item.IEmpowerableItem;
import cofh.core.enchantment.CoFHEnchantment;
import cofh.core.item.IEqualityOverrideItem;
import cofh.core.item.tool.ItemBowAdv;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.core.RAProps;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemBowRF
extends ItemBowAdv
implements IEmpowerableItem,
IEnergyContainerItem,
IEqualityOverrideItem {
    IIcon[] activeIcons = new IIcon[4];
    IIcon drainedIcon;
    public int maxEnergy = 160000;
    public int maxTransfer = 1600;
    public int energyPerUse = 200;
    public int energyPerUseCharged = 800;

    public ItemBowRF(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.setNoRepair();
    }

    public ItemBowRF setEnergyParams(int n, int n2, int n3, int n4) {
        this.maxEnergy = n;
        this.maxTransfer = n2;
        this.energyPerUse = n3;
        this.energyPerUseCharged = n4;
        return this;
    }

    protected void useEnergy(ItemStack itemStack) {
        int n = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        this.extractEnergy(itemStack, this.isEmpowered(itemStack) ? this.energyPerUseCharged * (5 - n) / 5 : this.energyPerUse * (5 - n) / 5, false);
    }

    protected int getEnergyPerUse(ItemStack itemStack) {
        int n = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)itemStack), (int)0, (int)4);
        return (this.isEmpowered(itemStack) ? this.energyPerUseCharged : this.energyPerUse) * (5 - n) / 5;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)0));
        list.add(EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack(item, 1, 0), (int)this.maxEnergy));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (!entityPlayer.field_71075_bZ.field_75098_d && this.getEnergyStored(itemStack) < this.getEnergyPerUse(itemStack)) {
            return itemStack;
        }
        ArrowNockEvent arrowNockEvent = new ArrowNockEvent(entityPlayer, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)arrowNockEvent);
        if (arrowNockEvent.isCanceled()) {
            return arrowNockEvent.result;
        }
        if (entityPlayer.field_71075_bZ.field_75098_d || entityPlayer.field_71071_by.func_146028_b(Items.field_151032_g) || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemStack) > 0) {
            entityPlayer.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        return itemStack;
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer entityPlayer, int n) {
        boolean bl;
        int n2 = this.func_77626_a(itemStack) - n;
        ArrowLooseEvent arrowLooseEvent = new ArrowLooseEvent(entityPlayer, itemStack, n2);
        MinecraftForge.EVENT_BUS.post((Event)arrowLooseEvent);
        if (arrowLooseEvent.isCanceled()) {
            return;
        }
        n2 = arrowLooseEvent.charge;
        boolean bl2 = bl = entityPlayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)itemStack) > 0;
        if (bl || entityPlayer.field_71071_by.func_146028_b(Items.field_151032_g)) {
            boolean bl3 = this.isEmpowered(itemStack);
            float f = (float)n2 / 20.0f;
            if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
                f = 1.0f;
            } else if (f < 0.1f) {
                return;
            }
            int n3 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)itemStack);
            int n4 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)itemStack);
            int n5 = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)itemStack);
            int n6 = EnchantmentHelper.func_77506_a((int)CoFHEnchantment.multishot.field_77352_x, (ItemStack)itemStack);
            EntityArrow entityArrow = new EntityArrow(world, (EntityLivingBase)entityPlayer, f * this.arrowSpeedMultiplier);
            double d = entityArrow.func_70242_d() * (double)this.arrowDamageMultiplier * (double)(bl3 ? 1.5f : 1.2f);
            entityArrow.func_70239_b(d);
            if (f == 1.0f) {
                entityArrow.func_70243_d(true);
            }
            if (n3 > 0) {
                entityArrow.func_70239_b(d + (double)n3 * 0.5 + 0.5);
            }
            if (n4 > 0) {
                entityArrow.func_70240_a(n4);
            }
            if (n5 > 0) {
                entityArrow.func_70015_d(100);
            }
            if (bl) {
                entityArrow.field_70251_a = 2;
            } else {
                entityPlayer.field_71071_by.func_146026_a(Items.field_151032_g);
            }
            world.func_72956_a((Entity)entityPlayer, "random.bow", 1.0f, 1.0f / (Item.field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (ServerHelper.isServerWorld((World)world)) {
                world.func_72838_d((Entity)entityArrow);
            }
            for (int i = 0; i < n6; ++i) {
                entityArrow = new EntityArrow(world, (EntityLivingBase)entityPlayer, f * this.arrowSpeedMultiplier);
                entityArrow.func_70186_c(entityArrow.field_70159_w, entityArrow.field_70181_x, entityArrow.field_70179_y, 1.5f * f * this.arrowSpeedMultiplier, 3.0f);
                entityArrow.func_70239_b(d);
                if (f == 1.0f) {
                    entityArrow.func_70243_d(true);
                }
                if (n3 > 0) {
                    entityArrow.func_70239_b(d + (double)n3 * 0.5 + 0.5);
                }
                if (n4 > 0) {
                    entityArrow.func_70240_a(n4);
                }
                if (n5 > 0) {
                    entityArrow.func_70015_d(100);
                }
                entityArrow.field_70251_a = 2;
                world.func_72956_a((Entity)entityPlayer, "random.bow", 1.0f, 1.0f / (Item.field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!ServerHelper.isServerWorld((World)world)) continue;
                world.func_72838_d((Entity)entityArrow);
            }
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.useEnergy(itemStack);
            }
        }
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bl) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + itemStack.field_77990_d.func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
        list.add("\u00a76" + this.getEnergyPerUse(itemStack) + " " + StringHelper.localize((String)"info.redstonearsenal.tool.energyPerUse") + "\u00a7r");
        RAProps.addEmpoweredTip(this, itemStack, list);
    }

    public void setDamage(ItemStack itemStack, int n) {
        super.setDamage(itemStack, 0);
    }

    public int getDisplayDamage(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return this.maxEnergy - itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxDamage(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return !RAProps.showToolCharge ? false : itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74767_n("CreativeTab");
    }

    public boolean isDamaged(ItemStack itemStack) {
        return true;
    }

    public IIcon getIcon(ItemStack itemStack, int n) {
        return this.isEmpowered(itemStack) ? this.activeIcons[0] : (this.getEnergyStored(itemStack) <= 0 ? this.drainedIcon : this.normalIcons[0]);
    }

    public IIcon getIcon(ItemStack itemStack, int n, EntityPlayer entityPlayer, ItemStack itemStack2, int n2) {
        if (this.getEnergyStored(itemStack) <= 0) {
            return this.drainedIcon;
        }
        if (n2 > 0) {
            int n3 = itemStack.func_77988_m() - n2;
            if (n3 > 17) {
                return this.isEmpowered(itemStack) ? this.activeIcons[3] : this.normalIcons[3];
            }
            if (n3 > 13) {
                return this.isEmpowered(itemStack) ? this.activeIcons[2] : this.normalIcons[2];
            }
            if (n3 > 0) {
                return this.isEmpowered(itemStack) ? this.activeIcons[1] : this.normalIcons[1];
            }
        }
        return this.isEmpowered(itemStack) ? this.activeIcons[0] : this.normalIcons[0];
    }

    public void func_94581_a(IIconRegister iIconRegister) {
        super.func_94581_a(iIconRegister);
        this.drainedIcon = iIconRegister.func_94245_a(this.func_111208_A() + "_Drained");
        this.activeIcons[0] = iIconRegister.func_94245_a(this.func_111208_A() + "_Active");
        for (int i = 1; i < 4; ++i) {
            this.activeIcons[i] = iIconRegister.func_94245_a(this.func_111208_A() + "_" + (i - 1) + "_Active");
        }
    }

    public boolean isEmpowered(ItemStack itemStack) {
        return itemStack.field_77990_d == null ? false : itemStack.field_77990_d.func_74767_n("Empowered");
    }

    public boolean setEmpoweredState(ItemStack itemStack, boolean bl) {
        if (this.getEnergyStored(itemStack) > 0) {
            itemStack.field_77990_d.func_74757_a("Empowered", bl);
            return true;
        }
        itemStack.field_77990_d.func_74757_a("Empowered", false);
        return false;
    }

    public void onStateChange(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (this.isEmpowered(itemStack)) {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "ambient.weather.thunder", 0.4f, 1.0f);
        } else {
            entityPlayer.field_70170_p.func_72956_a((Entity)entityPlayer, "random.orb", 0.2f, 0.6f);
        }
    }

    public int receiveEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, Math.min(this.maxEnergy - n2, this.maxTransfer));
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 += n3);
        }
        return n3;
    }

    public int extractEnergy(ItemStack itemStack, int n, boolean bl) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        if (itemStack.field_77990_d.func_74764_b("Unbreakable")) {
            itemStack.field_77990_d.func_82580_o("Unbreakable");
        }
        int n2 = itemStack.field_77990_d.func_74762_e("Energy");
        int n3 = Math.min(n, n2);
        if (!bl) {
            itemStack.field_77990_d.func_74768_a("Energy", n2 -= n3);
            if (n2 == 0) {
                this.setEmpoweredState(itemStack, false);
            }
        }
        return n3;
    }

    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)itemStack, (int)0);
        }
        return itemStack.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return this.maxEnergy;
    }

    public boolean isLastHeldItemEqual(ItemStack itemStack, ItemStack itemStack2) {
        NBTTagCompound nBTTagCompound = itemStack.field_77990_d;
        NBTTagCompound nBTTagCompound2 = itemStack2.field_77990_d;
        if (nBTTagCompound == nBTTagCompound2) {
            return true;
        }
        if (nBTTagCompound == null || nBTTagCompound2 == null) {
            return false;
        }
        nBTTagCompound = (NBTTagCompound)nBTTagCompound.func_74737_b();
        nBTTagCompound2 = (NBTTagCompound)nBTTagCompound2.func_74737_b();
        nBTTagCompound.func_82580_o("Energy");
        nBTTagCompound2.func_82580_o("Energy");
        return nBTTagCompound.equals((Object)nBTTagCompound2);
    }
}

