/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Node;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.IAudioReceiver;
import pl.asie.computronics.api.audio.IAudioSource;
import pl.asie.computronics.api.tape.IItemTapeStorage;
import pl.asie.computronics.cc.ComputronicsFileMount;
import pl.asie.computronics.network.PacketType;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.api.tile.IInventoryProvider;
import pl.asie.lib.network.Packet;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.internal.IColorable;

public class TileTapeDrive
extends TileEntityPeripheralBase
implements IInventoryProvider,
IAudioSource {
    private final IAudioReceiver internalSpeaker = new IAudioReceiver(){

        @Override
        public boolean connectsAudio(ForgeDirection side) {
            return true;
        }

        @Override
        public World getSoundWorld() {
            return TileTapeDrive.this.field_145850_b;
        }

        @Override
        public int getSoundX() {
            return TileTapeDrive.this.field_145851_c;
        }

        @Override
        public int getSoundY() {
            return TileTapeDrive.this.field_145848_d;
        }

        @Override
        public int getSoundZ() {
            return TileTapeDrive.this.field_145849_e;
        }

        @Override
        public int getSoundDistance() {
            return Config.TAPEDRIVE_DISTANCE;
        }

        @Override
        public void receivePacket(AudioPacket packet, ForgeDirection direction) {
            packet.addReceiver(this);
        }
    };
    private String storageName = "";
    private TapeDriveState state;
    private static Object cc_fs;
    private static Object cc_fs_autorun;
    protected HashMap<IComputerAccess, String> computerMountPointsCC;
    protected HashMap<IComputerAccess, String> computerMountPointsCC_autorun;

    public TileTapeDrive() {
        super("tape_drive");
        this.createInventory(1);
        this.state = new TapeDriveState();
    }

    @Optional.Method(modid="ComputerCraft")
    protected IMount cc_fs() {
        return (IMount)cc_fs;
    }

    @Optional.Method(modid="ComputerCraft")
    protected IMount cc_autorun_fs() {
        return (IMount)cc_fs_autorun;
    }

    @Optional.Method(modid="ComputerCraft")
    public static void initCCFilesystem() {
        if (cc_fs == null && (cc_fs = ComputronicsFileMount.createMount(Computronics.class, "computronics", "lua/peripheral/tape_drive/programs/tape_drive")) == null) {
            Computronics.log.error("Unable to create ComputerCraft mount for tape drive programs.");
        }
        if (cc_fs_autorun == null) {
            cc_fs_autorun = ComputronicsFileMount.createMount(Computronics.class, "computronics", "lua/peripheral/tape_drive/autorun/tape_drive");
            if (cc_fs == null) {
                Computronics.log.error("Unable to create ComputerCraft mount for tape drive autorun program.");
            }
        }
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        String mountPoint;
        IMount mount;
        super.attach(computer);
        if (this.computerMountPointsCC == null) {
            this.computerMountPointsCC = new HashMap(2);
        }
        if ((mount = this.cc_fs()) != null && (mountPoint = computer.mount("rom/programs/tape_drive", mount)) != null) {
            this.computerMountPointsCC.put(computer, mountPoint);
        }
        if (this.computerMountPointsCC_autorun == null) {
            this.computerMountPointsCC_autorun = new HashMap(2);
        }
        if ((mount = this.cc_autorun_fs()) != null && (mountPoint = computer.mount("rom/autorun/tape_drive", mount)) != null) {
            this.computerMountPointsCC_autorun.put(computer, mountPoint);
        }
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        String mountPoint;
        super.detach(computer);
        if (this.computerMountPointsCC == null) {
            this.computerMountPointsCC = new HashMap(2);
        }
        if ((mountPoint = this.computerMountPointsCC.remove(computer)) != null) {
            computer.unmount(mountPoint);
        }
        if (this.computerMountPointsCC_autorun == null) {
            this.computerMountPointsCC_autorun = new HashMap(2);
        }
        if ((mountPoint = this.computerMountPointsCC_autorun.remove(computer)) != null) {
            computer.unmount(mountPoint);
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
        super.onConnect(node);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected void onChunkUnload_OC() {
        super.onChunkUnload_OC();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected void invalidate_OC() {
        super.invalidate_OC();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("tape", "Tape drive", "Yanaki Sound Systems", "DFPWM 1", new String[0]);
    }

    protected void sendState() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        try {
            Packet packet = Computronics.packet.create(PacketType.TAPE_GUI_STATE.ordinal()).writeTileLocation((TileEntity)this).writeByte((byte)this.state.getState().ordinal());
            Computronics.packet.sendToAllAround(packet, (TileEntity)this, 64.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TapeDriveState.State getEnumState() {
        return this.state.getState();
    }

    public void switchState(TapeDriveState.State s) {
        if (this.getEnumState() != s) {
            this.state.switchState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, s);
            this.sendState();
        }
    }

    public void setSpeed(float speed) {
        this.state.setSpeed(speed);
    }

    public void setVolume(float vol) {
        this.state.setVolume(vol);
    }

    public boolean isEnd() {
        return this.state.getStorage() == null || this.state.getStorage().getPosition() + this.state.packetSize > this.state.getStorage().getSize();
    }

    public boolean isReady() {
        return this.state.getStorage() != null;
    }

    public int getSize() {
        return this.state.getStorage() != null ? this.state.getStorage().getSize() : 0;
    }

    public int getPosition() {
        return this.state.getStorage() != null ? this.state.getStorage().getPosition() : 0;
    }

    public int seek(int bytes) {
        return this.state.getStorage() != null ? this.state.getStorage().seek(bytes) : 0;
    }

    public int read() {
        return this.read(false);
    }

    public int read(boolean simulate) {
        if (this.state.getStorage() != null) {
            return this.state.getStorage().read(simulate) & 0xFF;
        }
        return 0;
    }

    public byte[] read(int amount) {
        if (this.state.getStorage() != null) {
            byte[] data = new byte[amount];
            this.state.getStorage().read(data, false);
            return data;
        }
        return null;
    }

    public void write(byte b) {
        this.state.getStorage().write(b);
    }

    public int write(byte[] bytes) {
        return this.state.getStorage().write(bytes);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        TapeDriveState.State st = this.getEnumState();
        AudioPacket pkt = this.state.update(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (pkt != null) {
            int receivers = 0;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                if (!(tile instanceof IAudioReceiver) || tile instanceof IColorable && ((IColorable)tile).canBeColored() && !ColorUtils.isSameOrDefault((IColorable)this, (IColorable)((IColorable)tile))) continue;
                ((IAudioReceiver)tile).receivePacket(pkt, dir.getOpposite());
                ++receivers;
            }
            if (receivers == 0) {
                this.internalSpeaker.receivePacket(pkt, ForgeDirection.UNKNOWN);
            }
            pkt.sendPacket();
        }
        if (!this.field_145850_b.field_72995_K && st != this.getEnumState()) {
            this.sendState();
        }
    }

    private void setLabel(String label) {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack.func_77978_p() != null) {
            if (label.length() == 0 && stack.func_77978_p().func_74764_b("label")) {
                stack.func_77978_p().func_82580_o("label");
            } else if (label.length() > 0) {
                stack.func_77978_p().func_74778_a("label", label);
            }
            this.storageName = label;
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_70295_k_() {
        super.func_70295_k_();
        this.sendState();
    }

    public void onBlockDestroy() {
        super.onBlockDestroy();
        this.unloadStorage();
    }

    @Override
    public void func_145843_s() {
        this.unloadStorage();
        super.func_145843_s();
    }

    public void onRedstoneSignal(int signal) {
        this.switchState(signal > 0 ? TapeDriveState.State.PLAYING : TapeDriveState.State.STOPPED);
    }

    @Override
    public boolean shouldPlaySound() {
        switch (this.getEnumState()) {
            case REWINDING: 
            case FORWARDING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSoundName() {
        return "tape_rewind";
    }

    private void loadStorage() {
        ItemStack stack;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.state.getStorage() != null) {
            this.unloadStorage();
        }
        if ((stack = this.func_70301_a(0)) != null) {
            NBTTagCompound tag;
            Item item = stack.func_77973_b();
            if (item instanceof IItemTapeStorage) {
                this.state.setStorage(((IItemTapeStorage)item).getStorage(stack));
            }
            this.storageName = stack.func_77978_p() != null ? ((tag = stack.func_77978_p()).func_74764_b("label") ? tag.func_74779_i("label") : "") : "";
        }
    }

    public void saveStorage() {
        this.unloadStorage();
    }

    private void unloadStorage() {
        if (this.field_145850_b.field_72995_K || this.state.getStorage() == null) {
            return;
        }
        this.switchState(TapeDriveState.State.STOPPED);
        try {
            this.state.getStorage().onStorageUnload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.state.setStorage(null);
    }

    public void onSlotUpdate(int slot) {
        if (this.func_70301_a(0) == null) {
            if (this.state.getStorage() != null) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "computronics:tape_eject", 1.0f, 0.0f);
            }
            this.unloadStorage();
        } else {
            this.loadStorage();
            if (this.func_70301_a(0).func_77973_b() instanceof IItemTapeStorage) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "computronics:tape_insert", 1.0f, 0.0f);
            }
        }
    }

    @Override
    public void onChunkUnload() {
        this.unloadStorage();
        super.onChunkUnload();
    }

    public int func_70302_i_() {
        return 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("state")) {
            this.state.setState(TapeDriveState.State.VALUES[tag.func_74771_c("state")]);
        }
        if (tag.func_74764_b("sp")) {
            this.state.packetSize = tag.func_74765_d("sp");
        }
        this.state.soundVolume = tag.func_74764_b("vo") ? (int)tag.func_74771_c("vo") : 127;
        this.loadStorage();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("sp", (short)this.state.packetSize);
        tag.func_74774_a("state", (byte)this.state.getState().ordinal());
        if (this.state.soundVolume != 127) {
            tag.func_74774_a("vo", (byte)this.state.soundVolume);
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public void readFromNBT_OC(NBTTagCompound tag) {
        super.readFromNBT_OC(tag);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public void writeToNBT_OC(NBTTagCompound tag) {
        super.writeToNBT_OC(tag);
    }

    @Override
    public void writeToRemoteNBT(NBTTagCompound tag) {
        super.writeToRemoteNBT(tag);
        tag.func_74774_a("state", (byte)this.state.getState().ordinal());
    }

    @Override
    public void removeFromNBTForTransfer(NBTTagCompound data) {
        super.removeFromNBTForTransfer(data);
        data.func_82580_o("oc:fs");
        data.func_82580_o("state");
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound tag) {
        super.readFromRemoteNBT(tag);
        if (tag.func_74764_b("state")) {
            this.state.setState(TapeDriveState.State.VALUES[tag.func_74771_c("state")]);
        }
    }

    @Callback(doc="function():boolean; Returns true if the tape drive is empty or the inserted tape has reached its end", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isEnd(Context context, Arguments args) {
        return new Object[]{this.isEnd()};
    }

    @Callback(doc="function():boolean; Returns true if there is a tape inserted", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] isReady(Context context, Arguments args) {
        return new Object[]{this.isReady()};
    }

    @Callback(doc="function():number; Returns the size of the tape, in bytes", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSize(Context context, Arguments args) {
        return new Object[]{this.getSize()};
    }

    @Callback(doc="function():number; Returns the position of the tape, in bytes", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPosition(Context context, Arguments args) {
        return new Object[]{this.getPosition()};
    }

    @Callback(doc="function(label:string):string; Sets the label of the tape. Returns the new label, or nil if there is no tape inserted")
    @Optional.Method(modid="OpenComputers")
    public Object[] setLabel(Context context, Arguments args) {
        this.setLabel(args.checkString(0));
        return new Object[]{this.state.getStorage() != null ? this.storageName : null};
    }

    @Callback(doc="function():string; Returns the current label of the tape, or nil if there is no tape inserted")
    @Optional.Method(modid="OpenComputers")
    public Object[] getLabel(Context context, Arguments args) {
        return new Object[]{this.state.getStorage() != null ? this.storageName : null};
    }

    @Callback(doc="function(length:number):number; Seeks the specified amount of bytes on the tape. Negative values for rewinding. Returns the amount of bytes sought, or nil if there is no tape inserted")
    @Optional.Method(modid="OpenComputers")
    public Object[] seek(Context context, Arguments args) {
        if (this.state.getStorage() != null) {
            return new Object[]{this.seek(args.checkInteger(0))};
        }
        return null;
    }

    @Callback(doc="function([length:number]):string; Reads and returns the specified amount of bytes or a single byte from the tape. Returns nil if there is no tape inserted")
    @Optional.Method(modid="OpenComputers")
    public Object[] read(Context context, Arguments args) {
        if (this.state.getStorage() != null) {
            if (args.count() >= 1 && args.isInteger(0) && args.checkInteger(0) >= 0) {
                return new Object[]{this.read(args.checkInteger(0))};
            }
            return new Object[]{this.read()};
        }
        return null;
    }

    @Callback(doc="function(data:number or string); Writes the specified data to the tape if there is one inserted")
    @Optional.Method(modid="OpenComputers")
    public Object[] write(Context context, Arguments args) {
        if (this.state.getStorage() != null && args.count() >= 1) {
            if (args.isInteger(0)) {
                this.write((byte)args.checkInteger(0));
            } else if (args.isByteArray(0)) {
                this.write(args.checkByteArray(0));
            } else {
                throw new IllegalArgumentException("bad arguments #1 (number or string expected)");
            }
        }
        return null;
    }

    @Callback(doc="function():boolean; Make the Tape Drive start playing the tape. Returns true on success")
    @Optional.Method(modid="OpenComputers")
    public Object[] play(Context context, Arguments args) {
        this.switchState(TapeDriveState.State.PLAYING);
        return new Object[]{this.state.getStorage() != null && this.getEnumState() == TapeDriveState.State.PLAYING};
    }

    @Callback(doc="function():boolean; Make the Tape Drive stop playing the tape. Returns true on success")
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments args) {
        this.switchState(TapeDriveState.State.STOPPED);
        return new Object[]{this.state.getStorage() != null && this.getEnumState() == TapeDriveState.State.STOPPED};
    }

    @Callback(doc="function(speed:number):boolean; Sets the speed of the tape drive. Needs to be beween 0.25 and 2. Returns true on success")
    @Optional.Method(modid="OpenComputers")
    public Object[] setSpeed(Context context, Arguments args) {
        return new Object[]{this.state.setSpeed((float)args.checkDouble(0))};
    }

    @Callback(doc="function(speed:number); Sets the volume of the tape drive. Needs to be beween 0 and 1")
    @Optional.Method(modid="OpenComputers")
    public Object[] setVolume(Context context, Arguments args) {
        this.state.setVolume((float)args.checkDouble(0));
        return null;
    }

    @Callback(doc="function():string; Returns the current state of the tape drive", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getState(Context context, Arguments args) {
        return new Object[]{this.state.getState().toString()};
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"isEnd", "isReady", "getSize", "getLabel", "getState", "setLabel", "setSpeed", "setVolume", "seek", "read", "write", "play", "stop", "getPosition"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.isEnd()};
            }
            case 1: {
                return new Object[]{this.isReady()};
            }
            case 2: {
                return new Object[]{this.getSize()};
            }
            case 3: {
                return new Object[]{this.state.getStorage() != null ? this.storageName : null};
            }
            case 4: {
                return new Object[]{this.state.getState().toString()};
            }
            case 9: {
                if (arguments.length >= 1) break;
                if (this.state.getStorage() != null) {
                    return new Object[]{this.read()};
                }
                return null;
            }
            case 11: {
                this.switchState(TapeDriveState.State.PLAYING);
                return new Object[]{this.state.getStorage() != null && this.getEnumState() == TapeDriveState.State.PLAYING};
            }
            case 12: {
                this.switchState(TapeDriveState.State.STOPPED);
                return new Object[]{this.state.getStorage() != null && this.getEnumState() == TapeDriveState.State.STOPPED};
            }
            case 13: {
                return new Object[]{this.getPosition()};
            }
        }
        switch (method) {
            case 5: {
                if (arguments.length >= 1 && arguments[0] instanceof String) break;
                throw new LuaException("first argument needs to be a string");
            }
            case 6: 
            case 7: 
            case 8: {
                if (arguments.length >= 1 && arguments[0] instanceof Number) break;
                throw new LuaException("first argument needs to be a number");
            }
            case 9: {
                if (arguments.length >= 1 && arguments[0] instanceof Number) break;
                throw new LuaException("first argument needs to be a number or non-existant");
            }
            case 10: {
                if (arguments.length >= 1 && (arguments[0] instanceof String || arguments[0] instanceof Number)) break;
                throw new LuaException("first argument needs to be a number or string");
            }
        }
        if (arguments.length < 1) {
            throw new LuaException("no first argument found");
        }
        if (arguments[0] instanceof String) {
            switch (method) {
                case 5: {
                    this.setLabel((String)arguments[0]);
                    return new Object[]{this.state.getStorage() != null ? this.storageName : null};
                }
                case 10: {
                    if (this.state.getStorage() == null) break;
                    return new Object[]{this.write(((String)arguments[0]).getBytes(Charsets.UTF_8))};
                }
            }
        } else if (arguments[0] instanceof Number) {
            switch (method) {
                case 6: {
                    return new Object[]{this.state.setSpeed(((Number)arguments[0]).floatValue())};
                }
                case 7: {
                    this.state.setVolume(((Number)arguments[0]).floatValue());
                    return null;
                }
                case 8: {
                    if (this.state.getStorage() == null) break;
                    return new Object[]{this.state.getStorage().seek(((Number)arguments[0]).intValue())};
                }
                case 9: {
                    int i = ((Number)arguments[0]).intValue();
                    if (this.state.getStorage() != null) {
                        if (i >= 256) {
                            i = 256;
                        }
                        return new Object[]{new String(this.read(i), Charsets.UTF_8)};
                    }
                    return null;
                }
                case 10: {
                    if (this.state.getStorage() == null) break;
                    this.write((byte)((Number)arguments[0]).intValue());
                }
            }
        }
        return null;
    }

    @Override
    public int getSourceId() {
        return this.state.getId();
    }

    @Override
    public boolean connectsAudio(ForgeDirection side) {
        return true;
    }
}

