/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import mods.immibis.redlogic.api.wiring.IBundledEmitter;
import mods.immibis.redlogic.api.wiring.IBundledUpdatable;
import mods.immibis.redlogic.api.wiring.IConnectable;
import mods.immibis.redlogic.api.wiring.IWire;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.ProjectRedAPI;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pl.asie.computronics.block.BlockColorfulLamp;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.LampUtil;
import pl.asie.computronics.util.OCUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="mods.immibis.redlogic.api.wiring.IBundledUpdatable", modid="RedLogic"), @Optional.Interface(iface="mods.immibis.redlogic.api.wiring.IConnectable", modid="RedLogic"), @Optional.Interface(iface="mrtjp.projectred.api.IBundledTile", modid="ProjRed|Core")})
public class TileColorfulLamp
extends TileEntityPeripheralBase
implements IBundledTile,
IBundledUpdatable,
IConnectable {
    private int color = 25368;
    private boolean initialized = false;
    private boolean binaryMode = false;

    public TileColorfulLamp() {
        super("colorful_lamp");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.initialized && block instanceof BlockColorfulLamp) {
            if (LampUtil.shouldColorLight()) {
                ((BlockColorfulLamp)block).setLightValue(this.color);
            } else {
                ((BlockColorfulLamp)block).setLightValue(this.color == 0 ? 0 : 15);
            }
            this.initialized = true;
        }
    }

    public int getLampColor() {
        return this.color;
    }

    public void setLampColor(int color) {
        this.color = color & Short.MAX_VALUE;
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockColorfulLamp) {
            if (LampUtil.shouldColorLight()) {
                ((BlockColorfulLamp)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)).setLightValue(this.color);
            } else {
                ((BlockColorfulLamp)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)).setLightValue(color == 0 ? 0 : 15);
            }
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Callback(doc="function():number; Returns the current lamp color", direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getLampColor(Context context, Arguments args) throws Exception {
        return new Object[]{this.getLampColor()};
    }

    @Callback(doc="function(color:number):boolean; Sets the lamp color; Set to 0 to turn the off the lamp; Returns true on success")
    @Optional.Method(modid="OpenComputers")
    public Object[] setLampColor(Context context, Arguments args) throws Exception {
        if (args.checkInteger(0) >= 0 && args.checkInteger(0) <= 65535) {
            this.setLampColor(args.checkInteger(0));
            return new Object[]{true};
        }
        return new Object[]{false, "number must be between 0 and 32767"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("display", "Colored Lamp", "Lumiose Lighting", "LED-4", new String[0]);
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getLampColor", "setLampColor"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            default: {
                return new Object[]{this.color};
            }
            case 1: 
        }
        if (arguments.length > 0 && arguments[0] instanceof Double) {
            this.setLampColor(((Double)arguments[0]).intValue());
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("clc")) {
            this.color = tag.func_74765_d("clc");
        }
        if (this.color < 0) {
            this.color = 0;
        }
        if (tag.func_74764_b("binaryMode")) {
            this.binaryMode = tag.func_74767_n("binaryMode");
        }
    }

    @Override
    public boolean canBeColored() {
        return false;
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean mode) {
        this.binaryMode = mode;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74777_a("clc", (short)(this.color & Short.MAX_VALUE));
        tag.func_74757_a("binaryMode", this.binaryMode);
    }

    @Override
    public void writeToRemoteNBT(NBTTagCompound tag) {
        super.writeToRemoteNBT(tag);
        tag.func_74777_a("clc", (short)(this.color & Short.MAX_VALUE));
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound tag) {
        super.readFromRemoteNBT(tag);
        int oldColor = this.color;
        if (tag.func_74764_b("clc")) {
            this.color = tag.func_74765_d("clc");
        }
        if (this.color < 0) {
            this.color = 0;
        }
        if (oldColor != this.color) {
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private boolean parseBundledInput(byte[] data) {
        if (data != null) {
            int c = 0;
            for (int i = 0; i < 15; ++i) {
                if (data[i] == 0) continue;
                c |= 1 << i;
            }
            this.setLampColor(c);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="ProjRed|Core")
    public byte[] getBundledSignal(int side) {
        return null;
    }

    @Optional.Method(modid="ProjRed|Core")
    public boolean canConnectBundled(int side) {
        return true;
    }

    @Optional.Method(modid="ProjRed|Core")
    public void onProjectRedBundledInputChanged() {
        for (int i = 0; i < 6; ++i) {
            if (!this.parseBundledInput(ProjectRedAPI.transmissionAPI.getBundledInput(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, i))) continue;
            return;
        }
    }

    @Optional.Method(modid="RedLogic")
    public boolean connects(IWire wire, int blockFace, int fromDirection) {
        return wire instanceof IBundledEmitter;
    }

    @Optional.Method(modid="RedLogic")
    public boolean connectsAroundCorner(IWire wire, int blockFace, int fromDirection) {
        return false;
    }

    @Optional.Method(modid="RedLogic")
    public void onBundledInputChanged() {
        for (int side = 0; side < 6; ++side) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            TileEntity input = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!(input instanceof IBundledEmitter)) continue;
            for (int direction = -1; direction < 6; ++direction) {
                byte[] data = ((IBundledEmitter)input).getBundledCableStrength(direction, side ^ 1);
                if (!this.parseBundledInput(data)) continue;
                return;
            }
        }
    }
}

