/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import java.util.Map;
import java.util.Random;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DeviceInfo;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.ManagedEnvironment;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.ParticleUtils;

public class DriverCardFX
extends ManagedEnvironment
implements DeviceInfo {
    protected final EnvironmentHost container;
    protected Map<String, String> deviceInfo;

    public DriverCardFX(EnvironmentHost container) {
        this.container = container;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("particle").withConnector(Config.FX_ENERGY_COST * 32.0).create());
    }

    @Callback(doc="function(name:string, xCoord:number, yCoord:number, zCoord:number [, defaultVelo:number]):boolean; function(name:string, xCoord:number, yCoord:number, zCoord:number [, xVelo:number, yVelo:number, zVelo:number]):boolean; Spawns a particle effect at the specified relative coordinates optionally with the specified velocity", direct=true, limit=16)
    public Object[] spawn(Context context, Arguments args) {
        String name = args.checkString(0);
        if (name.length() > Short.MAX_VALUE) {
            return new Object[]{false, "name too long"};
        }
        double xOffset = args.checkDouble(1);
        double yOffset = args.checkDouble(2);
        double zOffset = args.checkDouble(3);
        if (((Connector)this.node()).tryChangeBuffer(0.0 - Config.FX_ENERGY_COST)) {
            Random rng = this.container.world().field_73012_v;
            double x = this.container.xPosition() + 0.5 + xOffset;
            double y = this.container.yPosition() + 0.5 + yOffset;
            double z = this.container.zPosition() + 0.5 + zOffset;
            double defaultv = rng.nextDouble() * 0.1;
            if (args.count() >= 5) {
                defaultv = args.checkDouble(4);
            }
            double vx = defaultv * rng.nextGaussian();
            double vy = defaultv * rng.nextGaussian();
            double vz = defaultv * rng.nextGaussian();
            if (args.count() >= 7) {
                vx = args.checkDouble(4);
                vy = args.checkDouble(5);
                vz = args.checkDouble(6);
            }
            ParticleUtils.sendParticlePacket(name, this.container.world(), x, y, z, vx, vy, vz);
            return new Object[]{true};
        }
        return new Object[]{false};
    }

    public Map<String, String> getDeviceInfo() {
        if (this.deviceInfo == null) {
            this.deviceInfo = new OCUtils.Device("generic", "Particle emitter", "Siekierka Innovations", "Holotron FX-84", new String[0]).deviceInfo();
            return this.deviceInfo;
        }
        return this.deviceInfo;
    }
}

