/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import pl.asie.computronics.oc.driver.DriverCardSoundBase;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.sound.AudioType;
import pl.asie.computronics.util.sound.Channel;

public class DriverCardBeep
extends DriverCardSoundBase {
    public DriverCardBeep(EnvironmentHost host) {
        super(host, "beep");
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Neighbors).withComponent("beep").withConnector(Config.SOUND_ENERGY_COST * 42.0).create());
    }

    @Override
    protected AudioType getMode(int channel) {
        return AudioType.Square;
    }

    @Callback(doc="function():number; returns the amount of beeps currently being played", direct=true, limit=10)
    public Object[] getBeepCount(Context context, Arguments args) {
        return new Object[]{this.getActiveChannelCount()};
    }

    @Callback(doc="function(frequencyDurationTable:table):boolean; table needs to contain frequency-duration pairs; plays each frequency for the specified duration. Returns true on success.", direct=true, limit=10)
    public Object[] beep(Context context, Arguments args) throws Exception {
        Map map = args.checkTable(0);
        if (map.size() > 8) {
            return new Object[]{false, "table must not contain more than 8 frequencies"};
        }
        if (this.getActiveChannelCount() + map.size() > 8) {
            return new Object[]{false, "already too many sounds playing, maximum is 8"};
        }
        Channel.FreqPair[] freqPairs = new Channel.FreqPair[8];
        double longest = 0.0;
        block0: for (Map.Entry entryObj : map.entrySet()) {
            if (!(entryObj instanceof Map.Entry)) continue;
            Object freqObj = entryObj.getKey();
            if (!(freqObj instanceof Number)) {
                throw new IllegalArgumentException("frequency '" + String.valueOf(freqObj) + "' is not a number");
            }
            Object durObj = entryObj.getValue();
            if (durObj != null && !(durObj instanceof Number)) {
                throw new IllegalArgumentException("duration '" + String.valueOf(durObj) + "' is not a number");
            }
            double frequency = ((Number)freqObj).doubleValue();
            if (frequency < 20.0 || frequency > 2000.0) {
                throw new IllegalArgumentException("invalid frequency, must be in [20, 2000]");
            }
            double duration = DriverCardBeep.optDouble(durObj != null ? (Number)((Number)durObj) : (Number)null, 0.1);
            int durationInMilliseconds = Math.max(50, Math.min(5000, (int)(duration * 1000.0)));
            longest = Math.max(longest, Math.max(50.0, Math.min(5000.0, duration * 1000.0)));
            long time = this.host.world().func_82737_E() + (long)(durationInMilliseconds / 1000 * 20);
            for (int i = 0; i < this.expirationList.length; ++i) {
                if (this.expirationList[i] != null) continue;
                this.expirationList[i] = time;
                freqPairs[i] = new Channel.FreqPair((float)frequency, durationInMilliseconds);
                continue block0;
            }
        }
        return this.tryQueueSound(freqPairs, new Object[]{true}, Config.SOUND_ENERGY_COST * (double)DriverCardBeep.getNonNullCount(freqPairs) * (longest / 1000.0), this.playMethodName);
    }

    @Override
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("multimedia", "Audio interface", "Yanaki Sound Systems", "SQ532", new String[0]);
    }
}

