/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.network;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketClientHandler;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.network.PacketType;
import pl.asie.computronics.oc.driver.DriverCardNoise;
import pl.asie.computronics.oc.driver.DriverCardSoundBase;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.tile.TileTapeDrive;
import pl.asie.lib.network.MessageHandlerBase;
import pl.asie.lib.network.Packet;

public class NetworkHandlerClient
extends MessageHandlerBase {
    private static final AudioFormat DFPWM_DECODED_FORMAT = new AudioFormat(32768.0f, 8, 1, false, false);

    public void onMessage(Packet packet, INetHandler handler, EntityPlayer player, int command) throws IOException {
        PacketType type = PacketType.of(command);
        if (type == null) {
            return;
        }
        switch (type) {
            case TAPE_GUI_STATE: {
                TileEntity entity = packet.readTileEntity();
                TapeDriveState.State state = TapeDriveState.State.VALUES[packet.readUnsignedByte()];
                if (!(entity instanceof TileTapeDrive)) break;
                TileTapeDrive tile = (TileTapeDrive)entity;
                tile.switchState(state);
                break;
            }
            case AUDIO_DATA: {
                short handlerId = packet.readShort();
                AudioPacketClientHandler packetHandler = AudioPacketRegistry.INSTANCE.getClientHandler(handlerId);
                if (packetHandler == null) break;
                packetHandler.receivePacket(packet);
                break;
            }
            case AUDIO_STOP: {
                int managerId = packet.readInt();
                int codecId = packet.readInt();
                AudioPacketRegistry.INSTANCE.getManager(managerId).removePlayer(codecId);
                break;
            }
            case PARTICLE_SPAWN: {
                double x = packet.readFloat();
                double y = packet.readFloat();
                double z = packet.readFloat();
                double vx = packet.readFloat();
                double vy = packet.readFloat();
                double vz = packet.readFloat();
                String name = packet.readString();
                Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_72869_a(name, x, y, z, vx, vy, vz);
                break;
            }
            case COMPUTER_BEEP: {
                if (!Mods.isLoaded("OpenComputers")) break;
                DriverCardSoundBase.onSound(packet, player);
                break;
            }
            case COMPUTER_NOISE: {
                if (!Mods.isLoaded("OpenComputers")) break;
                DriverCardNoise.onSound(packet, player);
                break;
            }
            case COMPUTER_BOOM: {
                if (!Mods.isLoaded("OpenComputers")) break;
                Computronics.proxy.goBoom(packet);
                break;
            }
            case TICKET_SYNC: {
                if (!Mods.isLoaded("Railcraft")) break;
                Computronics.railcraft.onMessageRailcraft(packet, player, false);
            }
        }
    }

    private static class CodecData {
        public final int x;
        public final int y;
        public final int z;
        public final byte[] data;

        public CodecData(int x, int y, int z, byte[] data) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.data = data;
        }
    }
}

