/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.waila.providers;

import java.util.List;
import java.util.Locale;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.tape.IItemTapeStorage;
import pl.asie.computronics.integration.waila.ConfigValues;
import pl.asie.computronics.integration.waila.providers.ComputronicsWailaProvider;
import pl.asie.computronics.tile.TapeDriveState;
import pl.asie.computronics.tile.TileTapeDrive;
import pl.asie.computronics.util.StringUtil;

public class WailaTapeDrive
extends ComputronicsWailaProvider {
    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!ConfigValues.Tape.getValue(config)) {
            return currenttip;
        }
        NBTTagCompound data = accessor.getNBTData();
        ItemStack is = ItemStack.func_77949_a((NBTTagCompound)data.func_150295_c("Inventory", 10).func_150305_b(0));
        if (is != null && is.func_77973_b() instanceof IItemTapeStorage) {
            String label = Computronics.itemTape.getLabel(is);
            if (label.length() > 0 && ConfigValues.TapeName.getValue(config)) {
                currenttip.add(StringUtil.localizeAndFormat("tooltip.computronics.waila.tape.labeltapeinserted", label + SpecialChars.RESET));
            } else {
                currenttip.add(StringUtil.localize("tooltip.computronics.waila.tape.tapeinserted"));
            }
            if (ConfigValues.DriveState.getValue(config)) {
                currenttip.add(StringUtil.localizeAndFormat("tooltip.computronics.waila.tape.state", StringUtil.localize("tooltip.computronics.waila.tape.state." + TapeDriveState.State.VALUES[data.func_74771_c("state")].name().toLowerCase(Locale.ENGLISH))));
            }
        } else {
            currenttip.add(StringUtil.localize("tooltip.computronics.waila.tape.notapeinserted"));
        }
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileTapeDrive) {
            TileTapeDrive drive = (TileTapeDrive)te;
            NBTTagCompound data = new NBTTagCompound();
            drive.func_145841_b(data);
            tag.func_74774_a("state", data.func_74771_c("state"));
            tag.func_74782_a("Inventory", (NBTBase)data.func_150295_c("Inventory", 10));
        }
        return tag;
    }
}

