/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import net.minecraftforge.common.config.Configuration;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.cc.CCPeripheralProvider;
import pl.asie.computronics.cc.MusicalTurtleUpgrade;
import pl.asie.computronics.cc.ParticleTurtleUpgrade;
import pl.asie.computronics.cc.RadarTurtleUpgrade;
import pl.asie.computronics.cc.SpeakingTurtleUpgrade;
import pl.asie.computronics.cc.multiperipheral.MultiPeripheralProvider;
import pl.asie.computronics.integration.appeng.DriverSpatialIOPort;
import pl.asie.computronics.integration.armourersworkshop.DriverMannequin;
import pl.asie.computronics.integration.buildcraft.DriverHeatable;
import pl.asie.computronics.integration.cofh.DriverEnergyProvider;
import pl.asie.computronics.integration.cofh.DriverEnergyReceiver;
import pl.asie.computronics.integration.draconicevolution.DriverExtendedRFStorage;
import pl.asie.computronics.integration.enderio.DriverAbstractMachine;
import pl.asie.computronics.integration.enderio.DriverAbstractPoweredMachine;
import pl.asie.computronics.integration.enderio.DriverCapacitorBank;
import pl.asie.computronics.integration.enderio.DriverCapacitorBankOld;
import pl.asie.computronics.integration.enderio.DriverHasExperience;
import pl.asie.computronics.integration.enderio.DriverIOConfigurable;
import pl.asie.computronics.integration.enderio.DriverPowerMonitor;
import pl.asie.computronics.integration.enderio.DriverPowerStorage;
import pl.asie.computronics.integration.enderio.DriverProgressTile;
import pl.asie.computronics.integration.enderio.DriverRedstoneControllable;
import pl.asie.computronics.integration.enderio.DriverTelepad;
import pl.asie.computronics.integration.enderio.DriverTransceiver;
import pl.asie.computronics.integration.enderio.DriverVacuumChest;
import pl.asie.computronics.integration.enderio.DriverWeatherObelisk;
import pl.asie.computronics.integration.factorization.DriverChargeConductor;
import pl.asie.computronics.integration.flamingo.DriverFlamingo;
import pl.asie.computronics.integration.fsp.DriverSteamTransporter;
import pl.asie.computronics.integration.mekanism.DriverStrictEnergyStorage;
import pl.asie.computronics.integration.mfr.DriverDeepStorageUnit;
import pl.asie.computronics.integration.railcraft.driver.DriverBoilerFirebox;
import pl.asie.computronics.integration.railcraft.driver.DriverElectricGrid;
import pl.asie.computronics.integration.railcraft.driver.DriverRoutingDetector;
import pl.asie.computronics.integration.railcraft.driver.DriverRoutingSwitch;
import pl.asie.computronics.integration.railcraft.driver.DriverSteamTurbine;
import pl.asie.computronics.integration.railcraft.driver.track.DriverLauncherTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverLimiterTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverLocomotiveTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverPoweredTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverPrimingTrack;
import pl.asie.computronics.integration.railcraft.driver.track.DriverRoutingTrack;
import pl.asie.computronics.integration.redlogic.DriverLamp;
import pl.asie.computronics.integration.storagedrawers.DriverDrawerGroup;
import pl.asie.computronics.reference.Compat;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileTapeDrive;

public class IntegrationComputerCraft {
    private final Configuration config;
    private final Compat compat;
    private final Computronics computronics;
    private MultiPeripheralProvider multiPeripheralProvider;

    public IntegrationComputerCraft(Computronics computronics) {
        this.computronics = computronics;
        this.config = computronics.config.config;
        this.compat = computronics.compat;
    }

    @Optional.Method(modid="ComputerCraft")
    public void init() {
        if (Mods.isLoaded("RedLogic") && this.compat.isCompatEnabled("enableRedLogicLamps")) {
            Computronics.registerMultiPeripheralProvider(new DriverLamp.CCDriver());
        }
        if (Mods.isClassLoaded("powercrystals.minefactoryreloaded.api.IDeepStorageUnit") && this.compat.isCompatEnabled("enableDeepStorageUnit")) {
            Computronics.registerMultiPeripheralProvider(new DriverDeepStorageUnit.CCDriver());
        }
        if (Mods.isLoaded("StorageDrawers") && this.compat.isCompatEnabled("enableStorageDrawersDriver")) {
            Computronics.registerMultiPeripheralProvider(new DriverDrawerGroup.CCDriver());
        }
        if (Mods.isLoaded("Steamcraft") && this.compat.isCompatEnabled("enableFlaxbeardSteamTransporters")) {
            Computronics.registerMultiPeripheralProvider(new DriverSteamTransporter.CCDriver());
        }
        if (Mods.isLoaded("factorization") && this.compat.isCompatEnabled("enableFactorizationChargePeripheral")) {
            Computronics.registerMultiPeripheralProvider(new DriverChargeConductor.CCDriver());
        }
        if (Mods.isLoaded("Railcraft") && this.compat.isCompatEnabled("enableRailcraftRoutingComponents")) {
            Computronics.registerMultiPeripheralProvider(new DriverPoweredTrack.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverRoutingTrack.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverRoutingDetector.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverRoutingSwitch.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverElectricGrid.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverLimiterTrack.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverLocomotiveTrack.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverLauncherTrack.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverPrimingTrack.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverBoilerFirebox.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverSteamTurbine.CCDriver());
        }
        if (Mods.isLoaded("armourersWorkshop") && this.compat.isCompatEnabled("enableAWMannequinDriver")) {
            Computronics.registerMultiPeripheralProvider(new DriverMannequin.CCDriver());
        }
        if (Mods.isLoaded("appliedenergistics2") && this.compat.isCompatEnabled("enableAE2SpatialIOComponent")) {
            Computronics.registerMultiPeripheralProvider(new DriverSpatialIOPort.CCDriver());
        }
        if (Mods.API.hasAPI("CoFHAPI|energy") && this.compat.isCompatEnabled("enableRedstoneFluxPeripheral")) {
            Computronics.registerMultiPeripheralProvider(new DriverEnergyReceiver.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverEnergyProvider.CCDriver());
        }
        if (Mods.isLoaded("EnderIO") && this.compat.isCompatEnabled("enableEnderIOComponents")) {
            Computronics.registerMultiPeripheralProvider(new DriverRedstoneControllable.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverIOConfigurable.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverHasExperience.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverPowerStorage.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverProgressTile.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverAbstractMachine.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverAbstractPoweredMachine.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverPowerMonitor.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverCapacitorBank.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverCapacitorBankOld.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverTransceiver.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverVacuumChest.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverWeatherObelisk.CCDriver());
            Computronics.registerMultiPeripheralProvider(new DriverTelepad.CCDriver());
        }
        if (Mods.API.hasAPI("DraconicEvolution|API") && this.compat.isCompatEnabled("enableDraconicEvolutionEnergyStoragePeripheral")) {
            Computronics.registerMultiPeripheralProvider(new DriverExtendedRFStorage.CCDriver());
        }
        if (Mods.API.hasAPI("MekanismAPI|energy") && this.compat.isCompatEnabled("enableMekanismEnergyStoragePeripheral")) {
            Computronics.registerMultiPeripheralProvider(new DriverStrictEnergyStorage.CCDriver());
        }
        if (Mods.hasVersion("BuildCraftAPI|tiles", "[1.1,)") && this.compat.isCompatEnabled("enableBuildCraftDrivers")) {
            Computronics.registerMultiPeripheralProvider(new DriverHeatable.CCDriver());
        }
        if (Mods.isLoaded("Flamingo") && this.compat.isCompatEnabled("enableFlamingoDriver")) {
            Computronics.registerMultiPeripheralProvider(new DriverFlamingo.CCDriver());
        }
        Computronics.registerMultiPeripheralProvider(new CCPeripheralProvider());
        this.multiPeripheralProvider = new MultiPeripheralProvider(Computronics.peripheralRegistry.peripheralProviders);
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)this.multiPeripheralProvider);
        if (Computronics.itemTape != null) {
            ComputerCraftAPI.registerMediaProvider((IMediaProvider)Computronics.itemTape);
        }
        if (this.computronics.isEnabled("ccTurtleUpgrades", true)) {
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new SpeakingTurtleUpgrade(this.config.get("turtleUpgradeIDs", "speaking", 190).getInt()));
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new RadarTurtleUpgrade(this.config.get("turtleUpgradeIDs", "radar", 191).getInt()));
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new MusicalTurtleUpgrade(this.config.get("turtleUpgradeIDs", "musical", 192).getInt()));
            ComputerCraftAPI.registerTurtleUpgrade((ITurtleUpgrade)new ParticleTurtleUpgrade(this.config.get("turtleUpgradeIDs", "particle", 193).getInt()));
        }
        if (Computronics.tapeReader != null) {
            TileTapeDrive.initCCFilesystem();
        }
    }

    public void serverStart() {
        if (this.multiPeripheralProvider != null && Config.CC_ALWAYS_FIRST) {
            this.multiPeripheralProvider.sort();
        }
    }
}

