/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.tile.TileRadar;
import pl.asie.computronics.util.RadarUtils;
import pl.asie.computronics.util.TableUtils;

public class CCRadarProxy {
    private static AxisAlignedBB getBounds(int xCoord, int yCoord, int zCoord, int d) {
        int distance = Math.min(d, Config.RADAR_RANGE);
        if (distance < 1) {
            distance = 1;
        }
        return AxisAlignedBB.func_72330_a((double)xCoord, (double)yCoord, (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 1), (double)(zCoord + 1)).func_72314_b((double)distance, (double)distance, (double)distance);
    }

    @Optional.Method(modid="ComputerCraft")
    public static String[] getMethodNames() {
        return new String[]{"getEntities", "getPlayers", "getMobs", "getItems"};
    }

    @Optional.Method(modid="ComputerCraft")
    public static Object[] callMethod(World worldObj, int xCoord, int yCoord, int zCoord, IComputerAccess computer, ILuaContext context, int method, Object[] arguments, Object powerProvider) throws LuaException, InterruptedException {
        int distance = Config.RADAR_RANGE;
        if (arguments.length >= 1 && arguments[0] instanceof Double && ((distance = ((Double)arguments[0]).intValue()) <= 0 || distance > Config.RADAR_RANGE)) {
            distance = Config.RADAR_RANGE;
        }
        double energyNeeded = Config.RADAR_ENERGY_COST_OC * (double)distance;
        if (method == 0) {
            energyNeeded *= 1.75;
        } else if (method == 3) {
            energyNeeded *= 2.0;
        }
        if (powerProvider instanceof TileRadar && !((TileRadar)powerProvider).extractFromBattery(energyNeeded)) {
            return null;
        }
        if (powerProvider instanceof ITurtleAccess && ((ITurtleAccess)powerProvider).isFuelNeeded() && !((ITurtleAccess)powerProvider).consumeFuel((int)Math.ceil(energyNeeded))) {
            return null;
        }
        AxisAlignedBB bounds = CCRadarProxy.getBounds(xCoord, yCoord, zCoord, distance);
        HashSet<Map<String, Object>> entities = new HashSet<Map<String, Object>>();
        if (method == 0 || method == 1) {
            entities.addAll(RadarUtils.getEntities(worldObj, xCoord, yCoord, zCoord, bounds, EntityPlayer.class));
        }
        if (method == 0 || method == 2) {
            entities.addAll(RadarUtils.getEntities(worldObj, xCoord, yCoord, zCoord, bounds, EntityLiving.class));
        }
        if (method == 3) {
            entities.addAll(RadarUtils.getItems(worldObj, xCoord, yCoord, zCoord, bounds, EntityItem.class));
        }
        return new Object[]{TableUtils.convertSetToMap(entities)};
    }
}

