/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Optional;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import pl.asie.computronics.CommonProxy;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.audio.AudioPacketDFPWM;
import pl.asie.computronics.api.audio.AudioPacketRegistry;
import pl.asie.computronics.audio.AudioPacketClientHandlerDFPWM;
import pl.asie.computronics.audio.SoundCardPacket;
import pl.asie.computronics.audio.SoundCardPacketClientHandler;
import pl.asie.computronics.client.AudioCableRender;
import pl.asie.computronics.client.LampRender;
import pl.asie.computronics.oc.IntegrationOpenComputers;
import pl.asie.computronics.oc.client.RackMountableRenderer;
import pl.asie.computronics.oc.client.UpgradeRenderer;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.boom.SelfDestruct;
import pl.asie.computronics.util.sound.Audio;
import pl.asie.lib.network.Packet;

public class ClientProxy
extends CommonProxy {
    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void registerAudioHandlers() {
        super.registerAudioHandlers();
        AudioPacketRegistry.INSTANCE.registerClientHandler(AudioPacketDFPWM.class, new AudioPacketClientHandlerDFPWM());
    }

    @Override
    public void registerEntities() {
        super.registerEntities();
    }

    @Override
    public void init() {
        Audio.init();
        this.registerRenderers();
    }

    public void registerRenderers() {
        if (Computronics.colorfulLamp != null) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new LampRender());
        }
        if (Computronics.audioCable != null) {
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new AudioCableRender());
        }
        if (Computronics.railcraft != null) {
            Computronics.railcraft.registerRenderers();
        }
        if (Mods.isLoaded("OpenComputers")) {
            this.registerOpenComputersRenderers();
            if (Computronics.forestry != null) {
                Computronics.forestry.registerOCRenderers();
            }
        }
    }

    @Override
    public void onServerStop() {
        Computronics.instance.audio.removeAll();
    }

    @Override
    public void goBoom(Packet p) throws IOException {
        double x = p.readDouble();
        double y = p.readDouble();
        double z = p.readDouble();
        float force = p.readFloat();
        boolean destroyBlocks = p.readByte() != 0;
        Minecraft minecraft = Minecraft.func_71410_x();
        SelfDestruct explosion = new SelfDestruct((World)minecraft.field_71441_e, null, x, y, z, force, destroyBlocks);
        int size = p.readInt();
        ArrayList<ChunkPosition> list = new ArrayList<ChunkPosition>(size);
        int i = (int)x;
        int j = (int)y;
        int k = (int)z;
        for (int i1 = 0; i1 < size; ++i1) {
            int j1 = p.readByte() + i;
            int k1 = p.readByte() + j;
            int l1 = p.readByte() + k;
            list.add(new ChunkPosition(j1, k1, l1));
        }
        explosion.field_77281_g = list;
        explosion.func_77279_a(true);
        minecraft.field_71439_g.field_70159_w += (double)p.readFloat();
        minecraft.field_71439_g.field_70181_x += (double)p.readFloat();
        minecraft.field_71439_g.field_70179_y += (double)p.readFloat();
    }

    @Override
    @Optional.Method(modid="Forestry")
    public void spawnSwarmParticle(World worldObj, double xPos, double yPos, double zPos, int color) {
        Computronics.forestry.spawnSwarmParticle(worldObj, xPos, yPos, zPos, color);
    }

    @Optional.Method(modid="OpenComputers")
    private void registerOpenComputersRenderers() {
        if (IntegrationOpenComputers.upgradeRenderer == null) {
            IntegrationOpenComputers.upgradeRenderer = new UpgradeRenderer();
        }
        MinecraftForge.EVENT_BUS.register((Object)IntegrationOpenComputers.upgradeRenderer);
        if (IntegrationOpenComputers.mountableRenderer == null) {
            IntegrationOpenComputers.mountableRenderer = new RackMountableRenderer();
        }
        MinecraftForge.EVENT_BUS.register((Object)IntegrationOpenComputers.mountableRenderer);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    protected void registerOpenComputersAudioHandlers() {
        super.registerOpenComputersAudioHandlers();
        AudioPacketRegistry.INSTANCE.registerClientHandler(SoundCardPacket.class, new SoundCardPacketClientHandler());
    }
}

