/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.client;

import cofh.api.tileentity.IRedstoneControl;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabRedstone;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.gui.container.ContainerDuctConnection;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiDuctConnection
extends GuiBaseAdv {
    static final String TEX_PATH = "thermaldynamics:textures/gui/Connection.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermaldynamics:textures/gui/Connection.png");
    public String myInfo = "";
    InventoryPlayer inventory;
    ConnectionBase conBase;
    ContainerDuctConnection container;
    public ElementButton[] flagButtons = new ElementButton[0];
    public ElementButton[] levelButtons = new ElementButton[FilterLogic.defaultLevels.length];
    boolean isItemServo;
    boolean isAdvItemFilter;
    public ElementButton decStackSize;
    public ElementButton incStackSize;
    public ElementButton decRetainSize;
    public ElementButton incRetainSize;
    int minStackSize;
    int maxStackSize;
    int minRetainSize;
    int maxRetainSize;
    public int buttonSize;
    private static final int[][] levelButtonPos = new int[][]{{-1, -1}, {0, 204}, {80, 204}};
    private static final int[][] flagButtonsPos = new int[][]{{176, 0}, {176, 60}, {216, 0}, {216, 60}, {176, 120}, {216, 120}, {176, 180}, {216, 180}};

    public GuiDuctConnection(InventoryPlayer inventoryPlayer, ConnectionBase connectionBase) {
        super((Container)new ContainerDuctConnection(inventoryPlayer, connectionBase), TEXTURE);
        this.conBase = connectionBase;
        this.inventory = inventoryPlayer;
        this.container = (ContainerDuctConnection)((GuiContainer)this).field_147002_h;
        ((GuiBase)this).name = connectionBase.getName();
        ((GuiContainer)this).field_147000_g = 204;
        this.isItemServo = connectionBase.getId() == 2 || connectionBase.getId() == 6;
        this.isAdvItemFilter = (connectionBase.getId() == 4 || connectionBase.getId() == 6) && connectionBase.filter.canAlterFlag(3);
        switch (connectionBase.getId()) {
            case 2: {
                this.generateInfo("tab.thermaldynamics.servoItem", 2);
                break;
            }
            case 4: {
                this.generateInfo("tab.thermaldynamics.filterItem", 1);
                break;
            }
            case 6: {
                this.generateInfo("tab.thermaldynamics.retrieverItem", 2);
                break;
            }
        }
    }

    protected void generateInfo(String string, int n) {
        this.myInfo = StringHelper.localize((String)(string + "." + 0));
        for (int i = 1; i < n; ++i) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)(string + "." + i));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (!this.myInfo.isEmpty()) {
            this.myInfo = this.myInfo + "\n\n" + StringHelper.localize((String)"tab.thermaldynamics.conChange");
            this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        }
        if (this.conBase.canAlterRS()) {
            this.addTab((TabBase)new TabRedstone((GuiBase)this, (IRedstoneControl)this.conBase));
        }
        int[] nArray = this.container.filter.validFlags();
        this.flagButtons = new ElementButton[this.container.filter.numFlags()];
        int[] nArray2 = this.container.filter.getValidLevels();
        this.levelButtons = new ElementButton[FilterLogic.defaultLevels.length];
        int n = nArray.length + nArray2.length;
        if (n != 0) {
            int n2;
            int n3;
            this.buttonSize = 20;
            int n4 = this.buttonSize + 6;
            int n5 = ((GuiContainer)this).field_146999_f / 2 - n * (n4 / 2) + 3;
            int n6 = this.container.gridY0 + this.container.gridHeight * 18 + 8;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                this.flagButtons[n2] = new ElementButton((GuiBase)this, n5 + n4 * n3, n6, this.container.filter.flagType(n2), flagButtonsPos[n2][0], flagButtonsPos[n2][1], flagButtonsPos[n2][0], flagButtonsPos[n2][1] + this.buttonSize, flagButtonsPos[n2][0], flagButtonsPos[n2][1] + this.buttonSize * 2, this.buttonSize, this.buttonSize, TEX_PATH);
                this.addElement((ElementBase)this.flagButtons[n2]);
            }
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                n2 = nArray2[n3];
                this.levelButtons[n2] = new ElementButton((GuiBase)this, n5 + n4 * (n3 + nArray.length), n6, FilterLogic.levelNames[n2], levelButtonPos[n2][0], levelButtonPos[n2][1], levelButtonPos[n2][0], levelButtonPos[n2][1] + this.buttonSize, this.buttonSize, this.buttonSize, TEX_PATH);
                this.addElement((ElementBase)this.levelButtons[n2]);
            }
        }
        this.decStackSize = new ElementButton((GuiBase)this, 137, 57, "DecStackSize", 216, 120, 216, 134, 216, 148, 14, 14, TEX_PATH).setToolTip("info.thermaldynamics.servo.decStackSize");
        this.incStackSize = new ElementButton((GuiBase)this, 153, 57, "IncStackSize", 230, 120, 230, 134, 230, 148, 14, 14, TEX_PATH).setToolTip("info.thermaldynamics.servo.incStackSize");
        this.decRetainSize = new ElementButton((GuiBase)this, 137, 28, "DecRetainSize", 216, 120, 216, 134, 216, 148, 14, 14, TEX_PATH).setToolTip("info.thermaldynamics.filter.decRetainSize");
        this.incRetainSize = new ElementButton((GuiBase)this, 153, 28, "IncRetainSize", 230, 120, 230, 134, 230, 148, 14, 14, TEX_PATH).setToolTip("info.thermaldynamics.filter.incRetainSize");
        if (this.isAdvItemFilter) {
            this.addElement((ElementBase)this.decRetainSize);
            this.addElement((ElementBase)this.incRetainSize);
            this.minRetainSize = FilterLogic.minLevels[this.conBase.filter.type][3];
            this.maxRetainSize = FilterLogic.maxLevels[this.conBase.filter.type][3];
        }
        if (this.isItemServo) {
            this.addElement((ElementBase)this.decStackSize);
            this.addElement((ElementBase)this.incStackSize);
            this.minStackSize = FilterLogic.minLevels[this.conBase.filter.type][0];
            this.maxStackSize = FilterLogic.maxLevels[this.conBase.filter.type][0];
        }
        this.setButtons();
    }

    private void setButtons() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.flagButtons.length; ++n3) {
            if (this.flagButtons[n3] == null) continue;
            n2 = this.container.filter.getFlag(n3);
            n = flagButtonsPos[n3][0] + (n2 != 0 ? this.buttonSize : 0);
            this.flagButtons[n3].setSheetX(n);
            this.flagButtons[n3].setHoverX(n);
            this.flagButtons[n3].setToolTip("info.thermaldynamics.filter." + this.flagButtons[n3].getName() + (n2 != 0 ? ".on" : ".off"));
        }
        for (n3 = 0; n3 < this.levelButtons.length; ++n3) {
            if (this.levelButtons[n3] == null) continue;
            n2 = this.container.filter.getLevel(n3);
            n = levelButtonPos[n3][0] + n2 * this.buttonSize;
            this.levelButtons[n3].setSheetX(n);
            this.levelButtons[n3].setHoverX(n);
            this.levelButtons[n3].setToolTip("info.thermaldynamics.filter." + this.levelButtons[n3].getName() + "." + n2);
        }
    }

    protected void updateElementInformation() {
        int n;
        super.updateElementInformation();
        if (this.isAdvItemFilter) {
            n = this.conBase.filter.getLevel(3);
            if (n > this.minRetainSize) {
                this.decRetainSize.setActive();
            } else {
                this.decRetainSize.setDisabled();
            }
            if (n < this.maxRetainSize) {
                this.incRetainSize.setActive();
            } else {
                this.incRetainSize.setDisabled();
            }
        }
        if (this.isItemServo) {
            n = this.conBase.filter.getLevel(0);
            if (n > this.minStackSize) {
                this.decStackSize.setActive();
            } else {
                this.decStackSize.setDisabled();
            }
            if (n < this.maxStackSize) {
                this.incStackSize.setActive();
            } else {
                this.incStackSize.setDisabled();
            }
        }
        this.setButtons();
    }

    public void handleElementButtonClick(String string, int n) {
        ElementButton elementButton;
        int n2;
        for (n2 = 0; n2 < this.flagButtons.length; ++n2) {
            elementButton = this.flagButtons[n2];
            if (elementButton == null || !elementButton.getName().equals(string)) continue;
            if (this.container.filter.setFlag(n2, !this.container.filter.getFlag(n2))) {
                if (this.container.filter.getFlag(n2)) {
                    GuiDuctConnection.playSound((String)"random.click", (float)1.0f, (float)0.8f);
                } else {
                    GuiDuctConnection.playSound((String)"random.click", (float)1.0f, (float)0.6f);
                }
            }
            this.setButtons();
            return;
        }
        for (n2 = 0; n2 < this.levelButtons.length; ++n2) {
            elementButton = this.levelButtons[n2];
            if (elementButton == null || !elementButton.getName().equals(string)) continue;
            if (n == 0) {
                this.container.filter.incLevel(n2);
                GuiDuctConnection.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            } else if (n == 1) {
                this.container.filter.decLevel(n2);
                GuiDuctConnection.playSound((String)"random.click", (float)1.0f, (float)0.6f);
            }
            this.setButtons();
            return;
        }
        n2 = 1;
        float f = 0.7f;
        if (GuiScreen.func_146272_n()) {
            n2 = 16;
            f = 0.9f;
            if (n == 1) {
                n2 = 4;
                f = 0.8f;
            }
        }
        if (string.equalsIgnoreCase("DecStackSize")) {
            this.container.filter.decLevel(0, n2, false);
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("IncStackSize")) {
            this.container.filter.incLevel(0, n2, false);
            f += 0.1f;
        }
        if (string.equalsIgnoreCase("DecRetainSize")) {
            this.container.filter.decLevel(3, n2, false);
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("IncRetainSize")) {
            this.container.filter.incLevel(3, n2, false);
            f += 0.1f;
        }
        GuiDuctConnection.playSound((String)"random.click", (float)1.0f, (float)f);
    }

    protected void func_146979_b(int n, int n2) {
        int n3;
        int n4;
        if (this.isAdvItemFilter) {
            n4 = 146;
            n3 = this.conBase.filter.getLevel(3);
            if (n3 == 0) {
                ((GuiScreen)this).field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermaldynamics.filter.zeroRetainSize"), n4 -= 9, 18, 0x404040);
            } else {
                if (n3 < 10) {
                    n4 += 6;
                } else if (n3 >= 100) {
                    n4 -= 3;
                }
                ((GuiScreen)this).field_146289_q.func_78276_b("" + n3, n4, 18, 0x404040);
            }
        }
        if (this.isItemServo) {
            n4 = 146;
            n3 = this.conBase.filter.getLevel(0);
            if (n3 < 10) {
                n4 += 6;
            }
            ((GuiScreen)this).field_146289_q.func_78276_b("" + n3, n4, 46, 0x404040);
        }
        super.func_146979_b(n, n2);
    }

    protected void func_146976_a(float f, int n, int n2) {
        super.func_146976_a(f, n, n2);
        this.drawSlots();
    }

    private void drawSlots() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(TEXTURE);
        int n = this.container.gridX0 - 1;
        int n2 = this.container.gridY0 - 1;
        int n3 = this.container.gridWidth * 18;
        int n4 = this.container.gridHeight * 18;
        int n5 = n + n3;
        int n6 = n2 + n4;
        for (int i = n; i < n5; i += 162) {
            for (int j = n2; j < n6; j += 54) {
                int n7 = Math.min(n5 - i, 162);
                int n8 = Math.min(n6 - j, 54);
                this.func_73729_b(((GuiContainer)this).field_147003_i + i, ((GuiContainer)this).field_147009_r + j, 7, 122, n7, n8);
            }
        }
    }
}

