/*
 * Decompiled with CFR 0.152.
 */
package com.gecgooden.chunkgen.util;

import com.gecgooden.chunkgen.reference.Reference;
import com.gecgooden.chunkgen.util.ChunkPosition;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class Utilities {
    public static void generateChunks(int x, int z, int width, int height, int dimensionID) {
        ChunkProviderServer cps = MinecraftServer.func_71276_C().func_71218_a((int)dimensionID).field_73059_b;
        ArrayList chunks = new ArrayList(width * height);
        for (int i = x - width / 2; i < x + width / 2; ++i) {
            for (int j = z - height / 2; j < z + height / 2; ++j) {
                Utilities.generateChunk(i, j, dimensionID);
            }
        }
        for (Chunk c : chunks) {
            cps.func_73241_b(c.field_76635_g, c.field_76647_h);
        }
    }

    private static boolean chunksExist(int x, int z, int dimensionID) {
        WorldServer world = null;
        world = DimensionManager.getWorld((int)dimensionID);
        return RegionFileCache.func_76550_a((File)world.getChunkSaveLocation(), (int)x, (int)z).chunkExists(x & 0x1F, z & 0x1F);
    }

    public static void generateChunk(int x, int z, int dimensionID) {
        ChunkProviderServer cps = MinecraftServer.func_71276_C().func_71218_a((int)dimensionID).field_73059_b;
        if (!Utilities.chunksExist(x, z, dimensionID)) {
            cps.func_73158_c(x, z);
            cps.func_73158_c(x, z + 1);
            cps.func_73158_c(x + 1, z);
            cps.func_73158_c(x + 1, z + 1);
            Reference.logger.info("Loaded Chunk at " + x + " " + z + " " + dimensionID);
        }
    }

    public static void queueChunkGeneration(ICommandSender icommandsender, int x0, int z0, int height, int width, int dimensionID) {
        int x = 0;
        int z = 0;
        int dx = 0;
        int dy = -1;
        int t = Math.max(height, width);
        int maxI = t * t;
        if (Reference.toGenerate == null) {
            Reference.toGenerate = new LinkedList<ChunkPosition>();
        }
        for (int i = 0; i < maxI; ++i) {
            if (-width / 2 <= x && x <= width / 2 && -height / 2 <= z && z <= height / 2) {
                Reference.toGenerate.add(new ChunkPosition(x + x0, z + z0, dimensionID, icommandsender));
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                t = dx;
                dx = -dy;
                dy = t;
            }
            x += dx;
            z += dy;
        }
    }
}

