/*
 * Decompiled with CFR 0.152.
 */
package com.gecgooden.chunkgen.handlers;

import com.gecgooden.chunkgen.reference.Reference;
import com.gecgooden.chunkgen.util.ChunkPosition;
import com.gecgooden.chunkgen.util.Utilities;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class TickHandler {
    private double chunkQueue = 0.0;
    private int chunksGenerated = 0;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        World world = MinecraftServer.func_71276_C().func_130014_f_();
        if (Reference.pauseForPlayers && world.field_73010_i.size() > 0) {
            return;
        }
        if (Reference.toGenerate != null && !Reference.toGenerate.isEmpty()) {
            this.chunkQueue += Reference.numChunksPerTick;
            while (this.chunkQueue > 1.0) {
                ChatComponentTranslation chatTranslation;
                this.chunkQueue -= 1.0;
                ++this.chunksGenerated;
                ChunkPosition cp = Reference.toGenerate.poll();
                if (cp == null) continue;
                Utilities.generateChunk(cp.getX(), cp.getZ(), cp.getDimensionID());
                float completedPercentage = 1.0f - (float)Reference.toGenerate.size() / (float)Reference.startingSize;
                if (this.chunksGenerated % Reference.updateDelay == 0) {
                    Reference.logger.info("percentage: " + completedPercentage);
                    chatTranslation = new ChatComponentTranslation("", new Object[0]);
                    MinecraftServer.func_71276_C().func_145747_a((IChatComponent)chatTranslation);
                    cp.getICommandSender().func_145747_a((IChatComponent)new ChatComponentText("Chunkgen: " + (int)(completedPercentage * 100.0f) + "% completed"));
                }
                if (Reference.toGenerate.peek() != null) continue;
                chatTranslation = new ChatComponentTranslation("commands.successful", new Object[0]);
                MinecraftServer.func_71276_C().func_145747_a((IChatComponent)chatTranslation);
                cp.getICommandSender().func_145747_a((IChatComponent)new ChatComponentText(chatTranslation.func_150261_e()));
            }
        }
    }
}

