/*
 * Decompiled with CFR 0.152.
 */
package com.gecgooden.chunkgen.handlers;

import com.gecgooden.chunkgen.reference.Reference;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration configuration;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("chunkgen")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        Reference.x = configuration.get("general", "x", 0, "X starting value").getInt();
        Reference.z = configuration.get("general", "z", 0, "Z starting value").getInt();
        Reference.height = configuration.get("general", "height", 0, "Height starting value").getInt();
        Reference.width = configuration.get("general", "width", 0, "Width starting value").getInt();
        Reference.pauseForPlayers = configuration.get("general", "pauseForPlayers", true, "Pause chunk generation when players are logged on").getBoolean();
        Reference.numChunksPerTick = configuration.get("general", "numChunksPerTick", 1.0, "Number of chunks loaded per tick").getDouble();
        Reference.updateDelay = configuration.get("general", "updateDelay", 40, "Number of chunks inbetween percentage updates").getInt();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }
}

