/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

public class RollingAverage {
    private float[] samples;
    private int size;
    private int index = 0;
    private float total;

    public RollingAverage(int size) {
        this.samples = new float[size];
        this.size = size;
        for (int i = 0; i < size; ++i) {
            this.samples[i] = 0.0f;
        }
    }

    public void add(float sample) {
        this.total -= this.samples[this.index];
        this.samples[this.index] = sample;
        this.total += sample;
        ++this.index;
        if (this.index == this.size) {
            this.index = 0;
        }
    }

    public float getAverage() {
        return this.total / (float)this.size;
    }
}

