/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import java.util.ArrayList;
import minechem.item.ChemicalRoomStateEnum;
import minechem.item.element.ElementClassificationEnum;
import minechem.potion.PotionChemical;
import minechem.radiation.RadiationEnum;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.utils.MinechemUtil;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class InputHelper {
    public static ItemStack toStack(IItemStack iStack) {
        if (iStack == null) {
            return null;
        }
        Object internal = iStack.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            MineTweakerAPI.getLogger().logError("Not a valid item stack: " + iStack);
        }
        return (ItemStack)internal;
    }

    public static ItemStack[] toStacks(IItemStack[] iStack) {
        if (iStack == null) {
            return null;
        }
        ItemStack[] output = new ItemStack[iStack.length];
        for (int i = 0; i < iStack.length; ++i) {
            output[i] = InputHelper.toStack(iStack[i]);
        }
        return output;
    }

    public static FluidStack toFluid(ILiquidStack iStack) {
        if (iStack == null) {
            return null;
        }
        return FluidRegistry.getFluidStack((String)iStack.getName(), (int)iStack.getAmount());
    }

    public static FluidStack[] toFluids(ILiquidStack[] iStack) {
        FluidStack[] stack = new FluidStack[iStack.length];
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = InputHelper.toFluid(iStack[i]);
        }
        return stack;
    }

    public static ArrayList<ItemStack> getInputs(IIngredient input) {
        ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
        if (input instanceof IOreDictEntry) {
            for (ItemStack inStack : OreDictionary.getOres((String)((IOreDictEntry)input).getName())) {
                ItemStack result = inStack.func_77946_l();
                result.field_77994_a = input.getAmount();
                toAdd.add(result);
            }
        } else if (input instanceof IItemStack) {
            toAdd.add(InputHelper.toStack((IItemStack)input));
        }
        return toAdd;
    }

    public static ItemStack getItem(IIngredient input) {
        if (input == null) {
            return null;
        }
        if (input instanceof IOreDictEntry) {
            ItemStack result = ((ItemStack)OreDictionary.getOres((String)((IOreDictEntry)input).getName()).get(0)).func_77946_l();
            result.field_77994_a = input.getAmount();
            if (MinechemUtil.itemStackToChemical(result) != null) {
                return null;
            }
            return result;
        }
        if (input instanceof IngredientStack) {
            ItemStack result = InputHelper.toStack((IItemStack)input.getItems().get(0));
            result.field_77994_a = input.getAmount();
            if (MinechemUtil.itemStackToChemical(result) != null) {
                return null;
            }
            return result;
        }
        if (input instanceof IItemStack) {
            if (MinechemUtil.itemStackToChemical(InputHelper.toStack((IItemStack)input)) != null) {
                return null;
            }
            return InputHelper.toStack((IItemStack)input);
        }
        return null;
    }

    public static ItemStack getInput(IIngredient input) {
        if (input == null) {
            return null;
        }
        if (input instanceof IOreDictEntry) {
            ItemStack result = ((ItemStack)OreDictionary.getOres((String)((IOreDictEntry)input).getName()).get(0)).func_77946_l();
            result.field_77994_a = input.getAmount();
            return result;
        }
        if (input instanceof IngredientStack) {
            ItemStack result = InputHelper.toStack((IItemStack)input.getItems().get(0));
            result.field_77994_a = input.getAmount();
            return result;
        }
        if (input instanceof IItemStack) {
            return InputHelper.toStack((IItemStack)input);
        }
        return null;
    }

    public static DecomposerRecipe[] getDecompArray(ArrayList<DecomposerRecipe> arrayList) {
        DecomposerRecipe[] result = new DecomposerRecipe[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            result[i] = arrayList.get(i);
        }
        return result;
    }

    public static ItemStack[] getItemArray(ArrayList<ItemStack> arrayList) {
        ItemStack[] result = new ItemStack[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            result[i] = arrayList.get(i);
        }
        return result;
    }

    public static PotionChemical[] getArray(ArrayList<PotionChemical> arrayList) {
        PotionChemical[] result = new PotionChemical[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            result[i] = arrayList.get(i);
        }
        return result;
    }

    public static PotionChemical getChemical(IIngredient ingredient) {
        if (ingredient instanceof IngredientStack) {
            for (IIngredient in : ingredient.getItems()) {
                if (!(in instanceof IItemStack)) continue;
                ItemStack result = InputHelper.toStack((IItemStack)in);
                result.field_77994_a = Math.max(1, ingredient.getAmount());
                PotionChemical chemical = MinechemUtil.itemStackToChemical(result);
                if (chemical == null) continue;
                return chemical;
            }
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            ArrayList results = (ArrayList)OreDictionary.getOres((String)((IOreDictEntry)ingredient).getName()).clone();
            for (ItemStack res : results) {
                ItemStack result = res.func_77946_l();
                result.field_77994_a = ingredient.getAmount();
                PotionChemical chemical = MinechemUtil.itemStackToChemical(result);
                if (chemical == null) continue;
                return chemical;
            }
        } else if (ingredient instanceof IItemStack) {
            return MinechemUtil.itemStackToChemical(InputHelper.toStack((IItemStack)ingredient));
        }
        return null;
    }

    public static ArrayList<PotionChemical> getChemicals(IIngredient ... array) {
        ArrayList<PotionChemical> output = new ArrayList<PotionChemical>();
        for (IIngredient outputStack : array) {
            PotionChemical out = InputHelper.getChemical(outputStack);
            if (out == null) continue;
            output.add(out);
        }
        return output;
    }

    public static ChemicalRoomStateEnum getRoomState(String input) {
        for (ChemicalRoomStateEnum val : ChemicalRoomStateEnum.values()) {
            if (!val.stateName().equalsIgnoreCase(input)) continue;
            return val;
        }
        throw new IllegalArgumentException(input + " is not a valid Room State");
    }

    public static ElementClassificationEnum getClassification(String input) {
        for (ElementClassificationEnum val : ElementClassificationEnum.values()) {
            if (!val.className().equalsIgnoreCase(input)) continue;
            return val;
        }
        throw new IllegalArgumentException(input + " is not a valid element Classification");
    }

    public static RadiationEnum getRadiation(String input) {
        for (RadiationEnum val : RadiationEnum.values()) {
            if (!val.name().equalsIgnoreCase(input.replaceAll(" ", ""))) continue;
            return val;
        }
        throw new IllegalArgumentException(input + " is not a valid radioactivity Classification");
    }
}

