/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.synthesis;

import java.util.ArrayList;
import java.util.List;
import minechem.MinechemItemsRegistration;
import minechem.api.INoDecay;
import minechem.api.IRadiationShield;
import minechem.container.ContainerWithFakeSlots;
import minechem.item.chemistjournal.ChemistJournalSlot;
import minechem.slot.SlotChemical;
import minechem.slot.SlotFake;
import minechem.tileentity.synthesis.SynthesisSlotOutput;
import minechem.tileentity.synthesis.SynthesisTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SynthesisContainer
extends ContainerWithFakeSlots
implements IRadiationShield,
INoDecay {
    private SynthesisTileEntity synthesis;

    public SynthesisContainer(InventoryPlayer inventoryPlayer, SynthesisTileEntity synthesis) {
        this.synthesis = synthesis;
        this.func_75146_a(new SynthesisSlotOutput(synthesis, 0, 134, 18));
        this.bindRecipeMatrixSlots();
        this.bindStorageSlots();
        this.func_75146_a(new ChemistJournalSlot(synthesis, 28, 26, 36));
        this.bindPlayerInventory(inventoryPlayer);
    }

    private void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 123 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 181));
        }
    }

    private void bindRecipeMatrixSlots() {
        int slot = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.func_75146_a(new SlotFake(this.synthesis, 1 + slot, 62 + col * 18, 18 + row * 18));
                ++slot;
            }
        }
    }

    private void bindStorageSlots() {
        int slot = 0;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new SlotChemical(this.synthesis, 10 + slot, 8 + col * 18, 84 + row * 18));
                ++slot;
            }
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return this.synthesis.func_70300_a(var1);
    }

    public void craftMaxmimum() {
        int amount = 0;
        ItemStack outputItem = this.synthesis.getCurrentRecipe().getOutput();
        for (int slot = 29; slot < this.field_75151_b.size(); ++slot) {
            ItemStack stack = this.func_75139_a(slot).func_75211_c();
            if (stack == null) {
                amount += outputItem.func_77976_d();
                continue;
            }
            if (!stack.func_77969_a(outputItem)) continue;
            amount += outputItem.func_77976_d() - stack.field_77994_a;
        }
        List<ItemStack> outputs = this.synthesis.getOutput(amount);
        for (ItemStack output : outputs) {
            this.func_75135_a(output, this.synthesis.func_70302_i_(), this.field_75151_b.size(), true);
        }
    }

    @Override
    public List<ItemStack> getPlayerInventory() {
        ArrayList<ItemStack> playerInventory = new ArrayList<ItemStack>();
        for (int slot = 29; slot < this.field_75151_b.size(); ++slot) {
            ItemStack stack = this.func_75139_a(slot).func_75211_c();
            if (stack == null) continue;
            playerInventory.add(stack);
        }
        return playerInventory;
    }

    @Override
    public float getRadiationReductionFactor(int baseDamage, ItemStack itemstack, EntityPlayer player) {
        return 0.4f;
    }

    @Override
    public List<ItemStack> getStorageInventory() {
        ArrayList<ItemStack> storageInventory = new ArrayList<ItemStack>();
        for (int slot = 0; slot <= 28; ++slot) {
            ItemStack stack = this.func_75139_a(slot).func_75211_c();
            if (stack == null) continue;
            storageInventory.add(stack);
        }
        return storageInventory;
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slot) {
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        ItemStack stack = null;
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot != 28 && stack.func_77973_b() == MinechemItemsRegistration.journal && !this.func_75139_a(28).func_75216_d()) {
                ItemStack copystack = slotObject.func_75209_a(1);
                this.func_75139_a(28).func_75215_d(copystack);
                return null;
            }
            if (slot == 0) {
                this.craftMaxmimum();
                return null;
            }
            if (slot >= this.synthesis.func_70302_i_() && slot < this.field_75151_b.size() && (stackInSlot.func_77973_b() == MinechemItemsRegistration.element || stackInSlot.func_77973_b() == MinechemItemsRegistration.molecule) ? !this.func_75135_a(stackInSlot, 10, 10 + SynthesisTileEntity.kStorage.length, false) : (slot >= 10 && slot < 10 + SynthesisTileEntity.kStorage.length ? !this.func_75135_a(stackInSlot, this.synthesis.func_70302_i_(), this.field_75151_b.size(), true) : (slot == 28 ? !this.func_75135_a(stackInSlot, this.synthesis.func_70302_i_(), this.field_75151_b.size(), true) : (slot < 47 && stackInSlot.field_77994_a == stack.field_77994_a ? !this.func_75135_a(stackInSlot, 47, 56, false) : slot > 46 && stackInSlot.field_77994_a == stack.field_77994_a && !this.func_75135_a(stackInSlot, 20, 47, false))))) {
                return null;
            }
            if (stackInSlot.field_77994_a == 0) {
                slotObject.func_75215_d(null);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slotObject.func_82870_a(entityPlayer, stackInSlot);
        }
        return stack;
    }
}

