/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.multiblock.fission;

import minechem.Settings;
import minechem.gui.GuiTabStateControl;
import minechem.tileentity.multiblock.fission.FissionTileEntity;
import net.minecraft.client.gui.Gui;

public class FissionTabStateControl
extends GuiTabStateControl {
    private int lastKnownEnergyCost = 0;

    public FissionTabStateControl(Gui gui, FissionTileEntity fission) {
        super(gui);
        this.tileEntity = fission;
        this.state = GuiTabStateControl.TabState.norecipe;
    }

    @Override
    public void update() {
        super.update();
        if (this.tileEntity.inventory[0] == null) {
            this.state = GuiTabStateControl.TabState.norecipe;
        } else {
            this.lastKnownEnergyCost = (this.tileEntity.inventory[0].func_77960_j() + 1) * Settings.fissionMultiplier;
            this.state = ((FissionTileEntity)this.tileEntity).inputIsFissionable() ? (this.tileEntity.getEnergyNeeded() < this.tileEntity.getEnergyStored() ? GuiTabStateControl.TabState.powered : GuiTabStateControl.TabState.unpowered) : GuiTabStateControl.TabState.norecipe;
        }
        this.overlayColor = this.state.color;
    }

    @Override
    public String getTooltip() {
        if (!this.isFullyOpened()) {
            if (this.state == GuiTabStateControl.TabState.unpowered && this.lastKnownEnergyCost > 0) {
                return "Energy Needed: " + this.lastKnownEnergyCost;
            }
            return this.state.tooltip;
        }
        return null;
    }
}

