/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.microscope;

import java.util.ArrayList;
import minechem.gui.GuiContainerTabbed;
import minechem.gui.GuiTabHelp;
import minechem.gui.GuiTabPatreon;
import minechem.reference.Resources;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeChance;
import minechem.tileentity.decomposer.DecomposerRecipeHandler;
import minechem.tileentity.decomposer.DecomposerRecipeSelect;
import minechem.tileentity.microscope.MicroscopeContainer;
import minechem.tileentity.microscope.MicroscopeGuiSwitch;
import minechem.tileentity.microscope.MicroscopeRenderGUIItem;
import minechem.tileentity.microscope.MicroscopeTileEntity;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.tileentity.synthesis.SynthesisRecipeHandler;
import minechem.utils.MinechemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class MicroscopeGui
extends GuiContainerTabbed {
    int guiWidth = 176;
    int guiHeight = 217;
    int eyepieceX = 25;
    int eyepieceY = 26;
    int inputSlotX = 44;
    int inputSlotY = 45;
    int slideShowTimer = 0;
    int currentSlide = 0;
    public InventoryPlayer inventoryPlayer;
    protected MicroscopeTileEntity microscope;
    MicroscopeGuiSwitch recipeSwitch;
    private boolean isShapedRecipe;
    private final RenderItem renderItem;

    public MicroscopeGui(InventoryPlayer inventoryPlayer, MicroscopeTileEntity microscope) {
        super(new MicroscopeContainer(inventoryPlayer, microscope));
        this.inventoryPlayer = inventoryPlayer;
        this.microscope = microscope;
        this.field_146999_f = this.guiWidth;
        this.field_147000_g = this.guiHeight;
        this.renderItem = new MicroscopeRenderGUIItem(this);
        this.recipeSwitch = new MicroscopeGuiSwitch(this);
        this.addTab(new GuiTabHelp(this, MinechemUtil.getLocalString("help.microscope")));
        this.addTab(new GuiTabPatreon(this));
    }

    public boolean isMouseInMicroscope() {
        this.mouseX = this.getMouseX();
        this.mouseY = this.getMouseY();
        int x = (this.field_146294_l - this.guiWidth) / 2;
        int y = (this.field_146295_m - this.guiHeight) / 2;
        int h = 54;
        int w = 54;
        return this.mouseX >= (x += this.eyepieceX) && this.mouseX <= x + w && this.mouseY >= (y += this.eyepieceY) && this.mouseY <= y + h;
    }

    private void drawMicroscopeOverlay() {
        this.field_73735_i = 600.0f;
        this.func_73729_b(this.eyepieceX, this.eyepieceY, 176, 0, 54, 54);
    }

    private void drawUnshapedOverlay() {
        this.field_73735_i = 0.0f;
        this.func_73729_b(97, 26, 176, 70, 54, 54);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        String info = MinechemUtil.getLocalString("gui.title.microscope");
        int infoWidth = this.field_146289_q.func_78256_a(info);
        this.field_146289_q.func_78276_b(info, (this.guiWidth - infoWidth) / 2, 5, 0);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Resources.Gui.MICROSCOPE);
        int x = (this.field_146294_l - this.guiWidth) / 2;
        int y = (this.field_146295_m - this.guiHeight) / 2;
        this.field_73735_i = 0.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        this.func_73729_b(0, 0, 0, 0, this.guiWidth, this.guiHeight);
        this.drawMicroscopeOverlay();
        if (!this.isShapedRecipe) {
            this.drawUnshapedOverlay();
        }
        GL11.glPopMatrix();
        this.recipeSwitch.setPos(x + 153, y + 26);
        this.recipeSwitch.draw(this.field_146297_k.field_71446_o);
        ItemStack itemstack = this.microscope.func_70301_a(0);
        this.clearRecipeMatrix();
        if (itemstack != null) {
            if (this.recipeSwitch.getState() == 0) {
                this.drawSynthesisRecipe(itemstack, x, y);
            } else {
                this.isShapedRecipe = false;
                this.drawDecomposerRecipe(itemstack, x, y);
            }
        }
    }

    private void clearRecipeMatrix() {
        for (int slot = 2; slot < 11; ++slot) {
            this.field_147002_h.func_75141_a(slot, null);
        }
    }

    private void drawSynthesisRecipe(ItemStack inputstack, int x, int y) {
        SynthesisRecipe recipe = SynthesisRecipeHandler.instance.getRecipeFromOutput(inputstack);
        if (recipe != null) {
            this.drawSynthesisRecipeMatrix(recipe, x, y);
            this.drawSynthesisRecipeCost(recipe, x, y);
        }
    }

    private void drawSynthesisRecipeMatrix(SynthesisRecipe recipe, int x, int y) {
        this.isShapedRecipe = recipe.isShaped();
        ItemStack[] shapedRecipe = MinechemUtil.convertChemicalArrayIntoItemStackArray(this.isShapedRecipe ? recipe.getShapedRecipe() : recipe.getShapelessRecipe());
        int slot = 2;
        for (ItemStack itemstack : shapedRecipe) {
            this.field_147002_h.func_75141_a(slot, itemstack);
            if (++slot >= 11) break;
        }
    }

    private void drawSynthesisRecipeCost(SynthesisRecipe recipe, int x, int y) {
        if (!this.recipeSwitch.isMoverOver()) {
            String cost = String.format("%d Energy", recipe.energyCost());
            this.field_146289_q.func_78276_b(cost, x + 100, y + 85, 0);
        }
    }

    private void drawDecomposerRecipe(ItemStack inputstack, int x, int y) {
        DecomposerRecipe recipe = DecomposerRecipeHandler.instance.getRecipe(inputstack);
        if (recipe != null) {
            ArrayList<ItemStack> output = MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutputRaw());
            if (recipe instanceof DecomposerRecipeSelect) {
                this.drawDecomposerRecipeSelectMatrix(((DecomposerRecipeSelect)recipe).getAllPossibleRecipes(), x, y);
            } else {
                this.drawDecomposerRecipeMatrix(output, x, y);
            }
            this.drawDecomposerChance(recipe, x, y);
        }
    }

    private void drawDecomposerRecipeMatrix(ArrayList<ItemStack> output, int x, int y) {
        int slot = 2;
        for (ItemStack itemstack : output) {
            this.field_147002_h.func_75141_a(slot, itemstack);
            if (++slot < 11) continue;
            break;
        }
    }

    private void drawDecomposerRecipeSelectMatrix(ArrayList<DecomposerRecipe> recipes, int x, int y) {
        if (this.slideShowTimer == 160) {
            this.slideShowTimer = 0;
            ++this.currentSlide;
        }
        if (this.currentSlide == recipes.size()) {
            this.currentSlide = 0;
        }
        ++this.slideShowTimer;
        DecomposerRecipe recipe = recipes.get(this.currentSlide);
        ArrayList<ItemStack> output = MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutputRaw());
        this.drawDecomposerRecipeMatrix(output, x, y);
    }

    private void drawDecomposerChance(DecomposerRecipe recipe, int x, int y) {
        if (!this.recipeSwitch.isMoverOver() && recipe instanceof DecomposerRecipeChance) {
            DecomposerRecipeChance recipeChance = (DecomposerRecipeChance)recipe;
            int chance = (int)(recipeChance.getChance() * 100.0f);
            String info = String.format("%d%%", chance);
            this.field_146289_q.func_78276_b(info, x + 108, y + 85, 0);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        this.recipeSwitch.mouseClicked(x, y, mouseButton);
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        this.renderItem.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.microscope.func_70301_a(0), par1, par2);
        this.renderItem.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.inventoryPlayer.func_70445_o(), par1, par2);
    }
}

