/*
 * Decompiled with CFR 0.152.
 */
package minechem.tileentity.blueprintprojector;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import minechem.Minechem;
import minechem.block.BlockSimpleContainer;
import minechem.gui.CreativeTabMinechem;
import minechem.item.blueprint.ItemBlueprint;
import minechem.item.blueprint.MinechemBlueprint;
import minechem.proxy.CommonProxy;
import minechem.tileentity.blueprintprojector.BlueprintProjectorTileEntity;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlueprintProjectorBlock
extends BlockSimpleContainer {
    public BlueprintProjectorBlock() {
        super(Material.field_151573_f);
        this.func_149663_c("blueprintProjector");
        this.func_149647_a(CreativeTabMinechem.CREATIVE_TAB_ITEMS);
        this.func_149715_a(0.7f);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase el, ItemStack is) {
        super.func_149689_a(world, x, y, z, el, is);
        int facing = MathHelper.func_76128_c((double)((double)(el.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, facing, 2);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof BlueprintProjectorTileEntity) {
            entityPlayer.openGui((Object)Minechem.INSTANCE, 0, world, x, y, z);
            return true;
        }
        return false;
    }

    private ItemStack takeBlueprintFromProjector(BlueprintProjectorTileEntity projector) {
        MinechemBlueprint blueprint = projector.takeBlueprint();
        return ItemBlueprint.createItemStackFromBlueprint(blueprint);
    }

    public TileEntity func_149915_a(World world, int i) {
        return new BlueprintProjectorTileEntity();
    }

    @Override
    public void addStacksDroppedOnBlockBreak(TileEntity tileEntity, ArrayList<ItemStack> itemStacks) {
        BlueprintProjectorTileEntity projector;
        if (tileEntity instanceof BlueprintProjectorTileEntity && (projector = (BlueprintProjectorTileEntity)tileEntity).hasBlueprint()) {
            itemStacks.add(this.takeBlueprintFromProjector(projector));
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof BlueprintProjectorTileEntity) {
            BlueprintProjectorTileEntity projector = (BlueprintProjectorTileEntity)tileEntity;
            projector.destroyProjection();
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("minechem:blockBlueprintProjector");
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return CommonProxy.RENDER_ID;
    }

    public boolean func_149662_c() {
        return false;
    }
}

