/*
 * Decompiled with CFR 0.152.
 */
package minechem.render;

import minechem.item.element.ElementEnum;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public final class RenderingUtil {
    public static void drawTextureIn3D(IIcon texture) {
        Tessellator tesselator = Tessellator.field_78398_a;
        float scale = 0.7f;
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        ItemRenderer.func_78439_a((Tessellator)tesselator, (float)texture.func_94212_f(), (float)texture.func_94206_g(), (float)texture.func_94209_e(), (float)texture.func_94210_h(), (int)texture.func_94211_a(), (int)texture.func_94216_b(), (float)0.0625f);
        GL11.glPopMatrix();
    }

    public static void drawTexturedRectUV(IItemRenderer.ItemRenderType type, float x, float y, float z, float w, float h, IIcon icon) {
        Tessellator tesselator = Tessellator.field_78398_a;
        tesselator.func_78382_b();
        tesselator.func_78374_a((double)x, (double)(y + h), (double)z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tesselator.func_78374_a((double)(x + w), (double)(y + h), (double)z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tesselator.func_78374_a((double)(x + w), (double)y, (double)z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tesselator.func_78374_a((double)x, (double)y, (double)z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tesselator.func_78381_a();
    }

    public static void setColorForElement(ElementEnum element) {
        switch (element.classification()) {
            case actinide: {
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case alkaliMetal: {
                GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case alkalineEarthMetal: {
                GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case halogen: {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case inertGas: {
                GL11.glColor3f((float)0.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case lanthanide: {
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case nonmetal: {
                GL11.glColor3f((float)1.0f, (float)0.5f, (float)0.0f);
                break;
            }
            case otherMetal: {
                GL11.glColor3f((float)0.5f, (float)1.0f, (float)0.0f);
                break;
            }
            case semimetallic: {
                GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.5f);
                break;
            }
            case transitionMetal: {
                GL11.glColor3f((float)0.0f, (float)0.5f, (float)1.0f);
                break;
            }
        }
    }

    public static void drawTexturedRectUV(float x, float y, float z, int w, int h, IIcon icon) {
        Tessellator tesselator = Tessellator.field_78398_a;
        tesselator.func_78382_b();
        tesselator.func_78374_a((double)x, (double)(y + (float)h), (double)z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tesselator.func_78374_a((double)(x + (float)w), (double)(y + (float)h), (double)z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tesselator.func_78374_a((double)(x + (float)w), (double)y, (double)z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tesselator.func_78374_a((double)x, (double)y, (double)z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tesselator.func_78381_a();
    }
}

