/*
 * Decompiled with CFR 0.152.
 */
package minechem.proxy;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import minechem.MinechemBlocksGeneration;
import minechem.MinechemItemsRegistration;
import minechem.fluid.FluidTextureStitchHandler;
import minechem.fluid.MinechemFluid;
import minechem.fluid.MinechemFluidBlock;
import minechem.item.bucket.MinechemBucketItem;
import minechem.item.bucket.MinechemBucketRenderer;
import minechem.item.element.ElementItemRenderer;
import minechem.item.molecule.MoleculeItemRenderer;
import minechem.proxy.CommonProxy;
import minechem.render.FluidItemRenderingHandler;
import minechem.sound.MinechemSoundEvent;
import minechem.tileentity.blueprintprojector.BlueprintProjectorItemRenderer;
import minechem.tileentity.blueprintprojector.BlueprintProjectorTileEntity;
import minechem.tileentity.blueprintprojector.BlueprintProjectorTileEntityRenderer;
import minechem.tileentity.decomposer.DecomposerItemRenderer;
import minechem.tileentity.decomposer.DecomposerTileEntity;
import minechem.tileentity.decomposer.DecomposerTileEntityRenderer;
import minechem.tileentity.leadedchest.LeadedChestItemRenderer;
import minechem.tileentity.leadedchest.LeadedChestTileEntity;
import minechem.tileentity.leadedchest.LeadedChestTileEntityRenderer;
import minechem.tileentity.microscope.MicroscopeItemRenderer;
import minechem.tileentity.microscope.MicroscopeTileEntity;
import minechem.tileentity.microscope.MicroscopeTileEntityRenderer;
import minechem.tileentity.synthesis.SynthesisItemRenderer;
import minechem.tileentity.synthesis.SynthesisTileEntity;
import minechem.tileentity.synthesis.SynthesisTileEntityRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    public FluidItemRenderingHandler fluidItemRenderingHandler;
    public MinechemBucketRenderer bucketItemRenderer;

    @Override
    public void registerRenderers() {
        RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
        MinecraftForgeClient.registerItemRenderer((Item)MinechemItemsRegistration.element, (IItemRenderer)new ElementItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)MinechemItemsRegistration.molecule, (IItemRenderer)new MoleculeItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MinechemBlocksGeneration.microscope), (IItemRenderer)new MicroscopeItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MinechemBlocksGeneration.decomposer), (IItemRenderer)new DecomposerItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MinechemBlocksGeneration.synthesis), (IItemRenderer)new SynthesisItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MinechemBlocksGeneration.blueprintProjector), (IItemRenderer)new BlueprintProjectorItemRenderer());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)MinechemBlocksGeneration.leadChest), (IItemRenderer)new LeadedChestItemRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(MicroscopeTileEntity.class, (TileEntitySpecialRenderer)new MicroscopeTileEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(DecomposerTileEntity.class, (TileEntitySpecialRenderer)new DecomposerTileEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(SynthesisTileEntity.class, (TileEntitySpecialRenderer)new SynthesisTileEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(BlueprintProjectorTileEntity.class, (TileEntitySpecialRenderer)new BlueprintProjectorTileEntityRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(LeadedChestTileEntity.class, (TileEntitySpecialRenderer)new LeadedChestTileEntityRenderer());
    }

    @Override
    public void registerHooks() {
        MinecraftForge.EVENT_BUS.register((Object)new MinechemSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FluidTextureStitchHandler());
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public void registerTickHandlers() {
        super.registerTickHandlers();
    }

    @Override
    public EntityPlayer getPlayer(MessageContext context) {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void onAddFluid(MinechemFluid fluid, MinechemFluidBlock block) {
        super.onAddFluid(fluid, block);
        if (this.fluidItemRenderingHandler == null) {
            this.fluidItemRenderingHandler = new FluidItemRenderingHandler();
        }
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)this.fluidItemRenderingHandler);
    }

    @Override
    public void onAddBucket(MinechemBucketItem item) {
        super.onAddBucket(item);
        if (this.bucketItemRenderer == null) {
            this.bucketItemRenderer = new MinechemBucketRenderer();
        }
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)this.bucketItemRenderer);
    }
}

