/*
 * Decompiled with CFR 0.152.
 */
package minechem.oredictionary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import minechem.MinechemRecipes;
import minechem.oredictionary.OreDictionaryBaseOreEnum;
import minechem.oredictionary.OreDictionaryHandler;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.utils.LogHelper;

public class OreDictionaryDefaultHandler
implements OreDictionaryHandler {
    private String[] supportedOres;
    private Map<OreDictionaryBaseOreEnum, ArrayList<EnumOrePrefix>> seenOres = new HashMap<OreDictionaryBaseOreEnum, ArrayList<EnumOrePrefix>>();
    private Map<OreDictionaryBaseOreEnum, String> registeredIngots = new HashMap<OreDictionaryBaseOreEnum, String>();

    public OreDictionaryDefaultHandler() {
        ArrayList<String> ores = new ArrayList<String>();
        for (OreDictionaryBaseOreEnum ore : OreDictionaryBaseOreEnum.values()) {
            ores.add(ore.name());
        }
        this.supportedOres = ores.toArray(new String[ores.size()]);
    }

    public String[] parseOreName(String oreName) {
        for (EnumOrePrefix prefix : EnumOrePrefix.values()) {
            if (!oreName.startsWith(prefix.name())) continue;
            String remainder = oreName.substring(prefix.name().length()).toLowerCase();
            if (!Arrays.asList(this.supportedOres).contains(remainder)) continue;
            return new String[]{prefix.name(), remainder};
        }
        return null;
    }

    @Override
    public boolean canHandle(String oreName) {
        return this.parseOreName(oreName) != null;
    }

    @Override
    public void handle(String oreName) {
        LogHelper.debug(OreDictionaryDefaultHandler.class.getSimpleName() + " registered : " + oreName);
        String[] tokens = this.parseOreName(oreName);
        EnumOrePrefix prefix = EnumOrePrefix.valueOf(tokens[0]);
        OreDictionaryBaseOreEnum ore = OreDictionaryBaseOreEnum.valueOf(tokens[1]);
        switch (prefix) {
            case oreNether: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, this.scaleFloor(ore.getComposition(), 6.0));
                break;
            }
            case ore: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, this.scaleFloor(ore.getComposition(), 3.0));
                break;
            }
            case ingot: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, ore.getComposition());
                if (this.haveSeen(ore, EnumOrePrefix.dust) || this.haveSeen(ore, EnumOrePrefix.dustSmall)) break;
                SynthesisRecipe.createAndAddRecipeSafely(oreName, false, MinechemRecipes.COST_INGOT, ore.getComposition());
                this.registeredIngots.put(ore, oreName);
                break;
            }
            case nugget: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, this.scaleFloor(ore.getComposition(), 0.1111111111111111));
                break;
            }
            case dust: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, ore.getComposition());
                this.unregisterIngot(ore);
                SynthesisRecipe.createAndAddRecipeSafely(oreName, true, MinechemRecipes.COST_INGOT, this.startAtRow(2, ore.getComposition()));
                break;
            }
            case dustDirty: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, this.scaleFloor(ore.getComposition(), 0.75));
                break;
            }
            case plate: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, ore.getComposition());
                break;
            }
            case dustSmall: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, this.scaleFloor(ore.getComposition(), 0.25));
                this.unregisterIngot(ore);
                SynthesisRecipe.createAndAddRecipeSafely(oreName, false, MinechemRecipes.COST_INGOT / 4, this.scaleCeil(ore.getComposition(), 0.25));
                break;
            }
            case crystal: 
            case gem: {
                DecomposerRecipe.createAndAddRecipeSafely(oreName, ore.getComposition());
                SynthesisRecipe.createAndAddRecipeSafely(oreName, true, MinechemRecipes.COST_GEM, this.startAtRow(2, ore.getComposition()));
                break;
            }
            default: {
                LogHelper.debug(OreDictionaryDefaultHandler.class.getSimpleName() + " : Invalid ore dictionary type.");
            }
        }
        this.seen(ore, prefix);
    }

    private PotionChemical[] startAtRow(int row, PotionChemical[] composition) {
        PotionChemical[] array = new PotionChemical[9];
        int j = 0;
        for (int i = row * 3 - 1; i < array.length; ++i) {
            array[i] = composition[j];
            if (++j >= composition.length) break;
        }
        return array;
    }

    private void unregisterIngot(OreDictionaryBaseOreEnum ore) {
        if (this.registeredIngots.containsKey((Object)ore)) {
            SynthesisRecipe.remove(this.registeredIngots.get((Object)ore));
            this.registeredIngots.remove((Object)ore);
        }
    }

    private PotionChemical[] scaleCeil(PotionChemical[] composition, double factor) {
        ArrayList<PotionChemical> newComposition = new ArrayList<PotionChemical>();
        for (PotionChemical chem : composition) {
            PotionChemical newChem = chem.copy();
            newChem.amount = (int)Math.ceil((double)chem.amount * factor);
            newComposition.add(newChem);
        }
        return newComposition.toArray(new PotionChemical[newComposition.size()]);
    }

    private PotionChemical[] scaleFloor(PotionChemical[] composition, double factor) {
        ArrayList<PotionChemical> newComposition = new ArrayList<PotionChemical>();
        for (PotionChemical chem : composition) {
            PotionChemical newChem = chem.copy();
            newChem.amount = (int)Math.floor((double)chem.amount * factor);
            if (newChem.amount <= 0) continue;
            newComposition.add(newChem);
        }
        return newComposition.toArray(new PotionChemical[newComposition.size()]);
    }

    private boolean haveSeen(OreDictionaryBaseOreEnum ore, EnumOrePrefix prefix) {
        return this.seenOres.containsKey((Object)ore) && this.seenOres.get((Object)ore).contains((Object)prefix);
    }

    private void seen(OreDictionaryBaseOreEnum ore, EnumOrePrefix prefix) {
        if (!this.seenOres.containsKey((Object)ore)) {
            this.seenOres.put(ore, new ArrayList());
        }
        if (!this.seenOres.get((Object)ore).contains((Object)prefix)) {
            this.seenOres.get((Object)ore).add(prefix);
        }
    }

    private static enum EnumOrePrefix {
        block,
        oreNether,
        ore,
        ingot,
        nugget,
        dustDirty,
        dustSmall,
        dust,
        plate,
        gem,
        crystal;

    }
}

