/*
 * Decompiled with CFR 0.152.
 */
package minechem.minetweaker;

import java.util.ArrayList;
import minechem.potion.PotionChemical;
import minechem.tileentity.decomposer.DecomposerFluidRecipe;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerRecipeChance;
import minechem.tileentity.decomposer.DecomposerRecipeSelect;
import minechem.tileentity.decomposer.DecomposerRecipeSuper;
import minechem.utils.InputHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.minechem.Decomposer")
public class Decomposer {
    @ZenMethod
    public static void addRecipe(IIngredient input, @Optional double chance, IIngredient[] ... multiOutputs) {
        if (multiOutputs.length == 1) {
            IIngredient[] outputs = multiOutputs[0];
            ArrayList<PotionChemical> output = InputHelper.getChemicals(outputs);
            if (output.size() == outputs.length) {
                ArrayList<ItemStack> toAdd = InputHelper.getInputs(input);
                for (ItemStack addInput : toAdd) {
                    if (chance == 0.0 || chance >= 1.0) {
                        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(addInput, output));
                        continue;
                    }
                    if (!(chance < 1.0)) continue;
                    MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(addInput, (float)chance, InputHelper.getArray(output)));
                }
            } else {
                Decomposer.addSuperRecipe(input, outputs, output);
            }
        } else {
            Decomposer.addMultiRecipe(input, multiOutputs, chance);
        }
    }

    public static void addSuperRecipe(IIngredient input, IIngredient[] recipe, ArrayList<PotionChemical> chemicals) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (IIngredient ingredient : recipe) {
            ItemStack in = InputHelper.getItem(ingredient);
            if (in == null || DecomposerRecipe.get(in) == null) continue;
            output.add(in);
        }
        if (!output.isEmpty()) {
            ArrayList<ItemStack> toAdd = InputHelper.getInputs(input);
            for (ItemStack addInput : toAdd) {
                MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(addInput, InputHelper.getItemArray(output), chemicals));
            }
        }
    }

    @ZenMethod
    public static void addFluid(ILiquidStack input, IIngredient ... outputs) {
        FluidStack addInput;
        ArrayList<PotionChemical> output = InputHelper.getChemicals(outputs);
        if (!output.isEmpty() && (addInput = InputHelper.toFluid(input)) != null) {
            MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(addInput, InputHelper.getArray(output)));
        }
    }

    public static void addMultiRecipe(IIngredient input, IIngredient[][] multioutputs, @Optional double chance) {
        if (chance <= 0.0 || chance > 1.0) {
            chance = 1.0;
        }
        ArrayList<DecomposerRecipe> decompRecipes = new ArrayList<DecomposerRecipe>();
        for (IIngredient[] recipe : multioutputs) {
            ArrayList<PotionChemical> output = InputHelper.getChemicals(recipe);
            if (output.isEmpty()) continue;
            decompRecipes.add(new DecomposerRecipe(InputHelper.getArray(output)));
        }
        if (!decompRecipes.isEmpty()) {
            ArrayList<ItemStack> toAdd = InputHelper.getInputs(input);
            for (ItemStack addInput : toAdd) {
                MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(addInput, (float)chance, InputHelper.getDecompArray(decompRecipes)));
            }
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        ArrayList<ItemStack> toRemove = InputHelper.getInputs(input);
        for (ItemStack recipe : toRemove) {
            if (DecomposerRecipe.get(recipe) == null) continue;
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(recipe));
        }
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input) {
        FluidStack recipe = InputHelper.toFluid(input);
        if (DecomposerRecipe.get(recipe) != null) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(recipe));
        }
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final DecomposerRecipe recipe;

        public RemoveRecipeAction(ItemStack input) {
            this.recipe = DecomposerRecipe.get(input);
        }

        public RemoveRecipeAction(FluidStack input) {
            this.recipe = DecomposerRecipe.get(input);
        }

        public void apply() {
            DecomposerRecipe.remove(this.recipe.getKey());
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            DecomposerRecipe.add(this.recipe);
        }

        public String describe() {
            return "Removing decomposer recipe for " + this.recipe.getInput().func_82833_r();
        }

        public String describeUndo() {
            return "Restoring decomposer recipe for " + this.recipe.getInput().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final DecomposerRecipe recipe;

        public AddRecipeAction(ItemStack input, ArrayList<PotionChemical> output) {
            this.recipe = new DecomposerRecipe(input, output);
        }

        public AddRecipeAction(FluidStack input, PotionChemical ... output) {
            this.recipe = new DecomposerFluidRecipe(input, output);
        }

        public AddRecipeAction(ItemStack input, float chance, PotionChemical ... output) {
            this.recipe = new DecomposerRecipeChance(input, chance, output);
        }

        public AddRecipeAction(ItemStack input, float chance, DecomposerRecipe ... recipes) {
            this.recipe = new DecomposerRecipeSelect(input, chance, recipes);
        }

        public AddRecipeAction(ItemStack addInput, ItemStack[] itemArray, ArrayList<PotionChemical> chemicals) {
            this.recipe = new DecomposerRecipeSuper(addInput, itemArray, chemicals);
        }

        public void apply() {
            DecomposerRecipe.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            DecomposerRecipe.remove(this.recipe.getKey());
        }

        public String describe() {
            return "Adding decomposer recipe for " + this.recipe.getInput().func_82833_r();
        }

        public String describeUndo() {
            return "Removing decomposer recipe for " + this.recipe.getInput().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

