/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.element;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minechem.MinechemItemsRegistration;
import minechem.fluid.FluidElement;
import minechem.fluid.FluidHelper;
import minechem.gui.CreativeTabMinechem;
import minechem.item.ChemicalRoomStateEnum;
import minechem.item.IDescriptiveName;
import minechem.item.MinechemChemicalType;
import minechem.item.element.ElementClassificationEnum;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.MoleculeEnum;
import minechem.item.polytool.PolytoolHelper;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationFluidTileEntity;
import minechem.radiation.RadiationInfo;
import minechem.utils.EnumColour;
import minechem.utils.MinechemUtil;
import minechem.utils.TimeHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.input.Keyboard;

public class ElementItem
extends Item {
    private final Map<IDescriptiveName, Integer> classificationIndexes = new HashMap<IDescriptiveName, Integer>();
    public final IIcon[] liquid = new IIcon[7];
    public final IIcon[] gas = new IIcon[7];
    public IIcon solid;

    public ElementItem() {
        this.func_77637_a(CreativeTabMinechem.CREATIVE_TAB_ELEMENTS);
        this.func_77655_b("itemElement");
        this.func_77627_a(true);
        this.classificationIndexes.put(ElementClassificationEnum.nonmetal, 0);
        this.classificationIndexes.put(ElementClassificationEnum.halogen, 1);
        this.classificationIndexes.put(ElementClassificationEnum.inertGas, 2);
        this.classificationIndexes.put(ElementClassificationEnum.semimetallic, 3);
        this.classificationIndexes.put(ElementClassificationEnum.otherMetal, 4);
        this.classificationIndexes.put(ElementClassificationEnum.alkaliMetal, 5);
        this.classificationIndexes.put(ElementClassificationEnum.alkalineEarthMetal, 6);
        this.classificationIndexes.put(ElementClassificationEnum.transitionMetal, 7);
        this.classificationIndexes.put(ElementClassificationEnum.lanthanide, 8);
        this.classificationIndexes.put(ElementClassificationEnum.actinide, 9);
        this.classificationIndexes.put(ChemicalRoomStateEnum.gas, 1);
        this.classificationIndexes.put(ChemicalRoomStateEnum.solid, 17);
        this.classificationIndexes.put(ChemicalRoomStateEnum.liquid, 33);
    }

    public static String getShortName(ItemStack itemstack) {
        int atomicNumber = itemstack.func_77960_j();
        return atomicNumber == 0 ? MinechemUtil.getLocalString("element.empty") : ElementEnum.getByID(atomicNumber).name();
    }

    public static String getLongName(ItemStack itemstack) {
        ElementEnum element;
        String longName;
        int atomicNumber = itemstack.func_77960_j();
        String string = longName = atomicNumber == 0 ? MinechemUtil.getLocalString("element.empty") : MinechemUtil.getLocalString(ElementEnum.getByID(atomicNumber).getUnlocalizedName(), true);
        if (longName.contains("Element.") && (element = ElementEnum.getByID(atomicNumber)) != null) {
            longName = element.getLongName();
        }
        return longName;
    }

    public static String getClassification(ItemStack itemstack) {
        int atomicNumber = itemstack.func_77960_j();
        return atomicNumber != 0 ? ElementEnum.getByID(atomicNumber).classification().descriptiveName() : MinechemUtil.getLocalString("element.empty");
    }

    public static String getRoomState(ItemStack itemstack) {
        int atomicNumber = itemstack.func_77960_j();
        return atomicNumber != 0 ? ElementEnum.getByID(atomicNumber).roomState().descriptiveName() : MinechemUtil.getLocalString("element.empty");
    }

    public static ElementEnum getElement(ItemStack itemstack) {
        return itemstack.func_77960_j() != 0 ? ElementEnum.getByID(itemstack.func_77960_j()) : null;
    }

    public static void attackEntityWithRadiationDamage(ItemStack itemstack, int damage, Entity entity) {
        entity.func_70097_a(DamageSource.field_76377_j, (float)damage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("minechem:filledTestTube");
        this.gas[0] = ir.func_94245_a("minechem:gas1");
        this.gas[1] = ir.func_94245_a("minechem:gas2");
        this.gas[2] = ir.func_94245_a("minechem:gas3");
        this.gas[3] = ir.func_94245_a("minechem:gas4");
        this.gas[4] = ir.func_94245_a("minechem:gas5");
        this.gas[5] = ir.func_94245_a("minechem:gas6");
        this.gas[6] = ir.func_94245_a("minechem:gas7");
        this.liquid[0] = ir.func_94245_a("minechem:liquid1");
        this.liquid[1] = ir.func_94245_a("minechem:liquid2");
        this.liquid[2] = ir.func_94245_a("minechem:liquid3");
        this.liquid[3] = ir.func_94245_a("minechem:liquid4");
        this.liquid[4] = ir.func_94245_a("minechem:liquid5");
        this.liquid[5] = ir.func_94245_a("minechem:liquid6");
        this.liquid[6] = ir.func_94245_a("minechem:liquid7");
        this.solid = ir.func_94245_a("minechem:solid");
    }

    public String func_77667_c(ItemStack itemStack) {
        return "minechem.itemElement." + ElementItem.getShortName(itemStack);
    }

    public String func_77653_i(ItemStack itemStack) {
        return ElementItem.getLongName(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        if (itemstack.func_77960_j() == 0) {
            return;
        }
        list.add("\u00a79" + ElementItem.getShortName(itemstack) + " (" + itemstack.func_77960_j() + ")");
        RadiationEnum radioactivity = RadiationInfo.getRadioactivity(itemstack);
        String radioactivityColor = radioactivity.getColour();
        String radioactiveName = MinechemUtil.getLocalString("element.property." + radioactivity.name(), true);
        String timeLeft = "";
        if (RadiationInfo.getRadioactivity(itemstack) != RadiationEnum.stable && itemstack.func_77978_p() != null) {
            long worldTime = player.field_70170_p.func_82737_E();
            timeLeft = TimeHelper.getTimeFromTicks(RadiationInfo.getRadioactivity(itemstack).getLife() - (worldTime - itemstack.func_77978_p().func_74763_f("decayStart")));
        }
        list.add(radioactivityColor + radioactiveName + (timeLeft.equals("") ? "" : " (" + timeLeft + ")"));
        list.add(ElementItem.getClassification(itemstack));
        list.add(ElementItem.getRoomState(itemstack));
        if (PolytoolHelper.getTypeFromElement(ElementItem.getElement(itemstack), 1.0f) != null) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                String polytoolDesc = PolytoolHelper.getTypeFromElement(ElementItem.getElement(itemstack), 1.0f).getDescription();
                String localizedDesc = StatCollector.func_74838_a((String)("polytool.description." + ElementItem.getShortName(itemstack)));
                if (!StatCollector.func_94522_b((String)("polytool.description." + ElementItem.getShortName(itemstack)))) {
                    localizedDesc = polytoolDesc;
                }
                list.add((Object)((Object)EnumColour.AQUA) + localizedDesc);
            } else {
                list.add((Object)((Object)EnumColour.DARK_GREEN) + MinechemUtil.getLocalString("polytool.information"));
            }
        }
    }

    public int func_77647_b(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        for (int i = 1; i <= ElementEnum.heaviestMass; ++i) {
            if (ElementEnum.getByID(i) == null) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    public static ItemStack createStackOf(ElementEnum element, int amount) {
        return new ItemStack((Item)MinechemItemsRegistration.element, amount, element.atomicNumber());
    }

    public static RadiationInfo getRadiationInfo(ItemStack element, World world) {
        RadiationEnum radioactivity = RadiationInfo.getRadioactivity(element);
        if (radioactivity == RadiationEnum.stable) {
            return new RadiationInfo(element, radioactivity);
        }
        NBTTagCompound stackTag = element.func_77978_p();
        if (stackTag == null) {
            return ElementItem.initiateRadioactivity(element, world);
        }
        int dimensionID = stackTag.func_74762_e("dimensionID");
        long lastUpdate = stackTag.func_74763_f("lastUpdate");
        long decayStart = stackTag.func_74763_f("decayStart");
        RadiationInfo info = new RadiationInfo(element, decayStart, lastUpdate, dimensionID, radioactivity);
        return info;
    }

    public static RadiationInfo initiateRadioactivity(ItemStack element, World world) {
        RadiationEnum radioactivity = RadiationInfo.getRadioactivity(element);
        int dimensionID = world.field_73011_w.field_76574_g;
        long lastUpdate = world.func_82737_E();
        RadiationInfo info = new RadiationInfo(element, lastUpdate, lastUpdate, dimensionID, radioactivity);
        RadiationInfo.setRadiationInfo(info, element);
        return info;
    }

    public static RadiationInfo decay(ItemStack element, World world) {
        int atomicMass = element.func_77960_j();
        element.func_77964_b(atomicMass - 1);
        return ElementItem.initiateRadioactivity(element, world);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        boolean result;
        TileEntity te = world.func_147438_o(x, y, z);
        boolean bl = result = !world.field_72995_K;
        if (te != null && te instanceof IFluidHandler && !player.func_70093_af() && !(te instanceof IInventory)) {
            if (stack.func_77960_j() != 0) {
                int filled = 0;
                for (int i = 0; i < 6; ++i) {
                    FluidElement fluid = FluidHelper.elements.get(ElementItem.getElement(stack));
                    if (fluid == null) {
                        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
                    }
                    filled = ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)i), new FluidStack((Fluid)fluid, 125), false);
                    if (filled <= 0) continue;
                    if (result) {
                        ((IFluidHandler)te).fill(ForgeDirection.getOrientation((int)i), new FluidStack((Fluid)FluidHelper.elements.get(ElementItem.getElement(stack)), 125), true);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        MinechemUtil.incPlayerInventory(stack, -1, player, new ItemStack((Item)MinechemItemsRegistration.element, 1, 0));
                    }
                    return result || stack.field_77994_a <= 0;
                }
            } else {
                FluidStack drained = null;
                Fluid fluid = MinechemUtil.getFluid((IFluidHandler)te);
                ElementEnum element = MinechemUtil.getElement(fluid);
                if (element != null) {
                    for (int i = 0; i < 6; ++i) {
                        drained = ((IFluidHandler)te).drain(ForgeDirection.getOrientation((int)i), new FluidStack(fluid, 125), false);
                        if (drained == null || drained.amount <= 0) continue;
                        if (result) {
                            ((IFluidHandler)te).drain(ForgeDirection.getOrientation((int)i), new FluidStack(fluid, 125), true);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            MinechemUtil.incPlayerInventory(stack, -1, player, new ItemStack((Item)MinechemItemsRegistration.element, 1, element.atomicNumber()));
                        }
                        return result;
                    }
                } else {
                    MoleculeEnum molecule = MinechemUtil.getMolecule(fluid);
                    if (fluid == FluidRegistry.WATER) {
                        molecule = MoleculeEnum.water;
                    }
                    if (molecule != null) {
                        for (int i = 0; i < 6; ++i) {
                            drained = ((IFluidHandler)te).drain(ForgeDirection.getOrientation((int)i), new FluidStack(fluid, 125), false);
                            if (drained == null || drained.amount <= 0) continue;
                            if (result) {
                                ((IFluidHandler)te).drain(ForgeDirection.getOrientation((int)i), new FluidStack(fluid, 125), true);
                            }
                            if (!player.field_71075_bZ.field_75098_d) {
                                MinechemUtil.incPlayerInventory(stack, -1, player, new ItemStack((Item)MinechemItemsRegistration.molecule, 1, molecule.id()));
                            }
                            return result;
                        }
                    }
                }
            }
            return result;
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        boolean flag = itemStack.func_77960_j() == 0;
        MovingObjectPosition movingObjectPosition = this.func_77621_a(world, player, flag);
        if (movingObjectPosition == null) {
            return itemStack;
        }
        if (movingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int blockX = movingObjectPosition.field_72311_b;
            int blockY = movingObjectPosition.field_72312_c;
            int blockZ = movingObjectPosition.field_72309_d;
            Block block = world.func_147439_a(blockX, blockY, blockZ);
            if (flag) {
                ItemStack stack;
                MinechemChemicalType chemical = MinechemUtil.getChemical(block);
                if (chemical != null && MinechemUtil.canDrain(world, block, blockX, blockY, blockZ) && (stack = MinechemUtil.createItemStack(chemical, 1)) != null) {
                    stack.field_77994_a = 8;
                    TileEntity tile = world.func_147438_o(blockX, blockY, blockZ);
                    if (tile instanceof RadiationFluidTileEntity && ((RadiationFluidTileEntity)tile).info != null) {
                        RadiationInfo.setRadiationInfo(((RadiationFluidTileEntity)tile).info, stack);
                    }
                    world.func_147468_f(blockX, blockY, blockZ);
                    world.func_147475_p(blockX, blockY, blockZ);
                    return this.fillTube(itemStack, player, stack);
                }
            } else {
                ForgeDirection dir = ForgeDirection.getOrientation((int)movingObjectPosition.field_72310_e);
                if (!player.func_82247_a(blockX += dir.offsetX, blockY += dir.offsetY, blockZ += dir.offsetZ, movingObjectPosition.field_72310_e, itemStack)) {
                    return itemStack;
                }
                return this.emptyTube(itemStack, player, world, blockX, blockY, blockZ);
            }
        }
        return itemStack;
    }

    private ItemStack fillTube(ItemStack itemStack, EntityPlayer player, ItemStack block) {
        if (player.field_71075_bZ.field_75098_d) {
            return itemStack;
        }
        MinechemUtil.incPlayerInventory(itemStack, -8, player, block);
        return itemStack;
    }

    private ItemStack emptyTube(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z) {
        if (!world.func_147437_c(x, y, z) && !world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
            Block sourceBlock = world.func_147439_a(x, y, z);
            int metadata = world.func_72805_g(x, y, z);
            sourceBlock.func_149636_a(world, player, x, y, z, metadata);
            sourceBlock.func_149749_a(world, x, y, z, sourceBlock, metadata);
            world.func_147468_f(x, y, z);
        }
        if (world.func_147437_c(x, y, z)) {
            RadiationInfo radioactivity = ElementItem.getRadiationInfo(itemStack, world);
            long worldtime = world.func_82737_E();
            long leftTime = radioactivity.radioactivity.getLife() - (worldtime - radioactivity.decayStarted);
            Fluid fluid = FluidHelper.elements.get(ElementItem.getElement(itemStack));
            if (fluid == null) {
                return itemStack;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (itemStack.field_77994_a >= 8) {
                    itemStack.field_77994_a -= 8;
                } else {
                    int needs = 8 - itemStack.field_77994_a;
                    Set<ItemStack> otherItemsStacks = MinechemUtil.findItemStacks((IInventory)player.field_71071_by, itemStack.func_77973_b(), itemStack.func_77960_j());
                    otherItemsStacks.remove(itemStack);
                    int free = 0;
                    for (ItemStack stack : otherItemsStacks) {
                        free += stack.field_77994_a;
                    }
                    if (free < needs) {
                        return itemStack;
                    }
                    itemStack.field_77994_a = 0;
                    for (ItemStack stack : otherItemsStacks) {
                        RadiationInfo anotherRadiation = ElementItem.getRadiationInfo(stack, world);
                        long anotherLeft = anotherRadiation.radioactivity.getLife() - (worldtime - anotherRadiation.decayStarted);
                        if (anotherLeft < leftTime) {
                            radioactivity = anotherRadiation;
                            leftTime = anotherLeft;
                        }
                        if (stack.field_77994_a >= needs) {
                            stack.field_77994_a -= needs;
                            needs = 0;
                        } else {
                            needs -= stack.field_77994_a;
                            stack.field_77994_a = 0;
                        }
                        if (stack.field_77994_a <= 0) {
                            MinechemUtil.removeStackInInventory((IInventory)player.field_71071_by, stack);
                        }
                        if (needs != 0) continue;
                        break;
                    }
                }
                ItemStack empties = MinechemUtil.addItemToInventory((IInventory)player.field_71071_by, new ItemStack((Item)MinechemItemsRegistration.element, 8, 0));
                MinechemUtil.throwItemStack(world, empties, x, y, z);
            }
            Block block = (Block)FluidHelper.elementsBlocks.get(fluid);
            world.func_147465_d(x, y, z, block, 0, 3);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (radioactivity.isRadioactive() && tile instanceof RadiationFluidTileEntity) {
                ((RadiationFluidTileEntity)tile).info = radioactivity;
            }
        }
        return itemStack;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        super.func_77622_d(itemStack, world, player);
        if (RadiationInfo.getRadioactivity(itemStack) != RadiationEnum.stable && itemStack.field_77990_d == null) {
            RadiationInfo.setRadiationInfo(new RadiationInfo(itemStack, world.func_82737_E(), world.func_82737_E(), world.field_73011_w.field_76574_g, RadiationInfo.getRadioactivity(itemStack)), itemStack);
        }
    }
}

