/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.bucket;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import minechem.fluid.FluidElement;
import minechem.fluid.FluidMolecule;
import minechem.gui.CreativeTabMinechem;
import minechem.item.MinechemChemicalType;
import minechem.item.molecule.MoleculeEnum;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationFluidTileEntity;
import minechem.radiation.RadiationInfo;
import minechem.utils.MinechemUtil;
import minechem.utils.TimeHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class MinechemBucketItem
extends ItemBucket {
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;
    public final Fluid fluid;
    public final Block block;
    public final MinechemChemicalType chemical;

    public MinechemBucketItem(Block block, Fluid fluid, MinechemChemicalType chemical) {
        super(block);
        this.func_77637_a(CreativeTabMinechem.CREATIVE_TAB_BUCKETS);
        this.func_77642_a(Items.field_151133_ar);
        this.func_77655_b("minechemBucket");
        this.fluid = fluid;
        this.block = block;
        this.chemical = chemical;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        String radioactivityColor;
        list.add("\u00a79" + this.getFillLocalizedName());
        list.add("\u00a79" + MinechemUtil.subscriptNumbers(this.getFormula()));
        RadiationEnum radioactivity = RadiationInfo.getRadioactivity(itemstack);
        switch (radioactivity) {
            case stable: {
                radioactivityColor = "\u00a77";
                break;
            }
            case hardlyRadioactive: {
                radioactivityColor = "\u00a7a";
                break;
            }
            case slightlyRadioactive: {
                radioactivityColor = "\u00a72";
                break;
            }
            case radioactive: {
                radioactivityColor = "\u00a7e";
                break;
            }
            case highlyRadioactive: {
                radioactivityColor = "\u00a76";
                break;
            }
            case extremelyRadioactive: {
                radioactivityColor = "\u00a74";
                break;
            }
            default: {
                radioactivityColor = "";
            }
        }
        String radioactiveName = MinechemUtil.getLocalString("element.property." + radioactivity.name(), true);
        String timeLeft = "";
        if (RadiationInfo.getRadioactivity(itemstack) != RadiationEnum.stable && itemstack.func_77978_p() != null) {
            long worldTime = player.field_70170_p.func_82737_E();
            timeLeft = TimeHelper.getTimeFromTicks(RadiationInfo.getRadioactivity(itemstack).getLife() - (worldTime - itemstack.func_77978_p().func_74763_f("decayStart")));
        }
        list.add(radioactivityColor + radioactiveName + (timeLeft.equals("") ? "" : " (" + timeLeft + ")"));
    }

    private String getFillLocalizedName() {
        if (this.fluid instanceof FluidElement) {
            return MinechemUtil.getLocalString(((FluidElement)this.fluid).element.getUnlocalizedName(), true);
        }
        if (this.fluid instanceof FluidMolecule) {
            return MinechemUtil.getLocalString(((FluidMolecule)this.fluid).molecule.getUnlocalizedName(), true);
        }
        return this.fluid.getLocalizedName(null);
    }

    private String getFormula() {
        if (this.fluid instanceof FluidElement) {
            return ((FluidElement)this.fluid).element.name();
        }
        if (this.fluid instanceof FluidMolecule) {
            return ((FluidMolecule)this.fluid).molecule.getFormula();
        }
        if (this.fluid == FluidRegistry.WATER) {
            return MoleculeEnum.water.getFormula();
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icons = new IIcon[2];
        this.icons[0] = ir.func_94245_a("minechem:bucketEmpty");
        this.icons[1] = ir.func_94245_a("minechem:bucketContent");
    }

    public boolean placeLiquid(World world, ItemStack itemstack, int x, int y, int z) {
        boolean flag;
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !flag) {
            return false;
        }
        if (!world.field_72995_K && flag && !material.func_76224_d()) {
            world.func_147480_a(x, y, z, true);
        }
        world.func_147465_d(x, y, z, this.block, 0, 3);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (this.chemical.radioactivity() != RadiationEnum.stable && tile instanceof RadiationFluidTileEntity) {
            RadiationInfo radioactivity;
            int dimensionID = itemstack.field_77990_d.func_74762_e("dimensionID");
            long lastUpdate = itemstack.field_77990_d.func_74763_f("lastUpdate");
            long decayStart = itemstack.field_77990_d.func_74763_f("decayStart");
            ((RadiationFluidTileEntity)tile).info = radioactivity = new RadiationInfo(itemstack, decayStart, lastUpdate, dimensionID, this.chemical.radioactivity());
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, false);
        if (movingobjectposition == null) {
            return itemStack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return itemStack;
            }
            switch (movingobjectposition.field_72310_e) {
                case 0: {
                    --y;
                    break;
                }
                case 1: {
                    ++y;
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                }
            }
            if (!player.func_82247_a(x, y, z, movingobjectposition.field_72310_e, itemStack)) {
                return itemStack;
            }
            if (this.placeLiquid(world, itemStack, x, y, z) && !player.field_71075_bZ.field_75098_d) {
                return new ItemStack(Items.field_151133_ar);
            }
        }
        return itemStack;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        super.func_77622_d(itemStack, world, player);
        if (RadiationInfo.getRadioactivity(itemStack) != RadiationEnum.stable && itemStack.field_77990_d == null) {
            RadiationInfo.setRadiationInfo(new RadiationInfo(itemStack, world.func_82737_E(), world.func_82737_E(), world.field_73011_w.field_76574_g, RadiationInfo.getRadioactivity(itemStack)), itemStack);
        }
    }
}

