/*
 * Decompiled with CFR 0.152.
 */
package minechem.gui;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.List;
import minechem.gui.GuiContainerTabbed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiFakeSlot
extends Gui {
    private Minecraft mc;
    private GuiContainerTabbed parentContainer;
    private EntityPlayer player;
    private int parentWidth;
    private int parentHeight;
    private int xPos;
    private int yPos;
    private int xOffset = 0;
    private int yOffset = 0;
    private int width = 16;
    private int height = 16;
    private ItemStack itemstack;
    private static RenderItem renderItem = new RenderItem();

    public GuiFakeSlot(GuiContainerTabbed parentContainer, EntityPlayer player) {
        this.parentContainer = parentContainer;
        this.parentWidth = parentContainer.getXSize();
        this.parentHeight = parentContainer.getYSize();
        this.player = player;
        this.mc = FMLClientHandler.instance().getClient();
    }

    private int mouseX() {
        return this.parentContainer.mouseX;
    }

    private int mouseY() {
        return this.parentContainer.mouseY;
    }

    public void setItemStack(ItemStack itemstack) {
        this.itemstack = itemstack;
    }

    public ItemStack getItemStack() {
        return this.itemstack;
    }

    public void setXPos(int x) {
        this.xPos = x;
    }

    public void setYPos(int y) {
        this.yPos = y;
    }

    public void setXOffset(int x) {
        this.xOffset = x;
    }

    public void setYOffset(int y) {
        this.yOffset = y;
    }

    public int getXPos() {
        return this.xPos + this.xOffset;
    }

    public int getYPos() {
        return this.yPos + this.yOffset;
    }

    public boolean getMouseIsOver() {
        int mx = this.mouseX();
        int my = this.mouseY();
        int x = this.getXPos();
        int y = this.getYPos();
        return mx >= x && mx <= x + this.width && my >= y && my <= y + this.height;
    }

    public void draw() {
        this.field_73735_i = 0.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.getXPos(), (float)this.yPos, (float)0.0f);
        if (this.getMouseIsOver()) {
            this.drawBackgroundHighlight();
        }
        if (this.itemstack != null) {
            this.drawItemStack(this.itemstack);
        }
        GL11.glPopMatrix();
    }

    public void drawTooltip(int x, int y) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        if (this.itemstack != null && this.getMouseIsOver()) {
            this.drawItemStackTooltip(this.itemstack);
        }
        GL11.glPopMatrix();
    }

    private void drawItemStack(ItemStack itemstack) {
        GL11.glDisable((int)2896);
        RenderHelper.func_74520_c();
        this.field_73735_i = 100.0f;
        GuiFakeSlot.renderItem.field_77023_b = 100.0f;
        renderItem.func_82406_b(this.mc.field_71466_p, this.mc.field_71446_o, itemstack, 0, 0);
        renderItem.func_77021_b(this.mc.field_71466_p, this.mc.field_71446_o, itemstack, 0, 0);
        this.field_73735_i = 0.0f;
        GuiFakeSlot.renderItem.field_77023_b = 0.0f;
    }

    private void drawItemStackTooltip(ItemStack itemstack) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        List lines = itemstack.func_82840_a(this.player, this.mc.field_71474_y.field_82882_x);
        int x = 0;
        int y = 0;
        int lineSpacing = 10;
        int maxLineWidth = 0;
        for (String line : lines) {
            int lineWidth = this.mc.field_71466_p.func_78256_a(line);
            if (lineWidth <= maxLineWidth) continue;
            maxLineWidth = lineWidth;
        }
        int bkX = x - 3;
        int bkY = y - 3;
        int tooltipWidth = maxLineWidth + 4;
        int tooltipHeight = lines.size() * lineSpacing + 4;
        int backgroundColor = -1442840440;
        this.func_73733_a(bkX - 1, bkY - 1, bkX + tooltipWidth + 1, bkY + tooltipHeight + 1, backgroundColor, backgroundColor);
        backgroundColor = -872415232;
        this.func_73733_a(bkX, bkY, bkX + tooltipWidth, bkY + tooltipHeight, backgroundColor, backgroundColor);
        for (int i = 0; i < lines.size(); ++i) {
            int tx = x;
            int ty = y + i * 10;
            String tooltip = (String)lines.get(i);
            if (i == 0) {
                tooltip = itemstack.func_77953_t().field_77937_e + tooltip;
            }
            this.mc.field_71466_p.func_78261_a(tooltip, tx, ty, -1);
        }
    }

    private void drawBackgroundHighlight() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int color4 = 0x44000000;
        this.func_73733_a(0, 0, this.width, this.height, color4, color4);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }
}

