/*
 * Decompiled with CFR 0.152.
 */
package minechem.fluid;

import minechem.item.ChemicalRoomStateEnum;
import minechem.item.MinechemChemicalType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class MinechemFluid
extends Fluid {
    private int quanta;

    public MinechemFluid(String fluidName, ChemicalRoomStateEnum roomstatus) {
        super(fluidName);
        this.setGaseous(roomstatus.isGas());
        this.setViscosity(roomstatus.getViscosity());
        this.setDensity(roomstatus.isGas() ? -10 : (roomstatus == ChemicalRoomStateEnum.solid ? 0 : 10));
        this.setQuanta(roomstatus.getQuanta());
        FluidRegistry.registerFluid((Fluid)this);
    }

    public void setQuanta(int quanta) {
        this.quanta = quanta;
    }

    public int getQuanta() {
        return this.quanta;
    }

    public abstract ItemStack getOutputStack();

    public abstract MinechemChemicalType getChemical();

    public String getUnlocalizedName() {
        return super.getUnlocalizedName() + ".name";
    }
}

