/*
 * Decompiled with CFR 0.152.
 */
package minechem.computercraft;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import minechem.MinechemItemsRegistration;
import minechem.computercraft.lua.LuaMethod;
import minechem.item.element.Element;
import minechem.item.element.ElementItem;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.item.molecule.MoleculeItem;
import minechem.potion.PotionChemical;
import minechem.radiation.RadiationDecayEvent;
import minechem.radiation.RadiationEnum;
import minechem.radiation.RadiationHandler;
import minechem.radiation.RadiationInfo;
import minechem.tileentity.decomposer.DecomposerRecipe;
import minechem.tileentity.decomposer.DecomposerTileEntity;
import minechem.tileentity.microscope.MicroscopeTileEntity;
import minechem.tileentity.synthesis.SynthesisRecipe;
import minechem.tileentity.synthesis.SynthesisRecipeHandler;
import minechem.tileentity.synthesis.SynthesisTileEntity;
import minechem.utils.Compare;
import minechem.utils.MapKey;
import minechem.utils.MinechemUtil;
import minechem.utils.TimeHelper;
import minechem.utils.WorldTimer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.lua.ILuaContext", modid="ComputerCraft"), @Optional.Interface(iface="dan200.computercraft.api.lua.LuaException", modid="ComputerCraft"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IComputerAccess", modid="ComputerCraft"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft"), @Optional.Interface(iface="dan200.computercraft.api.turtle.ITurtleAccess", modid="ComputerCraft")})
public class ChemicalTurtlePeripheral
implements IPeripheral {
    private ITurtleAccess turtle = null;
    private IComputerAccess computer = null;
    private WorldTimer timer = new WorldTimer(20);
    private ArrayList<MapKey> known;
    private ArrayList<LuaMethod> methods = new ArrayList();

    public ChemicalTurtlePeripheral(ITurtleAccess turtle) {
        this.turtle = turtle;
        this.known = new ArrayList();
        if (this.methods.isEmpty()) {
            this.addLuaMethods();
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "chemical";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        String[] result = new String[this.methods.size()];
        int i = 0;
        for (LuaMethod method : this.methods) {
            result[i++] = method.getMethodName();
        }
        return result;
    }

    @Optional.Method(modid="ComputerCraft")
    protected void addLuaMethods() {
        this.methods.add(new LuaMethod("getMethods"){

            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    Object[] result = new String[ChemicalTurtlePeripheral.this.methods.size()];
                    int i = 0;
                    for (LuaMethod method : ChemicalTurtlePeripheral.this.methods) {
                        result[i++] = method.getMethodName() + method.getArgs();
                    }
                    return result;
                }
                throw new LuaException("getMethods does not take any arguments");
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Returns: List of Method Names and Arguments"};
            }
        });
        this.methods.add(new LuaMethod("getDetails"){

            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 1) {
                    String methodName = (String)args[0];
                    if (methodName != null) {
                        for (LuaMethod method : ChemicalTurtlePeripheral.this.methods) {
                            if (!method.getMethodName().equalsIgnoreCase(methodName)) continue;
                            return method.getDetails();
                        }
                    }
                    throw new LuaException("Invalid Method Name - do not include brackets");
                }
                throw new LuaException("getDetails takes a single argument");
            }

            @Override
            public String getArgs() {
                return "(Method Name)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Method Name - from getMethods()", "Returns: Details of arguments and results"};
            }
        });
        this.methods.add(new LuaMethod("getChemicalName"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    String result = this.getName(ChemicalTurtlePeripheral.this.turtle.getSelectedSlot());
                    if (result == null) return null;
                    return new Object[]{result};
                }
                if (args.length != 1) throw new LuaException("Maximum 1 argument for slot number.");
                Integer slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                if (!ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_())) throw new LuaException("Invalid Slot Number.");
                String result = this.getName(slot);
                if (result == null) return null;
                return new Object[]{result};
            }

            private String getName(int slot) {
                ItemStack current = ChemicalTurtlePeripheral.this.turtle.getInventory().func_70301_a(slot);
                if (Compare.isStackAnElement(current)) {
                    return current.func_82833_r();
                }
                if (Compare.isStackAMolecule(current)) {
                    return current.func_82833_r();
                }
                return null;
            }

            @Override
            public String getArgs() {
                return "(?Slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Slot Number, defaults to current slot", "Returns: Chemical name of stack in slot, or nil if not a chemical"};
            }
        });
        this.methods.add(new LuaMethod("getChemicalFormula"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    String result = this.getChemicalFormula(ChemicalTurtlePeripheral.this.turtle.getSelectedSlot());
                    if (result == null) return null;
                    return new Object[]{result};
                }
                if (args.length != 1) throw new LuaException("Maximum 1 argument for slot number.");
                Integer slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                if (!ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_())) throw new LuaException("Invalid Slot Number.");
                String result = this.getChemicalFormula(slot);
                if (result == null) return null;
                return new Object[]{result};
            }

            private String getChemicalFormula(int slot) {
                ItemStack current = ChemicalTurtlePeripheral.this.turtle.getInventory().func_70301_a(slot);
                if (Compare.isStackAnElement(current)) {
                    return ElementItem.getElement(current).name();
                }
                if (Compare.isStackAMolecule(current)) {
                    return MoleculeItem.getMolecule(current).getFormula();
                }
                return null;
            }

            @Override
            public String getArgs() {
                return "(?Slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Slot Number, defaults to current slot", "Returns: Chemical formula of stack in slot, or nil if not a chemical"};
            }
        });
        this.methods.add(new LuaMethod("getChemicalsAsTable"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    HashMap<Number, Object> result = this.getChemicalsAsTable(ChemicalTurtlePeripheral.this.turtle.getSelectedSlot());
                    if (result == null) return null;
                    return new Object[]{result};
                }
                if (args.length != 1) throw new LuaException("Maximum 1 argument for slot number.");
                Integer slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                if (!ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_())) throw new LuaException("Invalid Slot Number.");
                HashMap<Number, Object> result = this.getChemicalsAsTable(slot);
                if (result == null) return null;
                return new Object[]{result};
            }

            private HashMap<Number, Object> getChemicalsAsTable(int slot) {
                ItemStack current = ChemicalTurtlePeripheral.this.turtle.getInventory().func_70301_a(slot);
                HashMap<Number, Object> map = new HashMap<Number, Object>();
                if (Compare.isStackAnElement(current)) {
                    HashMap<String, Object> chemMap = new HashMap<String, Object>();
                    chemMap.put("chemical", current.func_82833_r());
                    chemMap.put("quantity", 1);
                    map.put(1, chemMap);
                    return map;
                }
                if (Compare.isStackAMolecule(current)) {
                    MoleculeEnum molecule = MoleculeItem.getMolecule(current);
                    ArrayList<PotionChemical> chemicals = molecule.components();
                    for (int i = 0; i < chemicals.size(); ++i) {
                        PotionChemical chemical = chemicals.get(i);
                        HashMap<String, Object> chemMap = new HashMap<String, Object>();
                        chemMap.put("chemical", MinechemUtil.getChemicalName(chemical));
                        chemMap.put("quantity", chemical.amount);
                        map.put(i + 1, chemMap);
                    }
                    return map;
                }
                return null;
            }

            @Override
            public String getArgs() {
                return "(?Slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Slot Number, defaults to current slot", "Returns: Chemical formula of stack in slot as a table, or nil if not a chemical"};
            }
        });
        this.methods.add(new LuaMethod("getAtomicMass"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    Integer result = this.getAtomicMass(ChemicalTurtlePeripheral.this.turtle.getSelectedSlot());
                    if (result == null) return null;
                    return new Object[]{result};
                }
                if (args.length != 1) throw new LuaException("Maximum 1 argument for slot number.");
                Integer slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                if (!ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_())) throw new LuaException("Invalid Slot Number.");
                Integer result = this.getAtomicMass(slot);
                if (result == null) return null;
                return new Object[]{result};
            }

            private Integer getAtomicMass(Integer slot) {
                ItemStack current = ChemicalTurtlePeripheral.this.turtle.getInventory().func_70301_a(slot.intValue());
                if (Compare.isStackAnElement(current)) {
                    return ElementItem.getElement(current).atomicNumber();
                }
                return null;
            }

            @Override
            public String getArgs() {
                return "(?Slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Slot Number, defaults to current slot", "Returns: Atomic Mass of elements"};
            }
        });
        this.methods.add(new LuaMethod("getRadioactivity"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    String result = this.getRadioactivity(ChemicalTurtlePeripheral.this.turtle.getSelectedSlot());
                    if (result == null) return null;
                    return new Object[]{result};
                }
                if (args.length != 1) throw new LuaException("Maximum 1 argument for slot number.");
                Integer slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                if (!ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_())) throw new LuaException("Invalid Slot Number.");
                String result = this.getRadioactivity(slot);
                if (result == null) return null;
                return new Object[]{result};
            }

            private String getRadioactivity(Integer slot) {
                ItemStack current = ChemicalTurtlePeripheral.this.turtle.getInventory().func_70301_a(slot.intValue());
                if (Compare.isStackAnElement(current)) {
                    return ElementItem.getElement(current).radioactivity().toString();
                }
                if (Compare.isStackAMolecule(current)) {
                    return MoleculeItem.getMolecule(current).radioactivity().toString();
                }
                return null;
            }

            @Override
            public String getArgs() {
                return "(?Slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Slot Number, defaults to current slot", "Returns: Radioactivity level of chemicals"};
            }
        });
        this.methods.add(new LuaMethod("getDecayTimeInTicks"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    Object result = ChemicalTurtlePeripheral.this.getDecayTime(ChemicalTurtlePeripheral.this.turtle.getSelectedSlot());
                    if (result == null) return null;
                    return new Object[]{result};
                }
                if (args.length != 1) throw new LuaException("Maximum 1 argument for slot number.");
                Integer slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                if (!ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_())) throw new LuaException("Invalid Slot Number.");
                Object result = ChemicalTurtlePeripheral.this.getDecayTime(slot);
                if (result == null) return null;
                return new Object[]{result};
            }

            @Override
            public String getArgs() {
                return "(?Slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Slot Number, defaults to current slot", "Returns: Time left to Radioactive Decay in Ticks - Infinite for stable chemicals, null for non-chemicals"};
            }
        });
        this.methods.add(new LuaMethod("getDecayTime"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    Object result = ChemicalTurtlePeripheral.this.getDecayTime(ChemicalTurtlePeripheral.this.turtle.getSelectedSlot());
                    if (result == null) return null;
                    if (result instanceof Long) {
                        return new Object[]{TimeHelper.getTimeFromTicks((Long)result)};
                    }
                    if (!(result instanceof String)) return null;
                    return new Object[]{result};
                }
                if (args.length != 1) throw new LuaException("Maximum 1 argument for slot number.");
                Integer slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                if (!ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_())) throw new LuaException("Invalid Slot Number.");
                Object result = ChemicalTurtlePeripheral.this.getDecayTime(slot);
                if (result == null) return null;
                if (result instanceof Long) {
                    return new Object[]{TimeHelper.getTimeFromTicks((Long)result)};
                }
                if (!(result instanceof String)) return null;
                return new Object[]{result};
            }

            @Override
            public String getArgs() {
                return "(?Slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Slot Number, defaults to current slot", "Returns: Time left to Radioactive Decay - Infinite for stable chemicals, null for non-chemicals"};
            }
        });
        this.methods.add(new LuaMethod("syncJournal"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    String result = this.sync(ChemicalTurtlePeripheral.this.turtle.getSelectedSlot(), computer);
                    if (result == null) return null;
                    return new Object[]{result};
                }
                if (args.length != 1) throw new LuaException("Maximum 1 argument for slot number.");
                Integer slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                if (!ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_())) throw new LuaException("Invalid Slot Number.");
                String result = this.sync(slot, computer);
                if (result == null) return null;
                return new Object[]{result};
            }

            private String sync(int slot, IComputerAccess computer) throws LuaException {
                ItemStack journal = ChemicalTurtlePeripheral.this.getJournal(slot);
                if (journal != null) {
                    return this.upload(journal) + " - " + this.download(journal, computer);
                }
                ItemStack book = this.getBook(slot);
                if (book != null) {
                    return this.download(book, slot, computer);
                }
                throw new LuaException("Invalid Stack - not a journal or a book");
            }

            private String upload(ItemStack journal) {
                ArrayList journalItems = ChemicalTurtlePeripheral.this.stackListToKeys(MinechemItemsRegistration.journal.getItemList(journal));
                if (journalItems == null) {
                    journalItems = new ArrayList();
                }
                ArrayList addItems = new ArrayList();
                addItems.addAll(journalItems);
                addItems.removeAll(ChemicalTurtlePeripheral.this.known);
                ChemicalTurtlePeripheral.this.known.addAll(addItems);
                int added = addItems.size();
                return "Loaded " + added + " recipe" + (added != 1 ? "s" : "");
            }

            private String download(ItemStack journal, IComputerAccess computer) {
                return this.download(journal, -1, computer);
            }

            private String download(ItemStack journal, int slot, IComputerAccess computer) {
                ArrayList journalItems;
                if (journal.func_77973_b() == Items.field_151122_aG) {
                    journal = new ItemStack((Item)MinechemItemsRegistration.journal);
                }
                if ((journalItems = ChemicalTurtlePeripheral.this.stackListToKeys(MinechemItemsRegistration.journal.getItemList(journal))) == null) {
                    journalItems = new ArrayList();
                }
                ArrayList addItems = new ArrayList();
                addItems.addAll(ChemicalTurtlePeripheral.this.known);
                addItems.removeAll(journalItems);
                for (ItemStack item : ChemicalTurtlePeripheral.this.keyListToStacks(addItems)) {
                    MinechemItemsRegistration.journal.addItemStackToJournal(item, journal, ChemicalTurtlePeripheral.this.turtle.getWorld());
                }
                int added = addItems.size();
                String owner = journal.field_77990_d.func_74779_i("owner");
                if (owner.equals("")) {
                    journal.field_77990_d.func_74778_a("owner", "Chemistry Turtle " + computer.getID());
                }
                if (slot >= 0) {
                    ChemicalTurtlePeripheral.this.turtle.getInventory().func_70299_a(slot, journal);
                }
                return "Saved " + added + " recipe" + (added != 1 ? "s" : "");
            }

            private ItemStack getBook(int slot) {
                ItemStack result = ChemicalTurtlePeripheral.this.turtle.getInventory().func_70301_a(slot);
                if (result.func_77973_b() == Items.field_151122_aG && result.field_77994_a == 1) {
                    return result;
                }
                return null;
            }

            @Override
            public String getArgs() {
                return "(?Slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Slot Number, defaults to current slot", "Returns: Number of Journal Entries loaded and saved"};
            }
        });
        this.methods.add(new LuaMethod("readRecipe"){

            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                ForgeDirection dir = null;
                if (args.length == 0) {
                    dir = this.getDirForString("front", ChemicalTurtlePeripheral.this.turtle);
                } else if (args.length == 1) {
                    dir = this.getDirForString((String)args[0], ChemicalTurtlePeripheral.this.turtle);
                }
                if (dir == null) {
                    throw new LuaException("Invalid Arguments");
                }
                TileEntity te = ChemicalTurtlePeripheral.this.turtle.getWorld().func_147438_o(((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71574_a + dir.offsetX, ((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71572_b + dir.offsetY, ((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71573_c + dir.offsetZ);
                if (te != null) {
                    ItemStack thisStack;
                    if (te instanceof SynthesisTileEntity) {
                        SynthesisRecipe thisRecipe = ((SynthesisTileEntity)te).getCurrentRecipe();
                        if (thisRecipe != null) {
                            if (ChemicalTurtlePeripheral.this.addStackToKnown(thisRecipe.getOutput())) {
                                return new Object[]{"Synthesis Recipe Scanned", ChemicalTurtlePeripheral.this.stackToMap(thisRecipe.getOutput())};
                            }
                            return new Object[]{"Item already known"};
                        }
                    } else if (te instanceof DecomposerTileEntity) {
                        DecomposerRecipe thisRecipe = DecomposerRecipe.get(((DecomposerTileEntity)te).inventory[((DecomposerTileEntity)te).kInputSlot]);
                        if (thisRecipe != null) {
                            if (ChemicalTurtlePeripheral.this.addStackToKnown(thisRecipe.getInput())) {
                                return new Object[]{"Decomposer Recipe Scanned", ChemicalTurtlePeripheral.this.stackToMap(thisRecipe.getInput())};
                            }
                            return new Object[]{"Item already known"};
                        }
                    } else if (te instanceof MicroscopeTileEntity && (thisStack = ((MicroscopeTileEntity)te).inventory[0]) != null) {
                        if (ChemicalTurtlePeripheral.this.addStackToKnown(thisStack)) {
                            return new Object[]{"Microscope scan complete", ChemicalTurtlePeripheral.this.stackToMap(thisStack)};
                        }
                        return new Object[]{"Item already known"};
                    }
                }
                return null;
            }

            @Override
            public String getArgs() {
                return "(?Direction)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Direction, defaults to front", "Returns: Confirmtion String, Recipe read"};
            }
        });
        this.methods.add(new LuaMethod("getSynthesisRecipe"){

            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 1 || args.length == 2) {
                    String UUID2 = (String)args[0];
                    Integer metadata = args.length == 2 ? ChemicalTurtlePeripheral.this.getInt(args[1]) : 0;
                    if (metadata == null || metadata < 0) {
                        metadata = 0;
                    }
                    for (ItemStack current : ChemicalTurtlePeripheral.this.keyListToStacks(ChemicalTurtlePeripheral.this.known)) {
                        if (!GameRegistry.findUniqueIdentifierFor((Item)current.func_77973_b()).toString().equals(UUID2) || current.func_77960_j() != metadata.intValue()) continue;
                        SynthesisRecipe output = SynthesisRecipeHandler.instance.getRecipeFromOutput(current);
                        if (output != null) {
                            return new Object[]{ChemicalTurtlePeripheral.this.synthesisRecipeToMap(output)};
                        }
                        return new Object[]{"No Synthesiser recipe exists for " + UUID2 + ":" + metadata};
                    }
                    return new Object[]{UUID2 + ":" + metadata + " is unknown."};
                }
                throw new LuaException("Invalid arguments");
            }

            @Override
            public String getArgs() {
                return "(name,?metadata)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Args: Item Name and optional metadata, default 0", "Returns: Synthesiser Recipes in table form"};
            }
        });
        this.methods.add(new LuaMethod("getSynthesisRecipes"){

            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                if (args.length == 0) {
                    int i = 1;
                    HashMap<Integer, HashMap> result = new HashMap<Integer, HashMap>();
                    for (ItemStack current : ChemicalTurtlePeripheral.this.keyListToStacks(ChemicalTurtlePeripheral.this.known)) {
                        SynthesisRecipe output = SynthesisRecipeHandler.instance.getRecipeFromOutput(current);
                        if (output == null) continue;
                        result.put(i++, ChemicalTurtlePeripheral.this.synthesisRecipeToMap(output));
                    }
                    return new Object[]{result};
                }
                throw new LuaException("getSynthesisRecipes does not take any arguments");
            }

            @Override
            public String getArgs() {
                return "()";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Returns: All Synthesiser Recipes in table form"};
            }
        });
        this.methods.add(new LuaMethod("setRecipe"){

            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                ForgeDirection dir = null;
                if (args.length > 0 && args.length < 4) {
                    String UUID2 = null;
                    dir = this.getDirForString((String)args[0], ChemicalTurtlePeripheral.this.turtle);
                    if (dir == null && args.length < 3) {
                        UUID2 = (String)args[0];
                        dir = this.getDirForString("front", ChemicalTurtlePeripheral.this.turtle);
                    } else if (dir == null) {
                        throw new LuaException("Invalid Arguments");
                    }
                    TileEntity te = ChemicalTurtlePeripheral.this.turtle.getWorld().func_147438_o(((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71574_a + dir.offsetX, ((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71572_b + dir.offsetY, ((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71573_c + dir.offsetZ);
                    if (te instanceof SynthesisTileEntity) {
                        Integer metadata = ChemicalTurtlePeripheral.this.getInt(args[args.length - 1]);
                        if (metadata == null || metadata < 0) {
                            metadata = 0;
                        }
                        if (UUID2 == null) {
                            UUID2 = (String)args[1];
                        }
                        for (ItemStack current : ChemicalTurtlePeripheral.this.keyListToStacks(ChemicalTurtlePeripheral.this.known)) {
                            if (!GameRegistry.findUniqueIdentifierFor((Item)current.func_77973_b()).toString().equals(UUID2) || current.func_77960_j() != metadata.intValue()) continue;
                            SynthesisRecipe output = SynthesisRecipeHandler.instance.getRecipeFromOutput(current);
                            if (output != null) {
                                ((SynthesisTileEntity)te).setRecipe(output);
                                return new Object[]{true};
                            }
                            return new Object[]{false};
                        }
                    }
                }
                return new Object[]{false};
            }

            @Override
            public String getArgs() {
                return "(?Direction,name,?metadata)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Direction, defaults to front", "Arg: Item name", "Arg: Optional metadata, defaults to 0", "Returns: boolean success"};
            }
        });
        this.methods.add(new LuaMethod("setMicroscope"){

            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                ForgeDirection dir = null;
                Integer slot = null;
                switch (args.length) {
                    case 0: {
                        slot = ChemicalTurtlePeripheral.this.turtle.getSelectedSlot();
                        dir = this.getDirForString("front", ChemicalTurtlePeripheral.this.turtle);
                        break;
                    }
                    case 1: {
                        dir = this.getDirForString((String)args[0], ChemicalTurtlePeripheral.this.turtle);
                        if (dir != null || args.length != 1) break;
                        slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                        slot = ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_()) ? slot : null;
                        dir = this.getDirForString("front", ChemicalTurtlePeripheral.this.turtle);
                        break;
                    }
                    case 2: {
                        dir = this.getDirForString((String)args[0], ChemicalTurtlePeripheral.this.turtle);
                        slot = ChemicalTurtlePeripheral.this.getInt(args[0]);
                        Integer n = slot = ChemicalTurtlePeripheral.this.validateInteger(slot, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70302_i_()) ? slot : null;
                    }
                }
                if (dir == null || slot == null) {
                    throw new LuaException("Invalid Arguments");
                }
                ItemStack current = ChemicalTurtlePeripheral.this.turtle.getInventory().func_70301_a(slot.intValue());
                TileEntity te = ChemicalTurtlePeripheral.this.turtle.getWorld().func_147438_o(((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71574_a + dir.offsetX, ((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71572_b + dir.offsetY, ((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71573_c + dir.offsetZ);
                if (te instanceof MicroscopeTileEntity) {
                    ItemStack microStack = ((MicroscopeTileEntity)te).func_70301_a(0);
                    if (microStack == null && current == null) {
                        return new Object[]{false};
                    }
                    if (microStack == null) {
                        ((MicroscopeTileEntity)te).func_70299_a(0, ChemicalTurtlePeripheral.this.turtle.getInventory().func_70298_a(slot.intValue(), 1));
                        return new Object[]{true};
                    }
                    if (current == null) {
                        ChemicalTurtlePeripheral.this.turtle.getInventory().func_70299_a(slot.intValue(), ((MicroscopeTileEntity)te).func_70298_a(0, 1));
                        return new Object[]{true};
                    }
                    if (current.func_77969_a(microStack) && current.field_77994_a < current.func_77976_d()) {
                        ((MicroscopeTileEntity)te).func_70298_a(0, 1);
                        ++current.field_77994_a;
                    }
                }
                return new Object[]{false};
            }

            @Override
            public String getArgs() {
                return "(?Direction,?slot)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Direction, defaults to front", "Arg: Optional slot number, defaults to current", "Returns: boolean success"};
            }
        });
        this.methods.add(new LuaMethod("getState"){

            @Override
            public Object[] call(IComputerAccess computer, ILuaContext context, Object[] args) throws LuaException, InterruptedException {
                ForgeDirection dir = ForgeDirection.getOrientation((int)ChemicalTurtlePeripheral.this.turtle.getDirection());
                if (args.length < 2) {
                    if (args.length == 1 && (dir = this.getDirForString((String)args[0], ChemicalTurtlePeripheral.this.turtle)) == null) {
                        throw new LuaException("Invalid Arguments");
                    }
                    TileEntity te = ChemicalTurtlePeripheral.this.turtle.getWorld().func_147438_o(((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71574_a + dir.offsetX, ((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71572_b + dir.offsetY, ((ChemicalTurtlePeripheral)ChemicalTurtlePeripheral.this).turtle.getPosition().field_71573_c + dir.offsetZ);
                    if (te instanceof SynthesisTileEntity) {
                        return new Object[]{((SynthesisTileEntity)te).getState()};
                    }
                    if (te instanceof DecomposerTileEntity) {
                        return new Object[]{((DecomposerTileEntity)te).getStateString()};
                    }
                    throw new LuaException("Invalid TileEntity");
                }
                throw new LuaException("Invalid Arguments");
            }

            @Override
            public String getArgs() {
                return "(?Direction)";
            }

            @Override
            public String[] getDetails() {
                return new String[]{super.getDetails()[0], "Arg: Optional Direction, defaults to front", "Returns: Machine state"};
            }
        });
    }

    protected boolean addStackToKnown(ItemStack add) {
        MapKey addString = MapKey.getKey(add);
        for (MapKey key : this.known) {
            if (!key.equals(addString)) continue;
            return false;
        }
        this.known.add(addString);
        return true;
    }

    private ArrayList<MapKey> stackListToKeys(List<ItemStack> stacks) {
        if (stacks == null) {
            return null;
        }
        ArrayList<MapKey> result = new ArrayList<MapKey>();
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            result.add(MapKey.getKey(stack));
        }
        return result;
    }

    private ArrayList<ItemStack> keyListToStacks(List<MapKey> keys) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (MapKey key : keys) {
            if (key == null) continue;
            ItemStack add = null;
            DecomposerRecipe decomp = DecomposerRecipe.get(key);
            if (decomp != null) {
                add = decomp.getInput();
            } else {
                SynthesisRecipe synth = SynthesisRecipe.get(key);
                if (synth != null) {
                    add = synth.getOutput();
                }
            }
            if (add == null) continue;
            result.add(add);
        }
        return result;
    }

    private HashMap<String, Object> synthesisRecipeToMap(SynthesisRecipe recipe) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("output", this.stackToMap(recipe.getOutput()));
        result.put("shaped", recipe.isShaped());
        result.put("energyCost", recipe.energyCost());
        HashMap inputs = new HashMap();
        PotionChemical[] recipeInputs = recipe.isShaped() ? recipe.getShapedRecipe() : recipe.getShapelessRecipe();
        int i = 1;
        for (PotionChemical chemical : recipeInputs) {
            if (chemical == null) continue;
            HashMap<String, Object> input = new HashMap<String, Object>();
            if (chemical instanceof Element) {
                input.put("element", ((Element)chemical).element.getLongName());
                input.put("quantity", chemical.amount);
            } else if (chemical instanceof Molecule) {
                input.put("element", ((Molecule)chemical).molecule.name());
                input.put("quantity", chemical.amount);
            }
            inputs.put(i++, input);
        }
        result.put("ingredients", inputs);
        return result;
    }

    private HashMap<String, Object> stackToMap(ItemStack stack) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).toString());
        result.put("metadata", stack.func_77960_j());
        return result;
    }

    private ItemStack getJournal(int slot) {
        ItemStack result = this.turtle.getInventory().func_70301_a(slot);
        if (result != null && result.func_77973_b() == MinechemItemsRegistration.journal) {
            return result;
        }
        return null;
    }

    private boolean validateInteger(Integer input, int max) {
        return input != null && input < max;
    }

    private Integer getInt(Object arg) {
        return ((Number)arg).intValue();
    }

    private Object getDecayTime(int slot) {
        ItemStack current = this.turtle.getInventory().func_70301_a(slot);
        if (Compare.isStackAChemical(current)) {
            if (RadiationInfo.getRadioactivity(current) != RadiationEnum.stable && current.func_77978_p() != null && current.func_77978_p().func_74764_b("decayStart")) {
                long worldTime = this.turtle.getWorld().func_82737_E();
                return RadiationInfo.getRadioactivity(current).getLife() - (worldTime - current.func_77978_p().func_74763_f("decayStart"));
            }
            return "Infinite";
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        System.out.println(computer.getID());
        return this.methods.get(method).call(computer, context, arguments);
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        this.computer = computer;
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        this.computer = null;
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return false;
    }

    public void update() {
        if (this.timer.update(this.turtle.getWorld()) && this.computer != null) {
            List<ItemStack> inventory = this.getTurtleInventoryList();
            RadiationHandler.getInstance().updateRadiationOnItems(this.turtle.getWorld(), this.turtle, this.turtle.getInventory(), inventory);
        }
    }

    public IInventory getTurtleInventory() {
        if (this.turtle != null) {
            return this.turtle.getInventory();
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public void postDecayEvent(String before, String after, Integer damage) {
        if (this.computer != null) {
            Object[] data = new Object[]{before, after, damage};
            this.computer.queueEvent("onDecay", data);
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="ComputerCraft")
    public void onDecayEvent(RadiationDecayEvent e) {
        System.out.println("getEvent");
        if (this.computer != null && this.turtle != null && this.getTurtleInventory() == e.getInventory()) {
            this.postDecayEvent(e.getBefore().func_82833_r(), e.getAfter().func_82833_r(), e.getDamage());
        }
    }

    public List<ItemStack> getTurtleInventoryList() {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
        for (int slot = 0; slot < this.turtle.getInventory().func_70302_i_(); ++slot) {
            ItemStack stack = this.turtle.getInventory().func_70301_a(slot);
            if (stack == null) continue;
            inventory.add(stack);
        }
        return inventory;
    }
}

