/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib.animation;

import com.vicmatskiv.weaponlib.animation.Transition;
import com.vicmatskiv.weaponlib.animation.TransitionProvider;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class RenderStateManager<State> {
    private State currentState;
    private TransitionProvider<State> positioningManager;
    private Deque<Positioning> positioningQueue;

    public RenderStateManager(State initialState, TransitionProvider<State> positioningManager) {
        this.positioningManager = positioningManager;
        this.positioningQueue = new LinkedList<Positioning>();
        this.setState(initialState, false);
    }

    public void setState(State newState, boolean animated) {
        if (newState == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        if (newState.equals(this.currentState)) {
            return;
        }
        if (animated) {
            this.positioningQueue.add(new TransitionedPositioning(this.currentState, newState));
        }
        this.positioningQueue.add(new StaticPositioning(newState));
        this.currentState = newState;
    }

    private Positioning getPositioning() {
        Positioning result = null;
        while (!this.positioningQueue.isEmpty()) {
            Positioning p = this.positioningQueue.poll();
            if (p.isExpired(this.positioningQueue)) continue;
            this.positioningQueue.addFirst(p);
            result = p;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Position cannot be null");
        }
        return result;
    }

    public BiConsumer<EntityPlayer, ItemStack> getPosition() {
        return (p, i) -> this.getPositioning().apply((EntityPlayer)p, (ItemStack)i);
    }

    private class TransitionedPositioning
    implements Positioning {
        private List<Matrix4f> matrices;
        private int currentIndex;
        private long currentStartTime;
        private int segmentCount;
        private boolean expired;
        private List<Transition> fromPositioning;
        private List<Transition> toPositioning;

        TransitionedPositioning(State fromState, State toState) {
            this.fromPositioning = RenderStateManager.this.positioningManager.getPositioning(fromState);
            this.toPositioning = RenderStateManager.this.positioningManager.getPositioning(toState);
            this.segmentCount = this.toPositioning.size();
            this.matrices = new ArrayList<Matrix4f>(this.toPositioning.size() + 1);
        }

        @Override
        public boolean isExpired(Queue<Positioning> positioningQueue) {
            return this.expired;
        }

        @Override
        public void apply(EntityPlayer player, ItemStack itemStack) {
            long currentTime = System.currentTimeMillis();
            long currentDuration = this.toPositioning.get(this.currentIndex).getDuration();
            long currentPause = this.toPositioning.get(this.currentIndex).getPause();
            if (this.currentStartTime == 0L) {
                this.currentStartTime = currentTime;
                this.matrices.add(this.getMatrixForPositioning(this.fromPositioning.get(this.fromPositioning.size() - 1).getPositioning(), player, itemStack));
                for (Transition t : this.toPositioning) {
                    this.matrices.add(this.getMatrixForPositioning(t.getPositioning(), player, itemStack));
                }
            } else if (currentTime > this.currentStartTime + currentDuration + currentPause) {
                ++this.currentIndex;
                this.currentStartTime = currentTime;
            }
            long currentOffset = currentTime - this.currentStartTime;
            if (this.currentIndex >= this.segmentCount) {
                this.applyOnce(player, itemStack, this.matrices.get(this.currentIndex - 1), this.matrices.get(this.currentIndex), 1.0f);
                this.expired = true;
                return;
            }
            float currentProgress = (float)currentOffset / (float)currentDuration;
            if (currentProgress > 1.0f) {
                currentProgress = 1.0f;
            }
            this.applyOnce(player, itemStack, this.matrices.get(this.currentIndex), this.matrices.get(this.currentIndex + 1), currentProgress);
        }

        private void applyOnce(EntityPlayer player, ItemStack itemStack, Matrix4f beforeMatrix, Matrix4f afterMatrix, float progress) {
            Matrix4f m1 = this.scale(beforeMatrix, 1.0f - progress);
            Matrix4f m2 = this.scale(afterMatrix, progress);
            Matrix4f deltaMatrix = Matrix4f.add((Matrix4f)m1, (Matrix4f)m2, null);
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            deltaMatrix.store(buf);
            buf.rewind();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadMatrix((FloatBuffer)buf);
        }

        private Matrix4f scale(Matrix4f m, float factor) {
            Matrix4f result = new Matrix4f();
            result.m00 = m.m00 * factor;
            result.m01 = m.m01 * factor;
            result.m02 = m.m02 * factor;
            result.m03 = m.m03 * factor;
            result.m10 = m.m10 * factor;
            result.m11 = m.m11 * factor;
            result.m12 = m.m12 * factor;
            result.m13 = m.m13 * factor;
            result.m20 = m.m20 * factor;
            result.m21 = m.m21 * factor;
            result.m22 = m.m22 * factor;
            result.m23 = m.m23 * factor;
            result.m30 = m.m30 * factor;
            result.m31 = m.m31 * factor;
            result.m32 = m.m32 * factor;
            result.m33 = m.m33 * factor;
            return result;
        }

        private Matrix4f getMatrixForPositioning(BiConsumer<EntityPlayer, ItemStack> positioning, EntityPlayer player, ItemStack itemStack) {
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5888);
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            positioning.accept(player, itemStack);
            GL11.glGetFloat((int)2982, (FloatBuffer)buf);
            buf.rewind();
            Matrix4f matrix = new Matrix4f();
            matrix.load(buf);
            GL11.glPopMatrix();
            return matrix;
        }
    }

    private class StaticPositioning
    implements Positioning {
        private State state;

        public StaticPositioning(State state) {
            this.state = state;
        }

        @Override
        public void apply(EntityPlayer player, ItemStack itemStack) {
            List<Transition> positioning = RenderStateManager.this.positioningManager.getPositioning(this.state);
            positioning.get(positioning.size() - 1).getPositioning().accept(player, itemStack);
        }

        @Override
        public boolean isExpired(Queue<Positioning> positioningQueue) {
            return !positioningQueue.isEmpty();
        }
    }

    public static interface Positioning {
        public void apply(EntityPlayer var1, ItemStack var2);

        public boolean isExpired(Queue<Positioning> var1);
    }
}

