/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.CompatibleAttachment;
import com.vicmatskiv.weaponlib.ModelWithAttachments;
import com.vicmatskiv.weaponlib.RenderableState;
import com.vicmatskiv.weaponlib.Weapon;
import com.vicmatskiv.weaponlib.animation.RenderStateManager;
import com.vicmatskiv.weaponlib.animation.Transition;
import com.vicmatskiv.weaponlib.animation.TransitionProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class WeaponRenderer
implements IItemRenderer,
TransitionProvider<RenderableState> {
    private static final int DEFAULT_ANIMATION_DURATION = 250;
    private Builder builder;
    private Map<EntityPlayer, RenderStateManager<RenderableState>> firstPersonStateManagers;

    private WeaponRenderer(Builder builder) {
        this.builder = builder;
        this.firstPersonStateManagers = new HashMap<EntityPlayer, RenderStateManager<RenderableState>>();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    private RenderStateManager<RenderableState> getStateManager(EntityPlayer player, ItemStack itemStack) {
        RenderableState currentState = null;
        currentState = ((Weapon)itemStack.func_77973_b()).getState(itemStack) == 4 && this.builder.firstPersonPositioningModifying != null ? RenderableState.MODIFYING : (player.func_70051_ag() && this.builder.firstPersonPositioningRunning != null ? RenderableState.RUNNING : (Weapon.isReloadingConfirmed(player, itemStack) ? RenderableState.RELOADING : (Weapon.isZoomed(itemStack) ? RenderableState.ZOOMING : RenderableState.NORMAL)));
        RenderStateManager<RenderableState> stateManager = this.firstPersonStateManagers.get(player);
        if (stateManager == null) {
            stateManager = new RenderStateManager<RenderableState>(currentState, this);
            this.firstPersonStateManagers.put(player, stateManager);
        } else {
            stateManager.setState(currentState, true);
        }
        return stateManager;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glScaled((double)-1.0, (double)-1.0, (double)1.0);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        switch (type) {
            case ENTITY: {
                this.builder.entityPositioning.accept(item);
                break;
            }
            case INVENTORY: {
                this.builder.inventoryPositioning.accept(item);
                break;
            }
            case EQUIPPED: {
                this.builder.thirdPersonPositioning.accept(player, item);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                RenderStateManager<RenderableState> stateManager = this.getStateManager((EntityPlayer)player, item);
                stateManager.getPosition().accept((EntityPlayer)player, item);
                break;
            }
        }
        if (this.builder.textureName != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.builder.modId + ":textures/models/" + this.builder.textureName));
        } else {
            Weapon weapon = (Weapon)item.func_77973_b();
            String textureName = weapon.getActiveTextureName(item);
            if (textureName != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.builder.modId + ":textures/models/" + textureName));
            }
        }
        this.builder.model.func_78088_a(null, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        if (this.builder.model instanceof ModelWithAttachments) {
            List<CompatibleAttachment<Weapon>> attachments = ((Weapon)item.func_77973_b()).getActiveAttachments(item);
            ((ModelWithAttachments)this.builder.model).renderAttachments(this.builder.modId, item, type, attachments, null, 0.0f, 0.0f, -0.4f, 0.0f, 0.0f, 0.08f);
        }
        GL11.glPopMatrix();
    }

    @Override
    public List<Transition> getPositioning(RenderableState state) {
        switch (state) {
            case MODIFYING: {
                return Collections.singletonList(new Transition(this.builder.firstPersonPositioningModifying, 250L));
            }
            case RUNNING: {
                return Collections.singletonList(new Transition(this.builder.firstPersonPositioningRunning, 250L));
            }
            case RELOADING: {
                return this.builder.firstPersonPositioningReloading;
            }
            case NORMAL: {
                return Collections.singletonList(new Transition(this.builder.firstPersonPositioning, 250L));
            }
            case ZOOMING: {
                return Collections.singletonList(new Transition(this.builder.firstPersonPositioningZooming != null ? this.builder.firstPersonPositioningZooming : this.builder.firstPersonPositioning, 250L));
            }
        }
        return null;
    }

    public static class Builder {
        private ModelBase model;
        private String textureName;
        private float weaponProximity;
        private float yOffsetZoom;
        private float xOffsetZoom = 0.69f;
        private Consumer<ItemStack> entityPositioning;
        private Consumer<ItemStack> inventoryPositioning;
        private BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningZooming;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningRunning;
        private BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningModifying;
        private List<Transition> firstPersonPositioningReloading;
        private String modId;

        public Builder withModId(String modId) {
            this.modId = modId;
            return this;
        }

        public Builder withModel(ModelBase model) {
            this.model = model;
            return this;
        }

        public Builder withTextureName(String textureName) {
            this.textureName = textureName + ".png";
            return this;
        }

        public Builder withWeaponProximity(float weaponProximity) {
            this.weaponProximity = weaponProximity;
            return this;
        }

        public Builder withYOffsetZoom(float yOffsetZoom) {
            this.yOffsetZoom = yOffsetZoom;
            return this;
        }

        public Builder withXOffsetZoom(float xOffsetZoom) {
            this.xOffsetZoom = xOffsetZoom;
            return this;
        }

        public Builder withEntityPositioning(Consumer<ItemStack> entityPositioning) {
            this.entityPositioning = entityPositioning;
            return this;
        }

        public Builder withInventoryPositioning(Consumer<ItemStack> inventoryPositioning) {
            this.inventoryPositioning = inventoryPositioning;
            return this;
        }

        public Builder withThirdPersonPositioning(BiConsumer<EntityPlayer, ItemStack> thirdPersonPositioning) {
            this.thirdPersonPositioning = thirdPersonPositioning;
            return this;
        }

        public Builder withFirstPersonPositioning(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioning) {
            this.firstPersonPositioning = firstPersonPositioning;
            return this;
        }

        public Builder withFirstPersonPositioningRunning(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningRunning) {
            this.firstPersonPositioningRunning = firstPersonPositioningRunning;
            return this;
        }

        public Builder withFirstPersonPositioningZooming(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningZooming) {
            this.firstPersonPositioningZooming = firstPersonPositioningZooming;
            return this;
        }

        @SafeVarargs
        public final Builder withFirstPersonPositioningReloading(Transition ... transitions) {
            this.firstPersonPositioningReloading = Arrays.asList(transitions);
            return this;
        }

        public Builder withFirstPersonPositioningModifying(BiConsumer<EntityPlayer, ItemStack> firstPersonPositioningModifying) {
            this.firstPersonPositioningModifying = firstPersonPositioningModifying;
            return this;
        }

        public WeaponRenderer build() {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            if (this.inventoryPositioning == null) {
                this.inventoryPositioning = itemStack -> GL11.glTranslatef((float)0.0f, (float)0.12f, (float)0.0f);
            }
            if (this.entityPositioning == null) {
                this.entityPositioning = itemStack -> {};
            }
            if (this.firstPersonPositioning == null) {
                this.firstPersonPositioning = (player, itemStack) -> {
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (itemStack.field_77990_d != null && itemStack.field_77990_d.func_74760_g("Zoomed") != 1.0f) {
                        GL11.glTranslatef((float)this.xOffsetZoom, (float)this.yOffsetZoom, (float)this.weaponProximity);
                    } else {
                        GL11.glTranslatef((float)0.0f, (float)-1.2f, (float)0.0f);
                    }
                };
            }
            if (this.firstPersonPositioningReloading == null) {
                this.firstPersonPositioningReloading = Collections.singletonList(new Transition(this.firstPersonPositioning, 250L));
            }
            if (this.thirdPersonPositioning == null) {
                this.thirdPersonPositioning = (player, itemStack) -> {
                    GL11.glTranslatef((float)-0.4f, (float)0.2f, (float)0.4f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                };
            }
            return new WeaponRenderer(this);
        }
    }
}

