/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.google.common.util.concurrent.AtomicDouble;
import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.AttachmentModeMessage;
import com.vicmatskiv.weaponlib.ChangeSettingsMessage;
import com.vicmatskiv.weaponlib.CompatibleAttachment;
import com.vicmatskiv.weaponlib.ImpactHandler;
import com.vicmatskiv.weaponlib.ItemAmmo;
import com.vicmatskiv.weaponlib.ItemAttachment;
import com.vicmatskiv.weaponlib.ModContext;
import com.vicmatskiv.weaponlib.ReloadMessage;
import com.vicmatskiv.weaponlib.TryFireMessage;
import com.vicmatskiv.weaponlib.WeaponSpawnEntity;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public class Weapon
extends Item {
    private static final String ACTIVE_ATTACHMENT_TAG = "ActiveAttachments";
    private static final String SELECTED_ATTACHMENT_INDEXES_TAG = "SelectedAttachments";
    private static final String PREVIOUSLY_SELECTED_ATTACHMENT_TAG = "PreviouslySelectedAttachments";
    private static final String SHOT_COUNTER_TAG = "ShotCounter";
    public static final String ZOOM_TAG = "Zoomed";
    public static final String RECOIL_TAG = "Recoil";
    static final String AIMED_TAG = "Aimed";
    private static final int RESUME_TIMEOUT_TICKS = 4;
    private static final int DEFAULT_RELOADING_TIMEOUT_TICKS = 10;
    private static final String RECOIL_TIMER_TAG = "RecoilTimer";
    private static final String STOP_TIMER_TAG = "StopTimer";
    private static final String RESUME_TIMER_TAG = "ResumeTimer";
    private static final String RELOADING_TIMER_TAG = "ReloadingTimer";
    private static final String ACTIVE_TEXTURE_INDEX_TAG = "ActiveTextureIndex";
    private static final String LASER_ON_TAG = "LaserOn";
    private static final String AMMO_TAG = "Ammo";
    private static final String PERSISTENT_STATE_TAG = "PersistentState";
    private static final float DEFAULT_ZOOM = 0.75f;
    private static final float DEFAULT_FIRE_RATE = 0.5f;
    public static final String STATE_TAG = "State";
    public static final int STATE_READY = 0;
    public static final int STATE_SHOOTING = 1;
    public static final int STATE_PAUSED = 2;
    public static final int STATE_RELOADING = 3;
    public static final int STATE_MODIFYING = 4;
    public static final int VIEW_BOBBING_ON = 1;
    public static final int VIEW_BOBBING_OFF = 2;
    public static final int INFINITE_AMMO = -1;
    private static final long MAX_RELOAD_TIMEOUT_TICKS = 60L;
    private Builder builder;
    private ModContext modContext;
    Random random = new Random();
    private Map<UUID, WeaponInstanceStorage> weaponInstanceStorages = new IdentityHashMap<UUID, WeaponInstanceStorage>();

    private Weapon(Builder builder, ModContext modContext) {
        this.builder = builder;
        this.modContext = modContext;
        this.func_77625_d(1);
    }

    public String getName() {
        return this.builder.name;
    }

    public void func_94581_a(IIconRegister register) {
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack itemStack) {
        this.ensureItemStack(itemStack);
        float currentZoom = itemStack.field_77990_d.func_74760_g(ZOOM_TAG);
        if (currentZoom != 1.0f || entityLiving.func_70051_ag()) {
            itemStack.field_77990_d.func_74776_a(ZOOM_TAG, 1.0f);
            itemStack.field_77990_d.func_74757_a(AIMED_TAG, false);
        } else {
            WeaponInstanceStorage weaponInstanceStorage = this.getWeaponInstanceStorage((EntityPlayer)entityLiving);
            if (weaponInstanceStorage != null) {
                itemStack.field_77990_d.func_74776_a(ZOOM_TAG, weaponInstanceStorage.getZoom());
            }
            itemStack.field_77990_d.func_74757_a(AIMED_TAG, true);
        }
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean active) {
        this.ensureItemStack(itemStack);
        float currentZoom = itemStack.field_77990_d.func_74760_g(ZOOM_TAG);
        if (currentZoom != 1.0f && entity.func_70051_ag()) {
            itemStack.field_77990_d.func_74776_a(ZOOM_TAG, 1.0f);
            itemStack.field_77990_d.func_74757_a(AIMED_TAG, false);
        }
    }

    public static boolean isZoomed(ItemStack itemStack) {
        return itemStack.field_77990_d != null && itemStack.field_77990_d.func_74760_g(ZOOM_TAG) != 1.0f;
    }

    private void ensureItemStack(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
            itemStack.field_77990_d.func_74768_a(AMMO_TAG, 0);
            itemStack.field_77990_d.func_74768_a(SHOT_COUNTER_TAG, 0);
            itemStack.field_77990_d.func_74776_a(ZOOM_TAG, 1.0f);
            itemStack.field_77990_d.func_74776_a(RECOIL_TAG, this.builder.recoil);
            itemStack.field_77990_d.func_74772_a(STOP_TIMER_TAG, 0L);
            itemStack.field_77990_d.func_74772_a(RESUME_TIMER_TAG, 0L);
            this.setState(itemStack, 0);
        }
    }

    public void changeRecoil(EntityPlayer player, float factor) {
        ItemStack itemStack = player.func_70694_bm();
        this.ensureItemStack(itemStack);
        float recoil = this.builder.recoil * factor;
        itemStack.field_77990_d.func_74776_a(RECOIL_TAG, recoil);
        this.modContext.getChannel().sendTo((IMessage)new ChangeSettingsMessage(this, recoil), (EntityPlayerMP)player);
    }

    public void clientChangeRecoil(EntityPlayer player, float recoil) {
        WeaponInstanceStorage weaponInstanceStorage = this.getWeaponInstanceStorage(player);
        if (weaponInstanceStorage != null) {
            weaponInstanceStorage.setRecoil(recoil);
        }
    }

    public void changeZoom(EntityPlayer player, float factor) {
        WeaponInstanceStorage weaponInstanceStorage = this.getWeaponInstanceStorage(player);
        if (weaponInstanceStorage != null) {
            weaponInstanceStorage.zoom = this.builder.zoom * factor;
        }
    }

    int getShotCount(ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            return itemStack.field_77990_d.func_74762_e(SHOT_COUNTER_TAG);
        }
        return 0;
    }

    int getMaxShots() {
        return this.builder.maxShots;
    }

    int getState(ItemStack itemStack) {
        return itemStack.field_77990_d.func_74762_e(STATE_TAG);
    }

    long getReloadingTimeout() {
        return this.builder.reloadingTimeout;
    }

    void setState(ItemStack itemStack, int newState) {
        itemStack.field_77990_d.func_74768_a(STATE_TAG, newState);
    }

    void enterAttachmentSelectionMode(ItemStack itemStack) {
        this.ensureItemStack(itemStack);
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        int[] selectedAttachmentIndexes = new int[AttachmentCategory.values.length];
        itemStack.field_77990_d.func_74783_a(SELECTED_ATTACHMENT_INDEXES_TAG, selectedAttachmentIndexes);
        itemStack.field_77990_d.func_74783_a(PREVIOUSLY_SELECTED_ATTACHMENT_TAG, Arrays.copyOf(activeAttachmentsIds, activeAttachmentsIds.length));
        ((Weapon)itemStack.func_77973_b()).setState(itemStack, 4);
        itemStack.field_77990_d.func_74768_a(PERSISTENT_STATE_TAG, WeaponInstanceState.MODIFYING.ordinal());
    }

    void exitAttachmentSelectionMode(ItemStack itemStack, EntityPlayer player) {
        this.ensureItemStack(itemStack);
        int[] activeAttachmentsIds = itemStack.field_77990_d.func_74759_k(ACTIVE_ATTACHMENT_TAG);
        int[] previouslySelectedAttachmentIds = itemStack.field_77990_d.func_74759_k(PREVIOUSLY_SELECTED_ATTACHMENT_TAG);
        for (int i = 0; i < activeAttachmentsIds.length; ++i) {
            if (activeAttachmentsIds[i] == previouslySelectedAttachmentIds[i]) continue;
            Item newItem = Item.func_150899_d((int)activeAttachmentsIds[i]);
            Item oldItem = Item.func_150899_d((int)previouslySelectedAttachmentIds[i]);
            player.field_71071_by.func_146026_a(newItem);
            if (player.field_71071_by.func_70441_a(new ItemStack(oldItem))) continue;
            System.err.println("Cannot add item back to the inventory: " + oldItem);
        }
        ((Weapon)itemStack.func_77973_b()).setState(itemStack, 0);
        itemStack.field_77990_d.func_74768_a(PERSISTENT_STATE_TAG, WeaponInstanceState.READY.ordinal());
    }

    String getCrosshair(ItemStack itemStack, EntityPlayer thePlayer) {
        if (Weapon.isZoomed(itemStack)) {
            String crosshair = null;
            ItemAttachment<Weapon> scopeAttachment = this.getActiveAttachment(itemStack, AttachmentCategory.SCOPE);
            if (scopeAttachment != null) {
                crosshair = scopeAttachment.getCrosshair();
            }
            if (crosshair == null) {
                crosshair = this.builder.crosshairZoomed;
            }
            return crosshair;
        }
        if (thePlayer.func_70051_ag()) {
            return this.builder.crosshairRunning;
        }
        return this.builder.crosshair;
    }

    boolean isCrosshairFullScreen(ItemStack itemStack) {
        if (Weapon.isZoomed(itemStack)) {
            return this.builder.crosshairZoomedFullScreen;
        }
        return this.builder.crosshairFullScreen;
    }

    boolean isCrosshairZoomedFullScreen() {
        return this.builder.crosshairZoomedFullScreen;
    }

    void changeTexture(ItemStack itemStack, EntityPlayer player) {
        this.ensureItemStack(itemStack);
        int currentIndex = itemStack.field_77990_d.func_74762_e(ACTIVE_TEXTURE_INDEX_TAG);
        if (this.builder.textureNames.isEmpty()) {
            return;
        }
        currentIndex = currentIndex >= this.builder.textureNames.size() - 1 ? 0 : ++currentIndex;
        itemStack.field_77990_d.func_74768_a(ACTIVE_TEXTURE_INDEX_TAG, currentIndex);
    }

    String getActiveTextureName(ItemStack itemStack) {
        this.ensureItemStack(itemStack);
        if (this.builder.textureNames.isEmpty()) {
            return null;
        }
        return (String)this.builder.textureNames.get(itemStack.field_77990_d.func_74762_e(ACTIVE_TEXTURE_INDEX_TAG));
    }

    void changeAttachment(AttachmentCategory attachmentCategory, ItemStack itemStack, EntityPlayer player) {
        this.ensureItemStack(itemStack);
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[attachmentCategory.ordinal()];
        ItemAttachment currentAttachment = null;
        if (activeAttachmentIdForThisCategory > 0) {
            currentAttachment = (ItemAttachment)Item.func_150899_d((int)activeAttachmentIdForThisCategory);
        }
        ItemAttachment<Weapon> nextAttachment = this.nextCompatibleAttachment(attachmentCategory, currentAttachment, player, itemStack);
        if (currentAttachment != null && currentAttachment.getRemove() != null) {
            currentAttachment.getRemove().apply(currentAttachment, this, player);
        }
        if (nextAttachment != null && nextAttachment.getApply() != null) {
            nextAttachment.getApply().apply(nextAttachment, this, player);
        }
        activeAttachmentsIds[attachmentCategory.ordinal()] = Item.func_150891_b(nextAttachment);
        itemStack.field_77990_d.func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
    }

    private ItemAttachment<Weapon> nextCompatibleAttachment(AttachmentCategory category, Item currentAttachment, EntityPlayer player, ItemStack itemStack) {
        int currentIndex;
        int[] selectedAttachmentIndexes = itemStack.field_77990_d.func_74759_k(SELECTED_ATTACHMENT_INDEXES_TAG);
        if (selectedAttachmentIndexes == null || selectedAttachmentIndexes.length != AttachmentCategory.values.length) {
            return null;
        }
        int activeIndex = selectedAttachmentIndexes[category.ordinal()];
        ItemAttachment nextCompatibleAttachment = null;
        for (currentIndex = activeIndex + 1; currentIndex <= 36; ++currentIndex) {
            ItemAttachment attachmentItemFromInventory;
            if (currentIndex == 0) {
                int[] previouslySelectedAttachmentIds = itemStack.field_77990_d.func_74759_k(PREVIOUSLY_SELECTED_ATTACHMENT_TAG);
                nextCompatibleAttachment = (ItemAttachment)Item.func_150899_d((int)previouslySelectedAttachmentIds[category.ordinal()]);
                if (nextCompatibleAttachment == null) continue;
                break;
            }
            ItemStack slotItemStack = player.field_71071_by.func_70301_a(currentIndex - 1);
            if (slotItemStack == null || !(slotItemStack.func_77973_b() instanceof ItemAttachment) || (attachmentItemFromInventory = (ItemAttachment)slotItemStack.func_77973_b()).getCategory() != category || !this.builder.compatibleAttachments.containsKey((Object)attachmentItemFromInventory) || attachmentItemFromInventory == currentAttachment) continue;
            nextCompatibleAttachment = attachmentItemFromInventory;
            break;
        }
        if (nextCompatibleAttachment == null) {
            currentIndex = -1;
        }
        selectedAttachmentIndexes[category.ordinal()] = currentIndex;
        itemStack.field_77990_d.func_74783_a(SELECTED_ATTACHMENT_INDEXES_TAG, selectedAttachmentIndexes);
        return nextCompatibleAttachment;
    }

    public ItemAttachment<Weapon> getActiveAttachment(ItemStack itemStack, AttachmentCategory category) {
        int[] activeAttachmentsIds;
        this.ensureItemStack(itemStack);
        ItemAttachment itemAttachment = null;
        for (int activeIndex : activeAttachmentsIds = this.ensureActiveAttachments(itemStack)) {
            CompatibleAttachment compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = (CompatibleAttachment)this.builder.compatibleAttachments.get(item)) == null || category != compatibleAttachment.getAttachment().getCategory()) continue;
            itemAttachment = compatibleAttachment.getAttachment();
            break;
        }
        return itemAttachment;
    }

    List<CompatibleAttachment<Weapon>> getActiveAttachments(ItemStack itemStack) {
        int[] activeAttachmentsIds;
        this.ensureItemStack(itemStack);
        ArrayList<CompatibleAttachment<Weapon>> activeAttachments = new ArrayList<CompatibleAttachment<Weapon>>();
        for (int activeIndex : activeAttachmentsIds = this.ensureActiveAttachments(itemStack)) {
            CompatibleAttachment compatibleAttachment;
            Item item;
            if (activeIndex == 0 || !((item = Item.func_150899_d((int)activeIndex)) instanceof ItemAttachment) || (compatibleAttachment = (CompatibleAttachment)this.builder.compatibleAttachments.get(item)) == null) continue;
            activeAttachments.add(compatibleAttachment);
        }
        return activeAttachments;
    }

    private int[] ensureActiveAttachments(ItemStack itemStack) {
        int[] activeAttachmentsIds = itemStack.field_77990_d.func_74759_k(ACTIVE_ATTACHMENT_TAG);
        if (activeAttachmentsIds == null || activeAttachmentsIds.length != AttachmentCategory.values.length) {
            activeAttachmentsIds = new int[AttachmentCategory.values.length];
            itemStack.field_77990_d.func_74783_a(ACTIVE_ATTACHMENT_TAG, activeAttachmentsIds);
            for (CompatibleAttachment attachment : this.builder.compatibleAttachments.values()) {
                if (!attachment.isDefault()) continue;
                activeAttachmentsIds[attachment.getAttachment().getCategory().ordinal()] = Item.func_150891_b(attachment.getAttachment());
            }
        }
        return activeAttachmentsIds;
    }

    public static boolean isActiveAttachment(ItemStack itemStack, ItemAttachment<Weapon> attachment) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        int[] activeAttachmentsIds = weapon.ensureActiveAttachments(itemStack);
        return Arrays.stream(activeAttachmentsIds).anyMatch(attachmentId -> attachment == Item.func_150899_d((int)attachmentId));
    }

    private boolean isSilencerOn(ItemStack itemStack) {
        int[] activeAttachmentsIds = this.ensureActiveAttachments(itemStack);
        int activeAttachmentIdForThisCategory = activeAttachmentsIds[AttachmentCategory.SILENCER.ordinal()];
        return activeAttachmentIdForThisCategory > 0;
    }

    public static boolean isReloadingConfirmed(EntityPlayer player, ItemStack itemStack) {
        Weapon weapon = (Weapon)itemStack.func_77973_b();
        WeaponInstanceStorage storage = weapon.getWeaponInstanceStorage(player);
        return storage != null && storage.getState() == WeaponInstanceState.RELOAD_CONFIRMED;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 0;
    }

    public static boolean isAimed(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() instanceof Weapon && itemStack.field_77990_d != null && itemStack.field_77990_d.func_74767_n(AIMED_TAG);
    }

    private WeaponInstanceStorage getWeaponInstanceStorage(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        return this.weaponInstanceStorages.computeIfAbsent(player.getPersistentID(), w -> entityPlayer.func_70694_bm().field_77990_d != null ? new WeaponInstanceStorage(WeaponInstanceState.values()[entityPlayer.func_70694_bm().field_77990_d.func_74762_e(PERSISTENT_STATE_TAG)], entityPlayer.func_70694_bm().field_77990_d.func_74762_e(AMMO_TAG), this.builder.zoom, entityPlayer.func_70694_bm().field_77990_d.func_74760_g(RECOIL_TAG)) : null);
    }

    public void clientTryFire(EntityPlayer player) {
        boolean readyToShootAccordingToFireRate;
        WeaponInstanceStorage storage = this.getWeaponInstanceStorage(player);
        if (storage == null) {
            return;
        }
        boolean bl = readyToShootAccordingToFireRate = (float)(System.currentTimeMillis() - storage.lastShotFiredAt) >= 50.0f / this.builder.fireRate;
        if (!player.func_70051_ag() && (storage.getState() == WeaponInstanceState.READY || storage.getState() == WeaponInstanceState.SHOOTING) && readyToShootAccordingToFireRate && storage.shots < this.builder.maxShots && storage.currentAmmo.getAndAccumulate(0, (current, ignore) -> current > 0 ? current - 1 : 0) > 0) {
            storage.setState(WeaponInstanceState.SHOOTING);
            this.modContext.getChannel().sendToServer((IMessage)new TryFireMessage(true));
            this.modContext.runSyncTick(() -> player.func_85030_a(this.isSilencerOn(player.func_70694_bm()) ? this.builder.silencedShootSound : this.builder.shootSound, 1.0f, 1.0f));
            player.field_70125_A -= storage.getRecoil();
            float rotationYawFactor = -1.0f + this.random.nextFloat() * 2.0f;
            player.field_70177_z += storage.getRecoil() * rotationYawFactor;
            storage.lastShotFiredAt = System.currentTimeMillis();
            storage.shots++;
        }
    }

    public void tryFire(EntityPlayer player, ItemStack itemStack) {
        int currentAmmo = itemStack.field_77990_d.func_74762_e(AMMO_TAG);
        if (currentAmmo > 0) {
            if (!Weapon.isZoomed(itemStack)) {
                itemStack.field_77990_d.func_74757_a(AIMED_TAG, true);
            }
            itemStack.field_77990_d.func_74768_a(AMMO_TAG, currentAmmo - 1);
            player.field_70170_p.func_72838_d((Entity)this.builder.spawnEntityWith.apply(this, player));
            player.field_70170_p.func_85173_a(player, this.isSilencerOn(itemStack) ? this.builder.silencedShootSound : this.builder.shootSound, 1.0f, 1.0f);
        } else {
            System.err.println("Invalid state: attempted to fire a weapon without ammo");
        }
    }

    public void tryStopFire(EntityPlayer player, ItemStack itemStack) {
        if (!Weapon.isZoomed(itemStack)) {
            itemStack.field_77990_d.func_74757_a(AIMED_TAG, false);
        }
    }

    public void clientTryStopFire(EntityPlayer player) {
        WeaponInstanceStorage storage = this.getWeaponInstanceStorage(player);
        if (storage == null) {
            return;
        }
        if (storage.getState() == WeaponInstanceState.SHOOTING) {
            storage.shots = 0;
            if (storage.lastShotFiredAt + this.builder.pumpTimeoutMilliseconds <= System.currentTimeMillis()) {
                storage.setState(WeaponInstanceState.READY);
            } else {
                storage.setState(WeaponInstanceState.PAUSED);
            }
            this.modContext.getChannel().sendToServer((IMessage)new TryFireMessage(false));
        }
    }

    public void initiateReload(ItemStack itemStack, EntityPlayer player) {
        WeaponInstanceStorage storage = this.getWeaponInstanceStorage(player);
        if (storage == null) {
            return;
        }
        if (storage.getState() != WeaponInstanceState.RELOAD_REQUESTED && storage.getState() != WeaponInstanceState.RELOAD_CONFIRMED && storage.currentAmmo.get() < this.builder.ammoCapacity) {
            storage.reloadingStopsAt.set(player.field_70170_p.func_82737_E() + 60L);
            storage.setState(WeaponInstanceState.RELOAD_REQUESTED);
            this.modContext.getChannel().sendToServer((IMessage)new ReloadMessage(this));
        }
    }

    public void completeReload(ItemStack itemStack, EntityPlayer player, int ammo, boolean quietly) {
        WeaponInstanceStorage storage = this.getWeaponInstanceStorage(player);
        if (storage == null) {
            return;
        }
        if (storage.getState() == WeaponInstanceState.RELOAD_REQUESTED) {
            storage.currentAmmo.set(ammo);
            if (ammo > 0 && !quietly) {
                storage.setState(WeaponInstanceState.RELOAD_CONFIRMED);
                long reloadingStopsAt = player.field_70170_p.func_82737_E() + (long)this.builder.reloadingTimeout;
                storage.reloadingStopsAt.set(reloadingStopsAt);
                player.func_85030_a(this.builder.reloadSound, 1.0f, 1.0f);
            } else {
                storage.setState(WeaponInstanceState.READY);
            }
        }
    }

    public void reload(ItemStack itemStack, EntityPlayer player) {
        if (itemStack.field_77990_d != null && !player.func_70051_ag()) {
            if (player.field_71071_by.func_146026_a((Item)this.builder.ammo)) {
                long totalWorldTime = player.field_70170_p.func_82737_E();
                itemStack.field_77990_d.func_74772_a(RELOADING_TIMER_TAG, totalWorldTime + (long)this.builder.reloadingTimeout);
                this.setState(itemStack, 3);
                itemStack.field_77990_d.func_74768_a(AMMO_TAG, this.builder.ammoCapacity);
                this.modContext.getChannel().sendTo((IMessage)new ReloadMessage(this, this.builder.ammoCapacity), (EntityPlayerMP)player);
                player.field_70170_p.func_85173_a(player, this.builder.reloadSound, 1.0f, 1.0f);
            } else {
                itemStack.field_77990_d.func_74768_a(AMMO_TAG, 0);
                this.modContext.getChannel().sendTo((IMessage)new ReloadMessage(this, 0), (EntityPlayerMP)player);
            }
        }
    }

    public void tick(EntityPlayer player) {
        WeaponInstanceStorage storage = this.getWeaponInstanceStorage(player);
        if (storage != null) {
            if (storage.getState() == WeaponInstanceState.RELOAD_REQUESTED || storage.getState() == WeaponInstanceState.RELOAD_CONFIRMED) {
                long totalWorldTime = player.field_70170_p.func_82737_E();
                if (storage.reloadingStopsAt.get() <= totalWorldTime) {
                    storage.setState(WeaponInstanceState.READY);
                }
            } else if (storage.getState() == WeaponInstanceState.PAUSED && storage.lastShotFiredAt + this.builder.pumpTimeoutMilliseconds <= System.currentTimeMillis()) {
                storage.setState(WeaponInstanceState.READY);
            }
        }
    }

    public void switchClientAttachmentSelectionMode(ItemStack itemStack, EntityPlayer player) {
        WeaponInstanceStorage storage = this.getWeaponInstanceStorage(player);
        if (storage == null) {
            return;
        }
        if (storage.getState() != WeaponInstanceState.MODIFYING) {
            storage.setState(WeaponInstanceState.MODIFYING);
        } else {
            storage.setState(WeaponInstanceState.READY);
        }
        this.modContext.getChannel().sendToServer((IMessage)new AttachmentModeMessage());
    }

    public int getCurrentAmmo(EntityPlayer player) {
        WeaponInstanceStorage storage = this.getWeaponInstanceStorage(player);
        if (storage == null) {
            return 0;
        }
        return storage.currentAmmo.get();
    }

    public int getAmmoCapacity() {
        return this.builder.ammoCapacity;
    }

    public ItemAmmo getAmmo() {
        return this.builder.ammo;
    }

    public ModelBase getAmmoModel() {
        return this.builder.ammoModel;
    }

    public String getAmmoModelTextureName() {
        return this.builder.ammoModelTextureName;
    }

    void onSpawnEntityBlockImpact(World world, EntityPlayer player, WeaponSpawnEntity entity, MovingObjectPosition position) {
        if (this.builder.blockImpactHandler != null) {
            this.builder.blockImpactHandler.onImpact(world, player, entity, position);
        }
    }

    public boolean isLaserOn(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return false;
        }
        return itemStack.field_77990_d.func_74767_n(LASER_ON_TAG);
    }

    public void switchLaser(ItemStack itemStack) {
        this.ensureItemStack(itemStack);
        boolean current = itemStack.field_77990_d.func_74767_n(LASER_ON_TAG);
        itemStack.field_77990_d.func_74757_a(LASER_ON_TAG, !current);
    }

    static class WeaponInstanceStorage {
        private AtomicInteger currentAmmo;
        private AtomicLong reloadingStopsAt;
        private long lastShotFiredAt;
        private int shots;
        private float zoom;
        private AtomicDouble recoil;
        private AtomicReference<WeaponInstanceState> state;

        public WeaponInstanceStorage(WeaponInstanceState state, int currentAmmo, float zoom, float recoil) {
            this.currentAmmo = new AtomicInteger(currentAmmo);
            this.reloadingStopsAt = new AtomicLong();
            this.recoil = new AtomicDouble((double)recoil);
            this.state = new AtomicReference<WeaponInstanceState>(state);
            this.zoom = zoom;
        }

        public WeaponInstanceState getState() {
            return this.state.get();
        }

        public void setState(WeaponInstanceState state) {
            this.state.set(state);
        }

        public float getZoom() {
            return this.zoom;
        }

        public void setZoom(float zoom) {
            this.zoom = zoom;
        }

        public float getRecoil() {
            return (float)this.recoil.get();
        }

        public void setRecoil(float recoil) {
            this.recoil.set((double)recoil);
        }
    }

    public static enum WeaponInstanceState {
        READY,
        SHOOTING,
        RELOAD_REQUESTED,
        RELOAD_CONFIRMED,
        PAUSED,
        MODIFYING;

    }

    public static class Builder {
        private static final float DEFAULT_SPAWN_ENTITY_SPEED = 10.0f;
        private String name;
        private List<String> textureNames = new ArrayList<String>();
        private int ammoCapacity = 1;
        private float recoil = 1.0f;
        private String shootSound;
        private String silencedShootSound;
        private String reloadSound;
        private String exceededMaxShotsSound;
        private ItemAmmo ammo;
        private float fireRate = 0.5f;
        private CreativeTabs creativeTab;
        private IItemRenderer renderer;
        private float zoom = 0.75f;
        private int maxShots = Integer.MAX_VALUE;
        private String crosshair;
        private String crosshairRunning;
        private String crosshairZoomed;
        private BiFunction<Weapon, EntityPlayer, ? extends WeaponSpawnEntity> spawnEntityWith;
        private float spawnEntityDamage;
        private float spawnEntityExplosionRadius;
        private float spawnEntityGravityVelocity;
        private int reloadingTimeout = 10;
        private String modId;
        private int resumeTimeout = 4;
        private boolean crosshairFullScreen = false;
        private boolean crosshairZoomedFullScreen = false;
        private Map<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>> compatibleAttachments = new HashMap<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>>();
        private ModelBase ammoModel;
        private String ammoModelTextureName;
        private float spawnEntitySpeed = 10.0f;
        private Class<? extends WeaponSpawnEntity> spawnEntityClass;
        private ImpactHandler blockImpactHandler;
        private long pumpTimeoutMilliseconds;

        public Builder withModId(String modId) {
            this.modId = modId;
            return this;
        }

        public Builder withReloadingTime(int reloadingTime) {
            this.reloadingTimeout = reloadingTime;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withAmmoCapacity(int ammoCapacity) {
            this.ammoCapacity = ammoCapacity;
            return this;
        }

        public Builder withRecoil(float recoil) {
            this.recoil = recoil;
            return this;
        }

        public Builder withZoom(float zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder withAmmo(ItemAmmo ammo) {
            this.ammo = ammo;
            return this;
        }

        public Builder withMaxShots(int maxShots) {
            this.maxShots = maxShots;
            return this;
        }

        public Builder withFireRate(float fireRate) {
            if (fireRate >= 1.0f || fireRate <= 0.0f) {
                throw new IllegalArgumentException("Invalid fire rate " + fireRate);
            }
            this.fireRate = fireRate;
            return this;
        }

        public Builder withTextureNames(String ... textureNames) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            for (String textureName : textureNames) {
                this.textureNames.add(textureName + ".png");
            }
            return this;
        }

        public Builder withCrosshair(String crosshair) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.crosshair = this.modId + ":" + "textures/crosshairs/" + crosshair + ".png";
            return this;
        }

        public Builder withCrosshair(String crosshair, boolean fullScreen) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.crosshair = this.modId + ":" + "textures/crosshairs/" + crosshair + ".png";
            this.crosshairFullScreen = fullScreen;
            return this;
        }

        public Builder withCrosshairRunning(String crosshairRunning) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.crosshairRunning = this.modId + ":" + "textures/crosshairs/" + crosshairRunning + ".png";
            return this;
        }

        public Builder withCrosshairZoomed(String crosshairZoomed) {
            return this.withCrosshairZoomed(crosshairZoomed, true);
        }

        public Builder withCrosshairZoomed(String crosshairZoomed, boolean fullScreen) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.crosshairZoomed = this.modId + ":" + "textures/crosshairs/" + crosshairZoomed + ".png";
            this.crosshairZoomedFullScreen = fullScreen;
            return this;
        }

        public Builder withShootSound(String shootSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.shootSound = this.modId + ":" + shootSound;
            return this;
        }

        public Builder withSilencedShootSound(String silencedShootSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.silencedShootSound = this.modId + ":" + silencedShootSound;
            return this;
        }

        public Builder withReloadSound(String reloadSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.reloadSound = this.modId + ":" + reloadSound;
            return this;
        }

        public Builder withExceededMaxShotsSound(String shootSound) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            this.exceededMaxShotsSound = this.modId + ":" + shootSound;
            return this;
        }

        public Builder withCreativeTab(CreativeTabs creativeTab) {
            this.creativeTab = creativeTab;
            return this;
        }

        public Builder withSpawnEntityDamage(float spawnEntityDamage) {
            this.spawnEntityDamage = spawnEntityDamage;
            return this;
        }

        public Builder withSpawnEntitySpeed(float spawnEntitySpeed) {
            this.spawnEntitySpeed = spawnEntitySpeed;
            return this;
        }

        public Builder withSpawnEntityExplosionRadius(float spawnEntityExplosionRadius) {
            this.spawnEntityExplosionRadius = spawnEntityExplosionRadius;
            return this;
        }

        public Builder withSpawnEntityGravityVelocity(float spawnEntityGravityVelocity) {
            this.spawnEntityGravityVelocity = spawnEntityGravityVelocity;
            return this;
        }

        public Builder withRenderer(IItemRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, Consumer<ModelBase> positioner) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioner));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, boolean isDefault, Consumer<ModelBase> positioner) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioner, isDefault));
            return this;
        }

        public Builder withCompatibleAttachment(AttachmentCategory category, ModelBase attachmentModel, String textureName, Consumer<ModelBase> positioner) {
            ItemAttachment item = new ItemAttachment(this.modId, category, attachmentModel, textureName, null);
            this.compatibleAttachments.put(item, new CompatibleAttachment(item, positioner));
            return this;
        }

        public Builder withCompatibleAttachment(AttachmentCategory category, ModelBase attachmentModel, String textureName, String crosshair, Consumer<ModelBase> positioner) {
            ItemAttachment item = new ItemAttachment(this.modId, category, attachmentModel, textureName, crosshair);
            this.compatibleAttachments.put(item, new CompatibleAttachment(item, positioner));
            return this;
        }

        public Builder withCompatibleAttachment(CompatibleAttachment<Weapon> compatibleAttachment) {
            this.compatibleAttachments.put(compatibleAttachment.getAttachment(), compatibleAttachment);
            return this;
        }

        public Builder withResumeTimeout(int resumeTimeout) {
            this.resumeTimeout = resumeTimeout;
            return this;
        }

        public Builder withSpawnEntityModel(ModelBase ammoModel) {
            this.ammoModel = ammoModel;
            return this;
        }

        public Builder withSpawnEntityModelTexture(String ammoModelTextureName) {
            this.ammoModelTextureName = this.modId + ":" + "textures/models/" + ammoModelTextureName + ".png";
            return this;
        }

        public Builder withSpawnEntityBlockImpactHandler(ImpactHandler impactHandler) {
            this.blockImpactHandler = impactHandler;
            return this;
        }

        public Builder withPumpTimeout(long pumpTimeoutMilliseconds) {
            this.pumpTimeoutMilliseconds = pumpTimeoutMilliseconds;
            return this;
        }

        public Weapon build(ModContext modContext) {
            if (this.modId == null) {
                throw new IllegalStateException("ModId is not set");
            }
            if (this.name == null) {
                throw new IllegalStateException("Weapon name not provided");
            }
            if (this.shootSound == null) {
                this.shootSound = this.modId + ":" + this.name;
            }
            if (this.silencedShootSound == null) {
                this.silencedShootSound = this.shootSound;
            }
            if (this.reloadSound == null) {
                this.reloadSound = this.modId + ":" + "reload";
            }
            if (this.spawnEntityClass == null) {
                this.spawnEntityClass = WeaponSpawnEntity.class;
            }
            if (this.spawnEntityWith == null) {
                this.spawnEntityWith = (weapon, player) -> new WeaponSpawnEntity((Weapon)((Object)weapon), player.field_70170_p, (EntityLivingBase)player, this.spawnEntitySpeed, this.spawnEntityGravityVelocity, this.spawnEntityDamage, this.spawnEntityExplosionRadius, new Material[0]){

                    @Override
                    protected float func_70185_h() {
                        return spawnEntityGravityVelocity;
                    }

                    @Override
                    protected float func_70182_d() {
                        return spawnEntitySpeed;
                    }
                };
            }
            if (this.crosshairRunning == null) {
                this.crosshairRunning = this.crosshair;
            }
            if (this.crosshairZoomed == null) {
                this.crosshairZoomed = this.crosshair;
            }
            if (this.blockImpactHandler == null) {
                this.blockImpactHandler = (world, player, entity, position) -> {
                    Block block = world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d);
                    if (block == Blocks.field_150359_w || block == Blocks.field_150410_aZ || block == Blocks.field_150399_cn || block == Blocks.field_150397_co) {
                        world.func_147480_a(position.field_72311_b, position.field_72312_c, position.field_72309_d, true);
                    }
                };
            }
            Weapon weapon2 = new Weapon(this, modContext);
            weapon2.func_77637_a(this.creativeTab);
            weapon2.func_77655_b(this.name);
            if (this.ammo != null) {
                this.ammo.addCompatibleWeapon(weapon2);
            }
            for (ItemAttachment<Weapon> attachment : this.compatibleAttachments.keySet()) {
                attachment.addCompatibleWeapon(weapon2);
            }
            modContext.registerWeapon(this.name, weapon2, this.renderer);
            return weapon2;
        }
    }
}

