/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.weaponlib;

import com.vicmatskiv.weaponlib.AttachmentCategory;
import com.vicmatskiv.weaponlib.CustomRenderer;
import com.vicmatskiv.weaponlib.Tuple;
import com.vicmatskiv.weaponlib.Weapon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemAttachment<T>
extends Item {
    private AttachmentCategory category;
    private String crosshair;
    private ApplyHandler<T> apply;
    private ApplyHandler<T> remove;
    private List<Tuple<ModelBase, String>> texturedModels = new ArrayList<Tuple<ModelBase, String>>();
    private CustomRenderer postRenderer;
    private CustomRenderer preRenderer;
    private List<Weapon> compatibleWeapons = new ArrayList<Weapon>();

    public ItemAttachment(String modId, AttachmentCategory category, ModelBase attachment, String textureName, String crosshair, ApplyHandler<T> apply, ApplyHandler<T> remove) {
        this.category = category;
        this.texturedModels.add(new Tuple<ModelBase, String>(attachment, textureName));
        this.crosshair = crosshair != null ? modId + ":" + "textures/crosshairs/" + crosshair + ".png" : null;
        this.apply = apply;
        this.remove = remove;
    }

    public ItemAttachment(String modId, AttachmentCategory category, String crosshair, ApplyHandler<T> apply, ApplyHandler<T> remove) {
        this.category = category;
        this.crosshair = crosshair != null ? modId + ":" + "textures/crosshairs/" + crosshair + ".png" : null;
        this.apply = apply;
        this.remove = remove;
    }

    public ItemAttachment<T> addModel(ModelBase model, String textureName) {
        this.texturedModels.add(new Tuple<ModelBase, String>(model, textureName));
        return this;
    }

    public ItemAttachment(String modId, AttachmentCategory category, String crosshair) {
        this(modId, category, crosshair, (ItemAttachment<T> a, T w, EntityPlayer p) -> {}, (ItemAttachment<T> a, T w, EntityPlayer p) -> {});
    }

    public ItemAttachment(String modId, AttachmentCategory category, ModelBase attachment, String textureName, String crosshair) {
        this(modId, category, attachment, textureName, crosshair, (a, w, p) -> {}, (a, w, p) -> {});
    }

    public AttachmentCategory getCategory() {
        return this.category;
    }

    public List<Tuple<ModelBase, String>> getTexturedModels() {
        return this.texturedModels;
    }

    public String getCrosshair() {
        return this.crosshair;
    }

    public ApplyHandler<T> getApply() {
        return this.apply;
    }

    public ApplyHandler<T> getRemove() {
        return this.remove;
    }

    public void addCompatibleWeapon(Weapon weapon) {
        this.compatibleWeapons.add(weapon);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List info, boolean p_77624_4_) {
        info.add("Compatible guns:");
        this.compatibleWeapons.forEach(weapon -> info.add(weapon.getName()));
    }

    public void setPostRenderer(CustomRenderer postRenderer) {
        this.postRenderer = postRenderer;
    }

    public CustomRenderer getPostRenderer() {
        return this.postRenderer;
    }

    public CustomRenderer getPreRenderer() {
        return this.preRenderer;
    }

    public void setPreRenderer(CustomRenderer preRenderer) {
        this.preRenderer = preRenderer;
    }

    public static interface ApplyHandler<T> {
        public void apply(ItemAttachment<T> var1, T var2, EntityPlayer var3);
    }
}

